/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.federation;

import ddf.catalog.data.Result;
import ddf.catalog.operation.Query;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.operation.impl.QueryImpl;
import ddf.catalog.operation.impl.QueryRequestImpl;
import ddf.catalog.operation.impl.QueryResponseImpl;
import ddf.catalog.plugin.PluginExecutionException;
import ddf.catalog.plugin.PostFederatedQueryPlugin;
import ddf.catalog.plugin.PreFederatedQueryPlugin;
import ddf.catalog.plugin.StopProcessingException;
import ddf.catalog.source.Source;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.di2e.ecdr.api.federation.NormalizingFederationStrategy;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFederationStrategy
implements NormalizingFederationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFederationStrategy.class);
    private static final String CLASS_NAME = AbstractFederationStrategy.class.getName();
    private static final int DEFAULT_MAX_START_INDEX = 50000;
    private int maxStartIndex;
    private ExecutorService queryExecutorService = null;
    private List<PreFederatedQueryPlugin> preQuery;
    private List<PostFederatedQueryPlugin> postQuery;

    public AbstractFederationStrategy(ExecutorService executor, List<PreFederatedQueryPlugin> preQuery, List<PostFederatedQueryPlugin> postQuery) {
        this.queryExecutorService = executor;
        this.preQuery = preQuery;
        this.postQuery = postQuery;
        this.maxStartIndex = 50000;
    }

    protected abstract Runnable createMonitor(ExecutorService var1, Map<Source, Future<SourceResponse>> var2, QueryResponseImpl var3, Query var4);

    public QueryResponse federate(List<Source> sources, QueryRequest queryRequest) {
        String methodName = "federate";
        LOGGER.trace("ENTERING: {}", (Object)"federate");
        if (LOGGER.isDebugEnabled()) {
            for (Source source : sources) {
                if (source == null) continue;
                LOGGER.debug("source to query: {}", (Object)source.getId());
            }
        }
        Query originalQuery = queryRequest.getQuery();
        int offset = originalQuery.getStartIndex();
        int pageSize = originalQuery.getPageSize();
        if (offset > this.maxStartIndex) {
            offset = this.maxStartIndex;
        }
        QueryResponseImpl queryResponseQueue = new QueryResponseImpl(queryRequest, null);
        HashMap<Source, Future<SourceResponse>> futures = new HashMap<Source, Future<SourceResponse>>();
        Query modifiedQuery = this.getModifiedQuery(originalQuery, sources.size(), offset, pageSize);
        QueryRequestImpl modifiedQueryRequest = new QueryRequestImpl(modifiedQuery, queryRequest.isEnterprise(), (Collection)queryRequest.getSourceIds(), queryRequest.getProperties());
        for (Source source : sources) {
            if (source == null) continue;
            if (!futures.containsKey(source)) {
                LOGGER.debug("running query on source: " + source.getId());
                try {
                    for (PreFederatedQueryPlugin preFederatedQueryPlugin : this.preQuery) {
                        try {
                            modifiedQueryRequest = preFederatedQueryPlugin.process(source, (QueryRequest)modifiedQueryRequest);
                        }
                        catch (PluginExecutionException e) {
                            LOGGER.warn("Error executing PreFederatedQueryPlugin: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                catch (StopProcessingException e) {
                    LOGGER.warn("Plugin stopped processing: ", (Throwable)e);
                }
                futures.put(source, this.queryExecutorService.submit(new CallableSourceResponse(source, modifiedQueryRequest.getQuery(), modifiedQueryRequest.getProperties())));
                continue;
            }
            LOGGER.warn("Duplicate source found with name " + source.getId() + ". Ignoring second one.");
        }
        QueryResponseImpl offsetResults = null;
        if (offset > 1 && sources.size() > 1) {
            offsetResults = new QueryResponseImpl(queryRequest, null);
            this.queryExecutorService.submit(new OffsetResultHandler(queryResponseQueue, offsetResults, pageSize, offset));
        }
        this.queryExecutorService.submit(this.createMonitor(this.queryExecutorService, futures, queryResponseQueue, modifiedQueryRequest.getQuery()));
        QueryResponseImpl queryResponse = null;
        if (offset > 1 && sources.size() > 1) {
            queryResponse = offsetResults;
            LOGGER.debug("returning offsetResults");
        } else {
            queryResponse = queryResponseQueue;
            LOGGER.debug("returning returnResults: {}", (Object)queryResponse);
        }
        try {
            for (PostFederatedQueryPlugin postFederatedQueryPlugin : this.postQuery) {
                try {
                    queryResponse = postFederatedQueryPlugin.process((QueryResponse)queryResponse);
                }
                catch (PluginExecutionException e) {
                    LOGGER.warn("Error executing PostFederatedQueryPlugin: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (StopProcessingException e) {
            LOGGER.warn("Plugin stopped processing: ", (Throwable)e);
        }
        LOGGER.debug("returning Query Results: {}", (Object)queryResponse);
        LOGGER.trace("EXITING: {}.federate", (Object)CLASS_NAME);
        return queryResponse;
    }

    private Query getModifiedQuery(Query originalQuery, int numberOfSources, int offset, int pageSize) {
        Query query = null;
        if (offset > 1 && numberOfSources > 1) {
            boolean modifiedOffset = true;
            int modifiedPageSize = this.computeModifiedPageSize(offset, pageSize);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating new query for federated sources to query each source from 1 to " + modifiedPageSize + ".");
                LOGGER.debug("original offset: " + offset);
                LOGGER.debug("original page size: " + pageSize);
                LOGGER.debug("modified offset: 1");
                LOGGER.debug("modified page size: " + modifiedPageSize);
            }
            query = new QueryImpl((Filter)originalQuery, 1, modifiedPageSize, originalQuery.getSortBy(), originalQuery.requestsTotalResultsCount(), originalQuery.getTimeoutMillis());
        } else {
            query = originalQuery;
        }
        return query;
    }

    private int computeModifiedPageSize(int offset, int pageSize) {
        return offset + pageSize - 1;
    }

    public void setMaxStartIndex(int maxIndex) {
        LOGGER.debug("Current max start index: " + this.maxStartIndex);
        this.maxStartIndex = 50000;
        if (this.maxStartIndex > 0) {
            this.maxStartIndex = maxIndex;
            LOGGER.debug("New max start index: " + this.maxStartIndex);
        } else {
            LOGGER.debug("Invalid max start index input. Reset to default value: " + this.maxStartIndex);
        }
    }

    private static final class OffsetResultHandler
    implements Runnable {
        private QueryResponseImpl originalResults = null;
        private QueryResponseImpl offsetResultQueue = null;
        private int pageSize = 0;
        private int offset = 1;

        private OffsetResultHandler(QueryResponseImpl originalResults, QueryResponseImpl offsetResultQueue, int pageSize, int offset) {
            this.originalResults = originalResults;
            this.offsetResultQueue = offsetResultQueue;
            this.pageSize = pageSize;
            this.offset = offset;
        }

        @Override
        public void run() {
            int queryResultIndex = 1;
            int resultsSent = 0;
            Result result = null;
            while (resultsSent < this.pageSize && this.originalResults.hasMoreResults()) {
                result = this.originalResults.take();
                if (result == null) continue;
                if (queryResultIndex >= this.offset) {
                    this.offsetResultQueue.addResult(result, false);
                    ++resultsSent;
                }
                ++queryResultIndex;
            }
            LOGGER.debug("Closing Queue and setting the total count");
            this.offsetResultQueue.setHits(this.originalResults.getHits());
            this.offsetResultQueue.closeResultQueue();
        }
    }

    private static final class CallableSourceResponse
    implements Callable<SourceResponse> {
        private Query query = null;
        private Source source = null;
        private Map<String, Serializable> properties = null;

        public CallableSourceResponse(Source source, Query query, Map<String, Serializable> properties) {
            this.source = source;
            this.query = query;
            this.properties = properties;
        }

        @Override
        public SourceResponse call() throws Exception {
            long startTime = System.currentTimeMillis();
            SourceResponse sourceResponse = this.source.query((QueryRequest)new QueryRequestImpl(this.query, this.properties));
            long elapsedTime = System.currentTimeMillis() - startTime;
            LOGGER.debug("The source {} responded to the query in {} milliseconds", (Object)this.source.getId(), (Object)elapsedTime);
            sourceResponse.getProperties().put("elapsed-time", elapsedTime);
            return sourceResponse;
        }
    }
}

