/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.libs.cache.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import ddf.catalog.data.Metacard;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import net.di2e.ecdr.api.cache.Cache;
import net.di2e.ecdr.api.cache.CacheManager;
import net.di2e.ecdr.libs.cache.impl.JCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetacardJCacheManager
implements CacheManager<Metacard> {
    private static final long DEFAULT_CACHE_MINUTES = 60L;
    private static final String CACHE_ID_PREFIX = "jcache-metacard-";
    private static final Logger LOGGER = LoggerFactory.getLogger(MetacardJCacheManager.class);
    private CachingProvider cachingProvider = null;
    private javax.cache.CacheManager cacheManager = null;

    public MetacardJCacheManager() {
        LOGGER.debug("Creating a new JCacheManager for caching Metacards");
        Caching.setDefaultClassLoader((ClassLoader)JCache.class.getClassLoader());
        this.cachingProvider = Caching.getCachingProvider();
        this.cacheManager = this.cachingProvider.getCacheManager(URI.create("ecdr-jcache-cache-manager"), this.getClass().getClassLoader(), this.getConfigProperties());
    }

    private Properties getConfigProperties() {
        Config config = new Config();
        config.setClassLoader(this.getClass().getClassLoader());
        config.setInstanceName("ecdr-jcache-config-instance");
        NetworkConfig networkConfig = config.getNetworkConfig();
        JoinConfig join = networkConfig.getJoin();
        join.getMulticastConfig().setEnabled(false);
        join.getTcpIpConfig().setEnabled(false);
        join.getAwsConfig().setEnabled(false);
        Hazelcast.newHazelcastInstance((Config)config);
        Properties props = new Properties();
        props.setProperty("hazelcast.instance.name", config.getInstanceName());
        return props;
    }

    public Cache<Metacard> createCacheInstance(String cacheId, Map<String, Object> cacheProperties) {
        if (cacheId == null) {
            throw new IllegalArgumentException("CacheId cannot be null when calling the MetacardJCacheManager.createCache method");
        }
        if (this.cacheManager.getCache(CACHE_ID_PREFIX + cacheId) != null) {
            throw new IllegalArgumentException("CacheId with the name [" + cacheId + "] already exists, each cache instance must have a unique name");
        }
        MutableConfiguration config = new MutableConfiguration();
        config.setStoreByValue(true).setTypes(String.class, Metacard.class).setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)this.getDuration(cacheProperties))).setStatisticsEnabled(true);
        javax.cache.Cache cache = this.cacheManager.createCache(CACHE_ID_PREFIX + cacheId, (Configuration)config);
        JCache<Metacard> jcache = new JCache<Metacard>(cache);
        return jcache;
    }

    public void destroy() {
        LOGGER.debug("Destroying all active caches and destroying the Cache Manager");
        for (String cacheId : this.cacheManager.getCacheNames()) {
            this.cacheManager.destroyCache(CACHE_ID_PREFIX + cacheId);
        }
        this.cacheManager.close();
        this.cachingProvider.close();
        Hazelcast.shutdownAll();
    }

    public void removeCacheInstance(String cacheId) {
        LOGGER.debug("Removing the cache instance [{}]", (Object)cacheId);
        this.cacheManager.destroyCache(CACHE_ID_PREFIX + cacheId);
    }

    protected Duration getDuration(Map<String, Object> cacheProperties) {
        Object minutes;
        Duration duration = null;
        if (cacheProperties != null && (minutes = cacheProperties.get("cache-expire-after-minutes")) != null) {
            if (minutes instanceof Long) {
                LOGGER.debug("Setting cache duration of newly created cache to [{}] minutes", minutes);
                duration = new Duration(TimeUnit.MINUTES, ((Long)minutes).longValue());
            } else {
                LOGGER.warn("Cache property [{}] was not the expected type of Long, instead it was [{}]", (Object)"cache-expire-after-minutes", (Object)minutes.getClass().getName());
            }
        }
        if (duration == null) {
            LOGGER.debug("Duration was not passed into cache creation, so defaulting to cache of 60 minutes");
            duration = new Duration(TimeUnit.MINUTES, 60L);
        }
        return duration;
    }
}

