/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.libs.cache.impl;

import ddf.catalog.data.Metacard;
import java.util.HashMap;
import java.util.Map;
import net.di2e.ecdr.api.cache.Cache;
import net.di2e.ecdr.api.cache.CacheManager;
import net.di2e.ecdr.libs.cache.impl.MemoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetacardMemoryCacheManager
implements CacheManager<Metacard> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetacardMemoryCacheManager.class);
    private Map<String, Cache<Metacard>> cacheList = new HashMap<String, Cache<Metacard>>();

    public MetacardMemoryCacheManager() {
        LOGGER.debug("Creating a new LRUMetacardCacheManager for Metacard cache");
    }

    public Cache<Metacard> createCacheInstance(String cacheId, Map<String, Object> cacheProperties) {
        if (cacheId == null) {
            throw new IllegalArgumentException("CacheId cannot be null when calling the LRUCache.createCache method");
        }
        if (this.cacheList.containsKey(cacheId)) {
            throw new IllegalArgumentException("CacheId with the name [" + cacheId + "] already exists, each cache instance must have a unique name");
        }
        MemoryCache<Metacard> cache = new MemoryCache<Metacard>(this.getSize(cacheProperties));
        this.cacheList.put(cacheId, cache);
        return cache;
    }

    public void destroy() {
        LOGGER.debug("Destroying all active caches and destroying the Cache Manager");
        for (Map.Entry<String, Cache<Metacard>> entry : this.cacheList.entrySet()) {
            entry.getValue().destroy();
        }
        this.cacheList.clear();
    }

    public void removeCacheInstance(String cacheId) {
        LOGGER.debug("Removing the cache instance [{}]", (Object)cacheId);
        this.cacheList.remove(cacheId);
    }

    protected int getSize(Map<String, Object> cacheProperties) {
        Object cacheSize;
        int size = -1;
        if (cacheProperties != null && (cacheSize = cacheProperties.get("cache-size")) != null) {
            if (cacheSize instanceof Integer) {
                LOGGER.debug("Setting cache maximum size of newly created cache to [{}] entries", cacheSize);
                size = (Integer)cacheSize;
            } else {
                LOGGER.warn("Cache property [{}] was not the expected type of Integer, instead it was [{}]", (Object)"cache-size", (Object)cacheSize.getClass().getName());
            }
        }
        if (size < 0) {
            size = 5000;
            LOGGER.debug("Duration was not passed into cache creation, so defaulting to cache of [{}] minutes", (Object)size);
        }
        return size;
    }
}

