/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.libs.cache.impl;

import net.di2e.ecdr.api.cache.QueryRequestCache;
import net.di2e.ecdr.libs.cache.impl.MemoryCache;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRequestCacheImpl
extends MemoryCache<Boolean>
implements QueryRequestCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRequestCacheImpl.class);

    public QueryRequestCacheImpl() {
        super(1000);
    }

    public QueryRequestCacheImpl(int cacheSize) {
        super(cacheSize);
    }

    public boolean isQueryIdUnique(String id) {
        boolean unique = true;
        if (StringUtils.isNotBlank((String)id)) {
            if (this.containsKey(id)) {
                unique = false;
            } else {
                this.add(id);
            }
        }
        LOGGER.debug("Checking uniqueness of query with oid=[{}] and returning value for isUnique={}", (Object)id, (Object)unique);
        return unique;
    }

    public void setQueryRequestCacheSize(int capacity) {
        this.updateCacheSize(capacity);
    }

    public void add(String id) {
        this.put(id, Boolean.TRUE);
    }
}

