/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.libs.result.relevance;

import ddf.catalog.data.Result;
import ddf.catalog.data.impl.ResultImpl;
import ddf.catalog.filter.FilterAdapter;
import ddf.catalog.filter.FilterDelegate;
import ddf.catalog.source.UnsupportedQueryException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.di2e.ecdr.commons.filter.AbstractFilterDelegate;
import net.di2e.ecdr.commons.filter.StrictFilterDelegate;
import net.di2e.ecdr.libs.result.relevance.TextParser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelevanceNormalizer {
    public static final String RELEVANCE_TIMER = "RELEVANCE TIMER:";
    private static final Logger LOGGER = LoggerFactory.getLogger(RelevanceNormalizer.class);
    private static final String METADATA_FIELD = "metadata";
    private static final String ID_FIELD = "id";
    private FilterAdapter filterAdapter;

    public RelevanceNormalizer(FilterAdapter filterAdapter) {
        this.filterAdapter = filterAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Result> normalize(List<Result> results, ddf.catalog.operation.Query originalQuery) {
        SortBy sortBy = originalQuery.getSortBy();
        if (sortBy == null || sortBy.getPropertyName() == null || sortBy.getPropertyName().getPropertyName() == null || "RELEVANCE".equals(sortBy.getPropertyName().getPropertyName())) {
            Map<String, String> filterParameters = this.getFilterParameters(originalQuery);
            if (this.canNormalizeQuery(filterParameters)) {
                ArrayList<Result> arrayList;
                LOGGER.debug("Query contained search phrase and will be sorted by relevance, performing re-indexing to normalize relevance.");
                RAMDirectory directory = null;
                DirectoryReader iReader = null;
                HashMap<String, Result> docMap = new HashMap<String, Result>();
                ArrayList<Result> updatedResults = new ArrayList<Result>();
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                try {
                    StandardAnalyzer analyzer = new StandardAnalyzer();
                    directory = new RAMDirectory();
                    IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, (Analyzer)analyzer);
                    IndexWriter iWriter = new IndexWriter((Directory)directory, config);
                    for (Result curResult : results) {
                        Document doc = new Document();
                        String text = TextParser.parseTextFrom(curResult.getMetacard().getMetadata());
                        String uuid = UUID.randomUUID().toString();
                        doc.add((IndexableField)new Field(METADATA_FIELD, text, TextField.TYPE_STORED));
                        doc.add((IndexableField)new Field(ID_FIELD, uuid, TextField.TYPE_STORED));
                        iWriter.addDocument((Iterable)doc);
                        docMap.put(uuid, curResult);
                    }
                    IOUtils.closeQuietly((Closeable)iWriter);
                    LOGGER.debug("{} Document indexing finished in {} seconds.", (Object)RELEVANCE_TIMER, (Object)((double)stopWatch.getTime() / 1000.0));
                    iReader = DirectoryReader.open((Directory)directory);
                    IndexSearcher iSearcher = new IndexSearcher((IndexReader)iReader);
                    QueryParser parser = new QueryParser(METADATA_FIELD, (Analyzer)analyzer);
                    Query query = this.getQuery(parser, filterParameters);
                    ScoreDoc[] hits = iSearcher.search((Query)query, null, (int)docMap.size()).scoreDocs;
                    LOGGER.debug("Got back {} results", (Object)hits.length);
                    for (ScoreDoc curHit : hits) {
                        Document doc = iSearcher.doc(curHit.doc);
                        String uuid = doc.getField(ID_FIELD).stringValue();
                        Result result = (Result)docMap.get(uuid);
                        docMap.remove(uuid);
                        updatedResults.add(this.updateResult(result, curHit.score));
                        LOGGER.debug("Relevance for result {} was changed FROM {} TO {}", new Object[]{result.getMetacard().getId(), result.getRelevanceScore(), Float.valueOf(curHit.score)});
                    }
                    for (Map.Entry curEntry : docMap.entrySet()) {
                        updatedResults.add(this.updateResult((Result)curEntry.getValue(), 0.0f));
                    }
                    arrayList = updatedResults;
                }
                catch (IOException | RuntimeException | ParseException e) {
                    List<Result> list;
                    try {
                        LOGGER.warn("Received an exception while trying to perform re-indexing, sending original queryResponse on.", e);
                        list = results;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(iReader);
                        IOUtils.closeQuietly(directory);
                        stopWatch.stop();
                        LOGGER.debug("{} Total relevance process took {} seconds.", (Object)RELEVANCE_TIMER, (Object)((double)stopWatch.getTime() / 1000.0));
                        throw throwable;
                    }
                    IOUtils.closeQuietly(iReader);
                    IOUtils.closeQuietly((Closeable)directory);
                    stopWatch.stop();
                    LOGGER.debug("{} Total relevance process took {} seconds.", (Object)RELEVANCE_TIMER, (Object)((double)stopWatch.getTime() / 1000.0));
                    return list;
                }
                IOUtils.closeQuietly((Closeable)iReader);
                IOUtils.closeQuietly((Closeable)directory);
                stopWatch.stop();
                LOGGER.debug("{} Total relevance process took {} seconds.", (Object)RELEVANCE_TIMER, (Object)((double)stopWatch.getTime() / 1000.0));
                return arrayList;
            }
            LOGGER.debug("Query is not sorted based on relevance with contextual criteria. Skipping relevance normalization.");
        } else {
            LOGGER.debug("Query is not sorted based on relevance with contextual criteria. Skipping relevance normalization.");
        }
        return results;
    }

    protected boolean canNormalizeQuery(Map<String, String> filterParameters) {
        return StringUtils.isNotBlank((String)this.getSearchPhrase(filterParameters));
    }

    protected Query getQuery(QueryParser parser, Map<String, String> filterParameters) throws ParseException {
        String searchPhrase = this.getSearchPhrase(filterParameters);
        Query query = parser.parse(searchPhrase);
        if (filterParameters.containsKey("fuzzy") && StringUtils.equals((String)filterParameters.get("fuzzy"), (String)"1")) {
            if (query instanceof BooleanQuery) {
                BooleanQuery booleanQuery = (BooleanQuery)query;
                for (BooleanClause clause : booleanQuery.getClauses()) {
                    if (!(clause.getQuery() instanceof TermQuery)) continue;
                    TermQuery oldQuery = (TermQuery)clause.getQuery();
                    FuzzyQuery newQuery = new FuzzyQuery(oldQuery.getTerm());
                    clause.setQuery((Query)newQuery);
                }
            } else {
                LOGGER.debug("Query was too complex for adding fuzzy. Expected BooleanQuery but ended up being of type {}", (Object)query.getClass().getName());
            }
        }
        return query;
    }

    protected String getSearchPhrase(Map<String, String> filterParameters) {
        String searchPhrase = null;
        if (filterParameters.containsKey("q")) {
            searchPhrase = filterParameters.get("q");
        }
        return searchPhrase;
    }

    protected Map<String, String> getFilterParameters(ddf.catalog.operation.Query originalQuery) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.putAll((Map)this.filterAdapter.adapt((Filter)originalQuery, (FilterDelegate)new StrictFilterDelegate(false, AbstractFilterDelegate.SupportedGeosOptions.ALL, Collections.emptyMap(), Collections.emptyMap())));
        }
        catch (UnsupportedQueryException uqe) {
            LOGGER.debug("Query did not contain any contextual criteria (search phrases), cannot perform re-relevance on this query.");
        }
        return map;
    }

    protected Result updateResult(Result origResult, float newScore) {
        ResultImpl result = new ResultImpl(origResult.getMetacard());
        result.setRelevanceScore(Double.valueOf(newScore));
        result.setDistanceInMeters(origResult.getDistanceInMeters());
        return result;
    }
}

