/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons;

import ddf.catalog.data.Attribute;
import ddf.catalog.data.AttributeDescriptor;
import ddf.catalog.data.BinaryContent;
import ddf.catalog.data.Metacard;
import ddf.catalog.data.MetacardType;
import ddf.catalog.data.impl.AttributeImpl;
import ddf.catalog.data.impl.MetacardTypeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import net.di2e.ecdr.commons.CDRMetacardType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;

public class CDRMetacard
implements Metacard,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Attribute> map = new HashMap<String, Attribute>();
    private transient Metacard wrappedMetacard;
    private transient MetacardType type;
    private String sourceId;
    public static final String METACARD_CONTENT_COLLECTION_ATTRIBUTE = "content-collections";
    public static final String RESOURCE_MIME_TYPE = "resource-mime-type";
    public static final String RESOURCE_TITLE = "resource-title";
    static final String THUMBNAIL_LINK = "thumbnail-link";
    public static final String THUMBNAIL_LENGTH = "thumbnail-length";
    public static final String THUMBNAIL_MIMETYPE = "thumbnail-mimetype";
    public static final String THUMBNAIL_LINK_TITLE = "thumbnail-link-title";
    static final String METADATA_LINK = "metadata-link";
    public static final String WRAP_METADATA = "wrap-metadata";
    private static final String THUMBNAIL_N_A = "N/A";
    private static final XLogger LOGGER = new XLogger(LoggerFactory.getLogger(CDRMetacard.class));

    public CDRMetacard() {
        this(CDRMetacardType.CDR_METACARD);
    }

    public CDRMetacard(MetacardType mt) {
        if (mt == null) {
            throw new IllegalArgumentException(MetacardType.class.getName() + " instance should not be null.");
        }
        this.type = mt;
    }

    public CDRMetacard(Metacard metacard) {
        this(CDRMetacardType.CDR_METACARD);
        if (metacard instanceof CDRMetacard) {
            this.map.putAll(((CDRMetacard)metacard).getMap());
            this.setSourceId(metacard.getSourceId());
        } else {
            this.wrappedMetacard = metacard;
            if (metacard.getMetacardType() != null) {
                this.type = metacard.getMetacardType();
            } else {
                throw new IllegalArgumentException(MetacardType.class.getName() + " instance should not be null.");
            }
        }
    }

    public Map<String, Attribute> getMap() {
        return this.map;
    }

    public boolean hasLocation() {
        return this.getLocation() != null;
    }

    public boolean hasResource() {
        return this.getResourceURI() != null;
    }

    public String getResourceMIMETypeString() {
        Serializable mimeType;
        Attribute attribute = this.getAttribute(RESOURCE_MIME_TYPE);
        if (attribute != null && (mimeType = attribute.getValue()) != null && mimeType instanceof String) {
            return (String)((Object)mimeType);
        }
        return "application/unknown";
    }

    public long getResourceSizeLong() {
        String size = this.getResourceSize();
        if (StringUtils.isNotBlank((String)size)) {
            try {
                return Long.parseLong(this.getResourceSize());
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Could not parse resource size into integer from Metacard: " + size);
            }
        }
        return -1L;
    }

    public boolean hasThumbnail() {
        return this.getAttribute(THUMBNAIL_LINK) != null || this.getThumbnail() != null;
    }

    public long getThumbnailLength() {
        long thumbnailSize = -1L;
        Attribute attribute = this.getAttribute(THUMBNAIL_LENGTH);
        if (attribute != null) {
            thumbnailSize = (Long)attribute.getValue();
        }
        if (thumbnailSize < 0L) {
            byte[] thumbnail = this.getThumbnail();
            thumbnailSize = thumbnail == null ? -1L : (long)thumbnail.length;
        }
        return thumbnailSize;
    }

    public String getAtomId() {
        return "urn:catalog:id:" + this.getId();
    }

    public URI getMetadataURL() {
        URI uri = null;
        String data = this.requestString(METADATA_LINK);
        if (data != null) {
            try {
                uri = new URI(data);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("failed parsing URI string, returning null");
            }
        }
        return uri;
    }

    public URI getThumbnailURL() {
        URI uri = null;
        String data = this.requestString(THUMBNAIL_LINK);
        if (data != null) {
            try {
                uri = new URI(data);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("failed parsing URI string, returning null");
            }
        }
        return uri;
    }

    public MimeType getThumbnailMIMEType() {
        Attribute attribute = this.getAttribute(THUMBNAIL_MIMETYPE);
        if (attribute != null) {
            return (MimeType)attribute.getValue();
        }
        return null;
    }

    public String getThumbnailLinkTitle() {
        Attribute attribute = this.getAttribute(THUMBNAIL_LINK_TITLE);
        if (attribute != null) {
            return (String)((Object)attribute.getValue());
        }
        return null;
    }

    public String getMetadata() {
        Attribute metadataAttribute;
        String metadata = null;
        Attribute attribute = metadataAttribute = this.wrappedMetacard != null ? this.wrappedMetacard.getAttribute("metadata") : this.map.get("metadata");
        if (metadataAttribute == null || StringUtils.isBlank((String)this.getAttributeValue(metadataAttribute, String.class))) {
            URI metadataURI = this.getMetadataURL();
            if (metadataURI != null) {
                try (InputStream in = metadataURI.toURL().openStream();){
                    metadata = IOUtils.toString((InputStream)in);
                    if (this.getAttribute(WRAP_METADATA) != null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("<xml>");
                        sb.append(metadata);
                        sb.append("</xml>");
                        metadata = sb.toString();
                    }
                    this.setAttribute((Attribute)new AttributeImpl("metadata", (Serializable)((Object)metadata)));
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("Cannot read metadata due to Invalid metadata URL[" + metadataURI + "]: " + e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.warn("Could not read metadata from remote URL[" + metadataURI + "] due to: " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            metadata = this.getAttributeValue(metadataAttribute, String.class);
        }
        return metadata;
    }

    public Date getModifiedDate() {
        Date modified = this.requestDate("modified");
        return modified == null ? new Date() : modified;
    }

    public String getResourceSize() {
        String size = this.requestString("resource-size");
        return StringUtils.isNotBlank((String)size) && !THUMBNAIL_N_A.equalsIgnoreCase(size) ? size : null;
    }

    public byte[] getThumbnail() {
        Attribute thumbnailAttribute;
        byte[] thumbnail = null;
        Attribute attribute = thumbnailAttribute = this.wrappedMetacard != null ? this.wrappedMetacard.getAttribute("thumbnail") : this.map.get("thumbnail");
        if (thumbnailAttribute == null || this.getAttributeValue(thumbnailAttribute, byte[].class) == null) {
            URI thumbnailURI = this.getThumbnailURL();
            if (thumbnailURI != null) {
                try (InputStream in = thumbnailURI.toURL().openStream();){
                    thumbnail = IOUtils.toByteArray((InputStream)in);
                    this.setAttribute((Attribute)new AttributeImpl("thumbnail", (Serializable)thumbnail));
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("Cannot read thumbnail due to invalid thumbnail URL[" + thumbnailURI + "]: " + e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.warn("Could not read thumbnail from remote URL[" + thumbnailURI + "] due to: " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            thumbnail = this.getAttributeValue(thumbnailAttribute, byte[].class);
        }
        return thumbnail;
    }

    public String getTitle() {
        String title = this.requestString("title");
        return title == null ? "No Title" : title;
    }

    public Date getCreatedDate() {
        return this.requestDate("created");
    }

    public void setCreatedDate(Date created) {
        this.setAttribute("created", created);
    }

    public void setModifiedDate(Date modified) {
        this.setAttribute("modified", modified);
    }

    public Date getExpirationDate() {
        return this.requestDate("expiration");
    }

    public void setExpirationDate(Date expiration) {
        this.setAttribute("expiration", expiration);
    }

    public Date getEffectiveDate() {
        return this.requestDate("effective");
    }

    public void setEffectiveDate(Date effective) {
        this.setAttribute("effective", effective);
    }

    public String getId() {
        return this.requestString("id");
    }

    public void setId(String id) {
        this.setAttribute("id", (Serializable)((Object)id));
    }

    public String getLocation() {
        return this.requestString("location");
    }

    public void setLocation(String wkt) {
        this.setAttribute("location", (Serializable)((Object)wkt));
    }

    public String getSourceId() {
        return this.wrappedMetacard != null ? this.wrappedMetacard.getSourceId() : this.sourceId;
    }

    public void setSourceId(String id) {
        if (this.wrappedMetacard != null) {
            this.wrappedMetacard.setSourceId(id);
        } else {
            this.sourceId = id;
        }
    }

    public void setThumbnail(byte[] bytes) {
        this.setAttribute("thumbnail", (Serializable)bytes);
    }

    public void setTitle(String title) {
        this.setAttribute("title", (Serializable)((Object)title));
    }

    public void setMetadata(String metadata) {
        this.setAttribute("metadata", (Serializable)((Object)metadata));
    }

    public MetacardType getMetacardType() {
        return this.type;
    }

    public void setType(MetacardType mt) {
        this.type = mt;
    }

    public URI getContentTypeNamespace() {
        URI uri = null;
        String uriString = this.requestString("metadata-target-namespace");
        if (uriString != null && !uriString.isEmpty()) {
            uri = URI.create(uriString);
        }
        return uri;
    }

    public void setTargetNamespace(URI targetNamespace) {
        this.setAttribute("metadata-target-namespace", (Serializable)((Object)targetNamespace.toASCIIString()));
    }

    public String getContentTypeName() {
        String content = this.requestString("metadata-content-type");
        return StringUtils.isNotBlank((String)content) ? content : "Unknown";
    }

    public void setContentTypeName(String contentType) {
        this.setAttribute("metadata-content-type", (Serializable)((Object)contentType));
    }

    public String getContentTypeVersion() {
        String version = this.requestString("metadata-content-type-version");
        return StringUtils.isNotBlank((String)version) ? version : "Unknown";
    }

    public void setContentTypeVersion(String contentTypeVersion) {
        this.setAttribute("metadata-content-type-version", (Serializable)((Object)contentTypeVersion));
    }

    public URI getResourceURI() {
        URI uri = null;
        String data = this.requestString("resource-uri");
        if (data != null) {
            try {
                uri = new URI(data);
            }
            catch (URISyntaxException e) {
                LOGGER.warn("failed parsing URI string, returning null");
            }
        }
        return uri;
    }

    public void setResourceURI(URI uri) {
        if (uri == null) {
            return;
        }
        this.setAttribute("resource-uri", (Serializable)((Object)uri.toString()));
    }

    public void setMetadataLinkURI(URI uri) {
        if (uri == null) {
            return;
        }
        this.setAttribute(METADATA_LINK, (Serializable)((Object)uri.toString()));
    }

    public void setThumbnailLinkURI(URI uri) {
        if (uri == null) {
            return;
        }
        this.setAttribute(THUMBNAIL_LINK, (Serializable)((Object)uri.toString()));
    }

    public void setResourceSize(String dadSize) {
        this.setAttribute("resource-size", (Serializable)((Object)dadSize));
    }

    public Map<String, List<String>> getSecurity() {
        return this.requestData("security", HashMap.class);
    }

    public void setSecurity(HashMap<String, List<String>> security) {
        this.setAttribute("security", security);
    }

    protected <T> T requestData(String attributeName, Class<T> returnType) {
        Attribute attribute = this.getAttribute(attributeName);
        if (attribute == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Attribute " + attributeName + " was not found, returning null");
            }
            return null;
        }
        return this.getAttributeValue(attribute, returnType);
    }

    protected <T> T getAttributeValue(Attribute attribute, Class<T> returnType) {
        Serializable data = attribute.getValue();
        if (returnType.isAssignableFrom(data.getClass())) {
            return returnType.cast(data);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.trace(data.getClass().toString() + " can not be assigned to " + returnType.toString());
        }
        return null;
    }

    protected Date requestDate(String key) {
        return this.requestData(key, Date.class);
    }

    protected Double requestDouble(String key) {
        return this.requestData(key, Double.class);
    }

    protected InputStream requestInputStream(String key) {
        BinaryContent data = this.requestData(key, BinaryContent.class);
        if (data != null) {
            return data.getInputStream();
        }
        return null;
    }

    protected Integer requestInteger(String key) {
        return this.requestData(key, Integer.class);
    }

    protected Long requestLong(String key) {
        return this.requestData(key, Long.class);
    }

    protected String requestString(String key) {
        return this.requestData(key, String.class);
    }

    protected byte[] requestBytes(String key) {
        return this.requestData(key, byte[].class);
    }

    public Attribute getAttribute(String name) {
        if ("thumbnail".equals(name)) {
            return new AttributeImpl(name, (Serializable)this.getThumbnail());
        }
        if ("metadata".equals(name)) {
            return new AttributeImpl(name, (Serializable)((Object)this.getMetadata()));
        }
        return this.wrappedMetacard != null ? this.wrappedMetacard.getAttribute(name) : this.map.get(name);
    }

    public void setAttribute(String name, Serializable value) {
        this.setAttribute((Attribute)new AttributeImpl(name, value));
    }

    public void setAttribute(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.wrappedMetacard != null) {
            this.wrappedMetacard.setAttribute(attribute);
        } else {
            String name = attribute.getName();
            Serializable value = attribute.getValue();
            if (name != null) {
                if (value != null) {
                    this.map.put(name, attribute);
                } else {
                    this.map.remove(name);
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        block8: {
            block7: {
                stream.defaultWriteObject();
                if (this.type instanceof MetacardTypeImpl) {
                    stream.writeObject(this.type);
                } else {
                    MetacardTypeImpl mt = new MetacardTypeImpl(this.type.getName(), this.type.getAttributeDescriptors());
                    stream.writeObject(mt);
                }
                if (this.map == null) break block7;
                stream.writeInt(this.map.size());
                for (Attribute attribute : this.map.values()) {
                    stream.writeObject(attribute);
                }
                break block8;
            }
            if (this.wrappedMetacard == null || this.wrappedMetacard.getMetacardType() == null) break block8;
            MetacardType metacardType = this.wrappedMetacard.getMetacardType();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            if (metacardType.getAttributeDescriptors() == null) {
                stream.writeInt(0);
            } else {
                for (AttributeDescriptor ad : metacardType.getAttributeDescriptors()) {
                    Attribute attribute = this.wrappedMetacard.getAttribute(ad.getName());
                    if (attribute == null) continue;
                    attributes.add(attribute);
                }
                stream.writeInt(attributes.size());
                for (Attribute attribute : attributes) {
                    stream.writeObject(attribute);
                }
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.map = new HashMap<String, Attribute>();
        this.wrappedMetacard = null;
        this.type = (MetacardType)stream.readObject();
        if (this.type == null) {
            throw new InvalidObjectException(MetacardType.class.getName() + " instance cannot be null.");
        }
        int numElements = stream.readInt();
        for (int i = 0; i < numElements; ++i) {
            AttributeDescriptor attributeDescriptor;
            Attribute attribute = (Attribute)stream.readObject();
            if (attribute != null && (attributeDescriptor = this.getMetacardType().getAttributeDescriptor(attribute.getName())) != null && attribute.getValue() != null) {
                attributeDescriptor.getType().getAttributeFormat();
                attributeDescriptor.getType().getClass();
            }
            this.setAttribute(attribute);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).append((Object)this.getMetacardType()).append((Object)this.getMetadata()).toHashCode();
    }
}

