/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.endpoint.rest;

import ddf.catalog.CatalogFramework;
import ddf.catalog.data.BinaryContent;
import ddf.catalog.federation.FederationException;
import ddf.catalog.operation.QueryResponse;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.source.SourceUnavailableException;
import ddf.catalog.source.UnsupportedQueryException;
import ddf.catalog.transform.CatalogTransformerException;
import ddf.registry.api.RegistrableService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.di2e.ecdr.api.auditor.SearchAuditor;
import net.di2e.ecdr.api.cache.QueryRequestCache;
import net.di2e.ecdr.api.query.QueryConfiguration;
import net.di2e.ecdr.api.query.QueryCriteria;
import net.di2e.ecdr.api.query.QueryLanguage;
import net.di2e.ecdr.api.transform.TransformIdMapper;
import net.di2e.ecdr.commons.query.CDRQueryImpl;
import net.di2e.ecdr.commons.util.SearchUtils;
import net.di2e.ecdr.commons.xml.fs.SourceDescription;
import net.di2e.ecdr.commons.xml.osd.OpenSearchDescription;
import net.di2e.ecdr.commons.xml.osd.Query;
import net.di2e.ecdr.commons.xml.osd.SyndicationRight;
import net.di2e.ecdr.commons.xml.osd.Url;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestSearchEndpoint
implements RegistrableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRestSearchEndpoint.class);
    private static final int DEFAULT_QUERYID_CACHE_SIZE = 1000;
    private QueryRequestCache queryRequestCache = null;
    private CatalogFramework catalogFramework = null;
    private ConfigurationWatcherImpl platformConfig = null;
    private List<SearchAuditor> auditors = null;
    private List<QueryLanguage> queryLanguageList = null;
    private QueryConfiguration queryConfiguration = null;
    private TransformIdMapper transformMapper = null;

    public AbstractRestSearchEndpoint(CatalogFramework framework, ConfigurationWatcherImpl config, List<QueryLanguage> queryLangs, TransformIdMapper mapper, List<SearchAuditor> auditorList, QueryConfiguration queryConfig, QueryRequestCache queryReqCache) {
        this.catalogFramework = framework;
        this.platformConfig = config;
        this.queryLanguageList = queryLangs;
        this.transformMapper = mapper;
        this.auditors = auditorList;
        this.queryConfiguration = queryConfig;
        this.queryRequestCache = queryReqCache;
    }

    public Response executePing(UriInfo uriInfo, String encodingHeader, String authHeader) {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        boolean isValid = this.isValidQuery((MultivaluedMap<String, String>)queryParams, this.platformConfig.getSiteName());
        return isValid ? Response.ok().build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    protected QueryLanguage getQueryLanguage(MultivaluedMap<String, String> queryParams) {
        String lang = StringUtils.defaultIfBlank((String)((String)queryParams.getFirst((Object)"queryLanguage")), (String)this.queryConfiguration.getDefaultQueryLanguage());
        LOGGER.debug("Using query language that is associated with the name [{}]", (Object)lang);
        for (QueryLanguage queryLang : this.queryLanguageList) {
            if (!StringUtils.equalsIgnoreCase((String)queryLang.getName(), (String)lang)) continue;
            return queryLang;
        }
        return null;
    }

    public Response executeSearch(HttpServletRequest servletRequest, UriInfo uriInfo, String encoding, String auth) {
        Response response;
        QueryResponse queryResponse = null;
        try {
            String localSourceId = this.platformConfig.getSiteName();
            MultivaluedMap queryParameters = uriInfo.getQueryParameters();
            this.addHeaderParameters(servletRequest, (MultivaluedMap<String, String>)queryParameters);
            if (!this.isValidQuery((MultivaluedMap<String, String>)queryParameters, localSourceId)) {
                throw new UnsupportedQueryException("Invalid query parameters passed in");
            }
            QueryLanguage queryLanguage = this.getQueryLanguage((MultivaluedMap<String, String>)queryParameters);
            if (queryLanguage == null) {
                throw new UnsupportedQueryException("A Query language could not be determined, please check the default query langauge in the Admin Console ECDR Applicaiton Search Endpoint settings");
            }
            QueryCriteria queryCriteria = queryLanguage.getQueryCriteria(queryParameters, this.queryConfiguration);
            CDRQueryImpl query = new CDRQueryImpl(queryCriteria, localSourceId);
            queryResponse = this.executeQuery(localSourceId, (MultivaluedMap<String, String>)queryParameters, query);
            Map<String, Serializable> transformProperties = SearchUtils.getTransformLinkProperties(uriInfo, query, queryResponse, this.platformConfig.getSchemeFromProtocol(), this.platformConfig.getHostname(), this.platformConfig.getPort());
            transformProperties.put("feed-title", (Serializable)((Object)("Atom Search Results from '" + localSourceId + "' for Query: " + query.getHumanReadableQuery().trim())));
            transformProperties.put("format", (Serializable)((Object)query.getResponseFormat()));
            transformProperties.put("status", Boolean.valueOf(this.isIncludeStatus((MultivaluedMap<String, String>)queryParameters)));
            transformProperties.put("local-source-id", (Serializable)((Object)this.catalogFramework.getId()));
            transformProperties.put("georssFormat", (Serializable)((Object)this.getGeoRSSFormat((MultivaluedMap<String, String>)queryParameters)));
            String format = query.getResponseFormat();
            String internalTransformerFormat = this.transformMapper.getQueryResponseTransformValue(format);
            transformProperties.put("metacard-transformer-name", (Serializable)((Object)this.transformMapper.getMetacardTransformValue(format)));
            BinaryContent content = this.catalogFramework.transform((SourceResponse)queryResponse, internalTransformerFormat, transformProperties);
            try (InputStream is = content.getInputStream();){
                response = Response.ok((Object)is, (String)content.getMimeTypeValue()).build();
            }
            catch (IOException e) {
                LOGGER.error("Error reading response [" + e.getMessage() + "]", (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        catch (UnsupportedQueryException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (SourceUnavailableException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (FederationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (CatalogTransformerException | IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected exception received [" + e.getMessage() + "]", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        for (SearchAuditor auditor : this.auditors) {
            auditor.auditRESTQuery(servletRequest, queryResponse, response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/osd.xml")
    @Produces(value={"application/opensearchdescription+xml"})
    public Response getOSD() {
        Response response;
        OpenSearchDescription osd = new OpenSearchDescription();
        osd.setShortName(this.platformConfig.getSiteName());
        osd.setDescription(this.getServiceDescription());
        osd.setTags("ecdr opensearch cdr ddf");
        if (StringUtils.isNotBlank((String)this.platformConfig.getOrganization())) {
            osd.setDeveloper(this.platformConfig.getOrganization());
        }
        if (StringUtils.isNotBlank((String)this.platformConfig.getContactEmailAddress())) {
            osd.setContact(this.platformConfig.getContactEmailAddress());
        }
        Query query = new Query();
        query.setRole("example");
        query.setSearchTerms("test");
        osd.getQuery().add(query);
        osd.setSyndicationRight(SyndicationRight.OPEN);
        osd.getLanguage().add("*");
        osd.getInputEncoding().add(StandardCharsets.UTF_8.name());
        osd.getOutputEncoding().add(StandardCharsets.UTF_8.name());
        for (QueryLanguage lang : this.queryLanguageList) {
            Url url = new Url();
            url.setType("application/atom+xml");
            url.setTemplate(this.generateTemplateUrl(lang));
            osd.getUrl().add(url);
        }
        this.addSourceDescriptions(osd);
        StringWriter writer = new StringWriter();
        InputStream is = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{OpenSearchDescription.class, SourceDescription.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)osd, (Writer)writer);
            is = this.getClass().getResourceAsStream("/templates/osd_info.template");
            if (is != null) {
                String osdTemplate = IOUtils.toString((InputStream)is);
                osdTemplate = this.replaceTemplateValues(osdTemplate);
                String responseStr = osdTemplate + writer.toString();
                Response response2 = Response.ok((Object)responseStr, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
                IOUtils.closeQuietly((InputStream)is);
                return response2;
            }
            response = Response.serverError().entity((Object)"COULD NOT LOAD OSD TEMPLATE.").build();
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (IOException | JAXBException e) {
            LOGGER.warn("Could not create OSD for client due to exception.", e);
            Response response3 = Response.serverError().build();
            return response3;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return response;
    }

    protected void addSourceDescriptions(OpenSearchDescription osd) {
        for (String curSource : this.catalogFramework.getSourceIds()) {
            SourceDescription description = new SourceDescription();
            description.setSourceId(curSource);
            description.setShortName(curSource);
            osd.getAny().add(description);
        }
    }

    protected String replaceTemplateValues(String osdTemplate) {
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${defaultCount}", (String)String.valueOf(this.queryConfiguration.getDefaultCount()), (int)1);
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${defaultQueryLanguage}", (String)this.queryConfiguration.getDefaultQueryLanguage(), (int)1);
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${queryLanguages}", (String)this.getQueryLanguagesString(), (int)1);
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${defaultResponseFormat}", (String)this.queryConfiguration.getDefaultResponseFormat(), (int)1);
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${defaultTimeout}", (String)String.valueOf(this.queryConfiguration.getDefaultTimeoutMillis()), (int)1);
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${additionalBasicParameters}", (String)"", (int)1);
        osdTemplate = StringUtils.replace((String)osdTemplate, (String)"${queryLanguageDocumentation}", (String)this.getQueryLanguageDescriptions(), (int)1);
        return osdTemplate;
    }

    protected String getQueryLanguageDescriptions() {
        StringBuilder sb = new StringBuilder();
        Iterator<QueryLanguage> langIter = this.queryLanguageList.iterator();
        while (langIter.hasNext()) {
            sb.append(langIter.next().getLanguageDescription(this.queryConfiguration));
            if (!langIter.hasNext()) continue;
            sb.append(System.lineSeparator());
            sb.append(System.lineSeparator());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    protected void addHeaderParameters(HttpServletRequest servletRequest, MultivaluedMap<String, String> queryParameters) {
        List headerProperties = this.queryConfiguration.getHeaderPropertyList();
        if (CollectionUtils.isNotEmpty((Collection)headerProperties)) {
            for (String headerProp : headerProperties) {
                String value = servletRequest.getHeader(headerProp);
                if (!StringUtils.isNotBlank((String)value)) continue;
                LOGGER.trace("Matching HTTP Header key/value pair found, adding [{}]=[{}] to queryParameters", (Object)headerProp, (Object)value);
                queryParameters.putSingle((Object)headerProp, (Object)value);
            }
        }
    }

    private String getQueryLanguagesString() {
        StringBuilder builder = new StringBuilder();
        for (QueryLanguage lang : this.queryLanguageList) {
            builder.append("'" + lang.getName() + "' ");
        }
        return builder.toString().trim();
    }

    public String getParameterTemplate(String languageName) {
        return "?q={os:searchTerms?}&count={os:count?}&startIndex={os:startIndex?}&queryLanguage=" + languageName + "&format={cdrs:responseFormat?}" + "&timeout={cdrs:timeout?}" + "&status={cdrb:includeStatus?}" + "&oid={cdrsx:originQueryID?}" + "&strictMode={cdrsx:strictMode?}" + "&path={cdrb:path?}";
    }

    public abstract QueryResponse executeQuery(String var1, MultivaluedMap<String, String> var2, CDRQueryImpl var3) throws SourceUnavailableException, UnsupportedQueryException, FederationException;

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    protected CatalogFramework getCatalogFramework() {
        return this.catalogFramework;
    }

    protected boolean isIncludeStatus(MultivaluedMap<String, String> queryParameters) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)SearchUtils.getBoolean((String)queryParameters.getFirst((Object)"status")), (boolean)true);
    }

    protected String getGeoRSSFormat(MultivaluedMap<String, String> queryParameters) {
        return StringUtils.defaultIfBlank((String)((String)queryParameters.getFirst((Object)"georssFormat")), null);
    }

    public Map<String, Serializable> getQueryProperties(MultivaluedMap<String, String> queryParameters, String sourceId) {
        HashMap<String, Serializable> queryProperties = new HashMap<String, Serializable>();
        queryProperties.put("format", (Serializable)((Object)StringUtils.defaultIfBlank((String)((String)queryParameters.getFirst((Object)"format")), (String)this.queryConfiguration.getDefaultResponseFormat())));
        queryProperties.put("status", SearchUtils.getBoolean((String)queryParameters.getFirst((Object)"status"), true));
        queryProperties.put("dedup", SearchUtils.getBoolean((String)queryParameters.getFirst((Object)"dedup"), this.queryConfiguration.isDefaultDeduplication()));
        for (String key : queryParameters.keySet()) {
            String value = (String)queryParameters.getFirst((Object)key);
            if (!StringUtils.isNotBlank((String)value) || !this.queryConfiguration.getParameterPropertyList().contains(key) && !this.queryConfiguration.getHeaderPropertyList().contains(key)) continue;
            LOGGER.trace("Adding key/value pair  [{}]=[{}] to queryProperties that get sent in with query request", (Object)key, (Object)value);
            queryProperties.put(key, (Serializable)((Object)value));
        }
        LOGGER.trace("Setting the query properties to {} based on values in query parameters {}", queryProperties, queryParameters);
        return queryProperties;
    }

    protected String generateTemplateUrl(QueryLanguage lang) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.platformConfig.getProtocol());
        urlBuilder.append(this.platformConfig.getHostname());
        urlBuilder.append(":");
        urlBuilder.append(this.platformConfig.getPort());
        urlBuilder.append(this.getServiceRelativeUrl());
        urlBuilder.append(this.getParameterTemplate(lang.getName()));
        urlBuilder.append(lang.getUrlTemplateParameters());
        LOGGER.debug("Generating the following template URL for OSDD: {}", (Object)urlBuilder);
        return urlBuilder.toString();
    }

    protected boolean isValidQuery(MultivaluedMap<String, String> queryParameters, String sourceId) {
        boolean isValidQuery = true;
        String queryLang = (String)queryParameters.getFirst((Object)"queryLanguage");
        if (this.getQueryLanguage(queryParameters) == null) {
            isValidQuery = false;
            LOGGER.debug("The query is not valid because the {} parameter with value {} is not in the allowed values {}", new Object[]{"queryLanguage", queryLang, this.queryLanguageList});
        } else if (!SearchUtils.isBooleanNullOrBlank((String)queryParameters.getFirst((Object)"caseSensitive"))) {
            isValidQuery = false;
            LOGGER.debug("The query is not valid because the {} parameter with value {} is not valid", (Object)"caseSensitive", queryParameters.getFirst((Object)"caseSensitive"));
        } else if (!SearchUtils.isBooleanNullOrBlank((String)queryParameters.getFirst((Object)"strict"))) {
            isValidQuery = false;
            LOGGER.debug("The query is not valid because the {} parameter with value {} is not valid", (Object)"strict", queryParameters.getFirst((Object)"strict"));
        } else if (!SearchUtils.isBooleanNullOrBlank((String)queryParameters.getFirst((Object)"status"))) {
            isValidQuery = false;
            LOGGER.debug("The query is not valid because the {} parameter with value {} is not valid", (Object)"status", queryParameters.getFirst((Object)"status"));
        } else if (!SearchUtils.isBooleanNullOrBlank((String)queryParameters.getFirst((Object)"fuzzy"))) {
            isValidQuery = false;
            LOGGER.debug("The query is not valid because the {} parameter with value {} is not valid", (Object)"fuzzy", queryParameters.getFirst((Object)"fuzzy"));
        } else if (!SearchUtils.isBooleanNullOrBlank((String)queryParameters.getFirst((Object)"dedup"))) {
            isValidQuery = false;
            LOGGER.debug("The query is not valid because the {} parameter with value {} is not valid", (Object)"dedup", queryParameters.getFirst((Object)"dedup"));
        } else {
            isValidQuery = this.isUniqueQuery(queryParameters, sourceId);
            LOGGER.debug("Checking if the query is valid: {}", (Object)isValidQuery);
        }
        return isValidQuery;
    }

    protected boolean isUniqueQuery(MultivaluedMap<String, String> queryParameters, String sourceId) {
        boolean isUniqueQuery = true;
        String oid = (String)queryParameters.getFirst((Object)"oid");
        if (StringUtils.isNotBlank((String)oid)) {
            isUniqueQuery = this.queryRequestCache.isQueryIdUnique(oid);
        } else {
            String uuid = UUID.randomUUID().toString();
            queryParameters.putSingle((Object)"oid", (Object)uuid);
            this.queryRequestCache.add(uuid);
        }
        String path = (String)queryParameters.getFirst((Object)"path");
        if (StringUtils.isNotBlank((String)path)) {
            Object[] pathValues = path.split(",");
            if (ArrayUtils.contains((Object[])pathValues, (Object)sourceId)) {
                isUniqueQuery = false;
                LOGGER.debug("The '{}' with value '{}' contains the local source id {}", new Object[]{"path", path, sourceId});
            }
        } else {
            queryParameters.putSingle((Object)"path", (Object)this.catalogFramework.getId());
        }
        return isUniqueQuery;
    }
}

