/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.di2e.ecdr.commons.filter.AbstractFilterDelegate;
import org.apache.commons.collections.MapUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrictFilterDelegate
extends AbstractFilterDelegate<Map<String, String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrictFilterDelegate.class);
    private static final double DEFAULT_RADIUS_NN = 500000.0;
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.dateTime();
    private Map<String, String> propertyMap = null;
    private Map<String, String> dateTypeMap = null;
    private boolean strictMode = false;

    public StrictFilterDelegate(boolean strictMode, AbstractFilterDelegate.SupportedGeosOptions supportedGeos, Map<String, String> propMap, Map<String, String> dtMap) {
        super(500000.0, supportedGeos);
        this.strictMode = strictMode;
        this.propertyMap = propMap;
        this.dateTypeMap = dtMap;
    }

    @Override
    public Map<String, String> handleAnd(List<Map<String, String>> operands) {
        Map<String, String> masterFilter = operands.get(0);
        if (operands.size() >= 2) {
            for (int i = 1; i < operands.size(); ++i) {
                String fuzzyString;
                String caseSensitive;
                String masterKeywords = masterFilter.get("q");
                Map<String, String> andedFilter = operands.get(i);
                String keyword = andedFilter.get("q");
                if (keyword != null) {
                    if (keyword.startsWith("NOT ")) {
                        masterFilter.put("q", masterKeywords == null ? keyword : "(" + masterKeywords + " " + keyword + ")");
                    } else {
                        masterFilter.put("q", masterKeywords == null ? keyword : "(" + masterKeywords + " AND " + keyword + ")");
                    }
                }
                if ((caseSensitive = andedFilter.get("caseSensitive")) != null && (caseSensitive.equalsIgnoreCase("true") || caseSensitive.equals("1"))) {
                    masterFilter.put("caseSensitive", "1");
                }
                if ((fuzzyString = andedFilter.get("fuzzy")) != null && (fuzzyString.equalsIgnoreCase("true") || fuzzyString.equals("1"))) {
                    masterFilter.put("fuzzy", "1");
                }
                String masterContentType = masterFilter.get("metadata-content-type");
                String andedContentType = andedFilter.get("metadata-content-type");
                String andedVersion = andedFilter.get("metadata-content-type-version");
                if (andedContentType != null) {
                    andedFilter.remove("metadata-content-type");
                    if (masterContentType == null) {
                        masterContentType = andedContentType;
                        if (!andedContentType.endsWith(",")) {
                            masterContentType = masterContentType + ":";
                        }
                    } else {
                        masterContentType = masterContentType + "," + andedContentType;
                        if (!andedContentType.endsWith(",")) {
                            masterContentType = masterContentType + ":";
                        }
                    }
                    masterFilter.put("metadata-content-type", masterContentType);
                }
                if (andedVersion != null) {
                    andedFilter.remove("metadata-content-type-version");
                    masterContentType = masterContentType == null || masterContentType.endsWith(",") ? "*:" + andedVersion : (masterContentType.endsWith(":") ? masterContentType + andedVersion + "," : masterContentType + ":" + andedVersion + ",");
                    masterFilter.put("metadata-content-type", masterContentType);
                }
                masterFilter = this.combineFilters(masterFilter, andedFilter);
            }
        }
        return masterFilter;
    }

    @Override
    public Map<String, String> handleOr(List<Map<String, String>> operands) {
        Map<String, String> masterFilter = operands.get(0);
        if (operands.size() >= 2) {
            for (int i = 1; i < operands.size(); ++i) {
                String fuzzy;
                String caseSensitive;
                String masterKeywords = masterFilter.get("q");
                Map<String, String> andedFilter = operands.get(i);
                String keyword = andedFilter.get("q");
                if (keyword != null) {
                    masterFilter.put("q", masterKeywords == null ? keyword : "(" + masterKeywords + " OR " + keyword + ")");
                }
                if ((caseSensitive = andedFilter.get("caseSensitive")) != null && (caseSensitive.equalsIgnoreCase("true") || caseSensitive.equals("1"))) {
                    masterFilter.put("caseSensitive", "1");
                }
                if ((fuzzy = andedFilter.get("fuzzy")) != null && (fuzzy.equalsIgnoreCase("true") || fuzzy.equals("1"))) {
                    masterFilter.put("fuzzy", "1");
                }
                String masterContentType = masterFilter.get("metadata-content-type");
                String andedContentType = andedFilter.get("metadata-content-type");
                if (andedContentType != null) {
                    andedFilter.remove("metadata-content-type");
                    masterContentType = masterContentType == null ? andedContentType : masterContentType + andedContentType;
                    masterFilter.put("metadata-content-type", masterContentType);
                }
                masterFilter = this.combineFilters(masterFilter, andedFilter);
            }
        }
        return masterFilter;
    }

    @Override
    public Map<String, String> handleNot(Map<String, String> operand) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        String keyword = operand.get("q");
        if (keyword != null) {
            filterContainer.put("q", "NOT " + keyword);
        }
        return filterContainer;
    }

    @Override
    public Map<String, String> handlePropertyLike(String propertyName, String pattern, AbstractFilterDelegate.StringFilterOptions options) {
        return this.handlePropertyEqualToString(propertyName, pattern, options);
    }

    @Override
    public Map<String, String> handlePropertyEqualToString(String propertyName, String literal, AbstractFilterDelegate.StringFilterOptions options) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        if (this.handleKeyword(propertyName, literal, filterContainer)) {
            if (AbstractFilterDelegate.StringFilterOptions.CASE_SENSITIVE.equals((Object)options)) {
                filterContainer.put("caseSensitive", "1");
            } else if (AbstractFilterDelegate.StringFilterOptions.FUZZY.equals((Object)options)) {
                filterContainer.put("fuzzy", "1");
            }
        } else {
            filterContainer.put(MapUtils.getString(this.propertyMap, (Object)propertyName, (String)propertyName), literal);
        }
        return filterContainer;
    }

    @Override
    public Map<String, String> handlePropertyIsEqualToNumber(String propertyName, double literal) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        filterContainer.put(MapUtils.getString(this.propertyMap, (Object)propertyName, (String)propertyName), String.valueOf(literal));
        return filterContainer;
    }

    @Override
    public Map<String, String> handlePropertyIsNotEqualToString(String propertyName, String literal, boolean isCaseSensitive) {
        this.failIfStrictMode("handlePropertyIsNotEqualToString");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handlePropertyIsNotEqualToNumber(String propertyName, double literal) {
        this.failIfStrictMode("handlePropertyIsNotEqualToNumber");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handlePropertyIsGreaterThanString(String propertyName, String literal, boolean inclusive) {
        this.failIfStrictMode("handlePropertyIsGreaterThanString");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handlePropertyIsGreaterThanNumber(String propertyName, double literal, boolean inclusive) {
        this.failIfStrictMode("handlePropertyIsGreaterThanNumber");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handlePropertyIsLessThanString(String propertyName, String literal, boolean inclusive) {
        this.failIfStrictMode("handlePropertyIsLessThanString");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handlePropertyIsLessThanNumber(String propertyName, double literal, boolean inclusive) {
        this.failIfStrictMode("handlePropertyIsLessThanNumber");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handlePropertyBetweenString(String propertyName, String lowerBoundary, String upperBoundary) {
        this.failIfStrictMode("handlePropertyBetweenString");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handleNumericRange(String propertyName, double lowerBoundary, double upperBoundary) {
        this.failIfStrictMode("handleNumericRange");
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> handleTimeDuring(String propertyName, Date start, Date end) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        filterContainer.put("dtStart", DATE_FORMATTER.print(start.getTime()));
        filterContainer.put("dtEnd", DATE_FORMATTER.print(end.getTime()));
        filterContainer.put("dtType", MapUtils.getString(this.dateTypeMap, (Object)propertyName, (String)propertyName));
        return filterContainer;
    }

    @Override
    public Map<String, String> handleTimeAfter(String propertyName, Date start, boolean inclusive) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        filterContainer.put("dtStart", DATE_FORMATTER.print(start.getTime()));
        filterContainer.put("dtType", MapUtils.getString(this.dateTypeMap, (Object)propertyName, (String)propertyName));
        return filterContainer;
    }

    @Override
    public Map<String, String> handleTimeBefore(String propertyName, Date end, boolean inclusive) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        filterContainer.put("dtEnd", DATE_FORMATTER.print(end.getTime()));
        filterContainer.put("dtType", MapUtils.getString(this.dateTypeMap, (Object)propertyName, (String)propertyName));
        return filterContainer;
    }

    @Override
    public Map<String, String> handleTimeNotDuring(String propertyName, Date start, Date end) {
        this.failIfStrictMode("handleTimeNotDuring");
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        return filterContainer;
    }

    @Override
    public Map<String, String> handleGeospatial(String propertyName, String wkt, AbstractFilterDelegate.GeospatialFilterOptions options) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        if (AbstractFilterDelegate.GeospatialFilterOptions.BBOX.equals((Object)options)) {
            try {
                WKTReader reader = new WKTReader(GEOMETRY_FACTORY);
                Envelope envelope = reader.read(wkt).getEnvelopeInternal();
                filterContainer.put("box", envelope.getMinX() + "," + envelope.getMinY() + "," + envelope.getMaxX() + "," + envelope.getMaxY());
            }
            catch (ParseException e) {
                throw new UnsupportedOperationException("Bounding box parameter was not formated correctly");
            }
        } else {
            if (!AbstractFilterDelegate.GeospatialFilterOptions.INTERSECTS.equals((Object)options) && !AbstractFilterDelegate.GeospatialFilterOptions.WITHIN.equals((Object)options)) {
                this.failIfStrictMode("handleGeospatial");
            }
            if (this.isKnownGeometryProperty(propertyName)) {
                filterContainer.put("geometry", wkt);
                return filterContainer;
            }
            LOGGER.info("Unsupported geospatial query sent in with wkt[{}], propertyName=[{}] and type=[{}]", new Object[]{wkt, propertyName, options});
            this.failIfStrictMode("handleGeospatial");
        }
        return filterContainer;
    }

    @Override
    public Map<String, String> handleGeospatialDistance(String propertyName, String wkt, double distance, AbstractFilterDelegate.GeospatialDistanceFilterOptions options) {
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        if ((options == null || options.equals((Object)AbstractFilterDelegate.GeospatialDistanceFilterOptions.WITHIN)) && this.isKnownGeometryProperty(propertyName)) {
            Point point = this.getPointFromWkt(wkt);
            if (point != null) {
                filterContainer.put("lat", String.valueOf(point.getY()));
                filterContainer.put("lon", String.valueOf(point.getX()));
                filterContainer.put("radius", String.valueOf(distance));
                return filterContainer;
            }
            LOGGER.debug("Could not translate WKT into point to use for point raduis query wkt=[{}]", (Object)wkt);
        }
        LOGGER.info("Unsupported geospatial distance query sent in with wkt[{}], propertyName=[{}] and type=[{}]", new Object[]{wkt, propertyName, options});
        this.failIfStrictMode("handleGeospatialDistance");
        return filterContainer;
    }

    @Override
    public Map<String, String> handleXpath(String xpath, String literal, AbstractFilterDelegate.StringFilterOptions options) {
        this.failIfStrictMode("handleXpath");
        if (literal == null) {
            literal = "";
        }
        HashMap<String, String> filterContainer = new HashMap<String, String>();
        filterContainer.put("q", "{" + xpath + "}:" + literal);
        if (AbstractFilterDelegate.StringFilterOptions.CASE_SENSITIVE.equals((Object)options)) {
            filterContainer.put("caseSensitive", "1");
        }
        if (AbstractFilterDelegate.StringFilterOptions.FUZZY.equals((Object)options)) {
            filterContainer.put("fuzzy", "1");
        }
        return filterContainer;
    }

    public void failIfStrictMode(String method) {
        if (this.strictMode) {
            throw new UnsupportedOperationException(method + " not supported directly, so failing because in strictMode");
        }
    }

    protected Point getPointFromWkt(String wkt) {
        Point point = null;
        try {
            WKTReader wktReader = new WKTReader(GEOMETRY_FACTORY);
            Geometry geometry = wktReader.read(wkt);
            if (geometry instanceof Point) {
                point = (Point)geometry;
            } else {
                point = geometry.getCentroid();
                LOGGER.debug("Using the centroid for the single point for the point raduis query for oriingal wkt=[{}]", (Object)wkt);
            }
        }
        catch (ParseException e) {
            LOGGER.error("Could not properly parse the string into a WKT object=[" + wkt + "]", (Throwable)e);
        }
        return point;
    }

    protected boolean isKnownGeometryProperty(String propertyName) {
        return "anyGeo".equals(propertyName) || "location".equals(propertyName);
    }

    protected boolean handleKeyword(String propertyName, String keyword, Map<String, String> filterContainer) {
        if ("anyText".equals(propertyName) && keyword != null) {
            if ((keyword = keyword.trim()).contains(" ")) {
                keyword = "\"" + keyword + "\"";
            }
            filterContainer.put("q", keyword);
            return true;
        }
        return false;
    }

    protected Map<String, String> combineFilters(Map<String, String> masterFilter, Map<String, String> andedFilter) {
        Set<String> keys = andedFilter.keySet();
        for (String key : keys) {
            if (masterFilter.containsKey(key)) continue;
            masterFilter.put(key, andedFilter.get(key));
        }
        return masterFilter;
    }
}

