/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.util;

import java.io.IOException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigAdminUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigAdminUtils.class);

    private ConfigAdminUtils() {
    }

    public static boolean configurationPidExists(ConfigurationAdmin configAdmin, String pid) throws IOException, InvalidSyntaxException {
        boolean configExists = false;
        String filter = "(service.factoryPid=" + pid + ")";
        Configuration[] config = configAdmin.listConfigurations(filter);
        if (config != null && config.length > 0) {
            configExists = true;
        }
        LOGGER.debug("The {} configuration returned {} services so return {} for configExists method", new Object[]{pid, config == null ? 0 : config.length, configExists});
        return configExists;
    }
}

