/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.util;

final class GeoLocation {
    private double radLat;
    private double radLon;
    private double degLat;
    private double degLon;
    private static final double MIN_LAT = Math.toRadians(-90.0);
    private static final double MAX_LAT = Math.toRadians(90.0);
    private static final double MIN_LON = Math.toRadians(-180.0);
    private static final double MAX_LON = Math.toRadians(180.0);
    private static final float EARTH_RADIUS_METERS = 6371010.0f;

    private GeoLocation() {
    }

    public static GeoLocation fromDegrees(double latitude, double longitude) {
        GeoLocation result = new GeoLocation();
        result.radLat = Math.toRadians(latitude);
        result.radLon = Math.toRadians(longitude);
        result.degLat = latitude;
        result.degLon = longitude;
        result.checkBounds();
        return result;
    }

    public static GeoLocation fromRadians(double latitude, double longitude) {
        GeoLocation result = new GeoLocation();
        result.radLat = latitude;
        result.radLon = longitude;
        result.degLat = Math.toDegrees(latitude);
        result.degLon = Math.toDegrees(longitude);
        result.checkBounds();
        return result;
    }

    private void checkBounds() {
        if (this.radLat < MIN_LAT || this.radLat > MAX_LAT || this.radLon < MIN_LON || this.radLon > MAX_LON) {
            throw new IllegalArgumentException();
        }
    }

    public double getLatitudeInDegrees() {
        return this.degLat;
    }

    public double getLongitudeInDegrees() {
        return this.degLon;
    }

    public double getLatitudeInRadians() {
        return this.radLat;
    }

    public double getLongitudeInRadians() {
        return this.radLon;
    }

    public String toString() {
        return "(" + this.degLat + "\u00b0, " + this.degLon + "\u00b0) = (" + this.radLat + " rad, " + this.radLon + " rad)";
    }

    public double distanceTo(GeoLocation location) {
        return Math.acos(Math.sin(this.radLat) * Math.sin(location.radLat) + Math.cos(this.radLat) * Math.cos(location.radLat) * Math.cos(this.radLon - location.radLon)) * 6371010.0;
    }

    public GeoLocation[] boundingCoordinates(double distance) {
        double maxLon;
        double minLon;
        if (distance < 0.0) {
            throw new IllegalArgumentException();
        }
        double radDist = distance / 6371010.0;
        double minLat = this.radLat - radDist;
        double maxLat = this.radLat + radDist;
        if (minLat > MIN_LAT && maxLat < MAX_LAT) {
            double deltaLon = Math.asin(Math.sin(radDist) / Math.cos(this.radLat));
            minLon = this.radLon - deltaLon;
            if (minLon < MIN_LON) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = this.radLon + deltaLon) > MAX_LON) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = Math.max(minLat, MIN_LAT);
            maxLat = Math.min(maxLat, MAX_LAT);
            minLon = MIN_LON;
            maxLon = MAX_LON;
        }
        return new GeoLocation[]{GeoLocation.fromRadians(minLat, minLon), GeoLocation.fromRadians(maxLat, maxLon)};
    }
}

