/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.commons.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import net.di2e.ecdr.commons.util.GeoLocation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeospatialUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeospatialUtils.class);
    private static final Integer MAX_LAT = 90;
    private static final Integer MIN_LAT = -90;
    private static final Integer MAX_LON = 180;
    private static final Integer MIN_LON = -180;
    private static final Integer MAX_ROTATION = 360;
    private static final double LAT_DEGREE_M = 111325.0;

    private GeospatialUtils() {
    }

    public static String polygonToWKT(String polygon) {
        StringBuilder wkt = new StringBuilder("POLYGON((");
        int coordinatePair = 0;
        String[] coords = polygon.split(",");
        int size = coords.length;
        LOGGER.trace("Trying to convert polygon with value [{}] to WKT", (Object)polygon);
        for (int i = size - 1; i >= 0; --i) {
            if (++coordinatePair == 2) {
                wkt.append(" ");
            } else if (coordinatePair > 2) {
                wkt.append(",");
                coordinatePair = 1;
            }
            wkt.append(StringUtils.trimToEmpty((String)coords[i]));
        }
        wkt.append("))");
        LOGGER.trace("Converted polygon with value [{}] to WKT [{}]", (Object)polygon, (Object)wkt);
        return wkt.toString();
    }

    public static String polygonToBBox(String wkt) throws ParseException {
        LOGGER.trace("Trying to convert the wkt [{}] into a bounding box", (Object)wkt);
        WKTReader reader = new WKTReader();
        Geometry geo = reader.read(wkt);
        if (!geo.isRectangle()) {
            geo = geo.getEnvelope();
            WKTWriter writer = new WKTWriter();
            String bbox = writer.write(geo);
            LOGGER.debug("Convert the following wkt [{}] into a bounding box wkt [{}]", (Object)wkt, (Object)bbox);
            wkt = bbox;
        }
        return wkt;
    }

    public static String circleToBBox(String wktPoint, double radius) throws ParseException {
        WKTReader reader = new WKTReader();
        Geometry geo = reader.read(wktPoint);
        Point point = geo.getCentroid();
        GeoLocation geoLocation = GeoLocation.fromDegrees(point.getY(), point.getX());
        GeoLocation[] boxLocs = geoLocation.boundingCoordinates(radius);
        return "POLYGON((" + boxLocs[0].getLongitudeInDegrees() + " " + boxLocs[0].getLatitudeInDegrees() + ", " + boxLocs[1].getLongitudeInDegrees() + " " + boxLocs[0].getLatitudeInDegrees() + ", " + boxLocs[1].getLongitudeInDegrees() + " " + boxLocs[1].getLatitudeInDegrees() + ", " + boxLocs[0].getLongitudeInDegrees() + " " + boxLocs[1].getLatitudeInDegrees() + ", " + boxLocs[0].getLongitudeInDegrees() + " " + boxLocs[0].getLatitudeInDegrees() + "))";
    }
}

