/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import net.dongliu.gson.DurationAdapter;
import net.dongliu.gson.Java8TimeAdapter;
import net.dongliu.gson.MonthDayAdapter;
import net.dongliu.gson.OptionalAdapter;
import net.dongliu.gson.OptionalDoubleAdapter;
import net.dongliu.gson.OptionalIntAdapter;
import net.dongliu.gson.OptionalLongAdapter;
import net.dongliu.gson.PeriodAdapter;
import net.dongliu.gson.YearAdapter;
import net.dongliu.gson.YearMonthAdapter;
import net.dongliu.gson.ZoneOffsetAdapter;

public class GsonJava8TypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class cls = typeToken.getRawType();
        if (cls == Optional.class) {
            return OptionalAdapter.getInstance(gson, typeToken);
        }
        if (cls == OptionalInt.class) {
            return OptionalIntAdapter.instance;
        }
        if (cls == OptionalLong.class) {
            return OptionalLongAdapter.instance;
        }
        if (cls == OptionalDouble.class) {
            return OptionalDoubleAdapter.instance;
        }
        if (cls == Instant.class) {
            return Java8TimeAdapter.instantAdapter;
        }
        if (cls == LocalDate.class) {
            return Java8TimeAdapter.localDateAdapter;
        }
        if (cls == LocalDateTime.class) {
            return Java8TimeAdapter.localDateTimeAdapter;
        }
        if (cls == LocalTime.class) {
            return Java8TimeAdapter.localTimeAdapter;
        }
        if (cls == OffsetDateTime.class) {
            return Java8TimeAdapter.offsetDateTimeAdapter;
        }
        if (cls == OffsetTime.class) {
            return Java8TimeAdapter.offsetTimeAdapter;
        }
        if (cls == ZonedDateTime.class) {
            return Java8TimeAdapter.zonedDateTimeAdapter;
        }
        if (cls == DayOfWeek.class || cls == Month.class) {
            return null;
        }
        if (cls == MonthDay.class) {
            return MonthDayAdapter.instance;
        }
        if (cls == YearMonth.class) {
            return YearMonthAdapter.instance;
        }
        if (Year.class.isAssignableFrom(cls)) {
            return YearAdapter.instance;
        }
        if (cls == Period.class) {
            return PeriodAdapter.instance;
        }
        if (cls == Duration.class) {
            return DurationAdapter.instance;
        }
        if (cls == ZoneOffset.class) {
            return ZoneOffsetAdapter.instance;
        }
        return null;
    }
}

