/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;

class Java8TimeAdapter
extends TypeAdapter<TemporalAccessor> {
    private final DateTimeFormatter readFormatter;
    private final DateTimeFormatter writeFormatter;
    private final TemporalQuery<TemporalAccessor> temporalQuery;
    static final Java8TimeAdapter instantAdapter = new Java8TimeAdapter(DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_INSTANT, Instant::from);
    static final Java8TimeAdapter localDateAdapter = new Java8TimeAdapter(DateTimeFormatter.ISO_LOCAL_DATE, LocalDate::from);
    static final Java8TimeAdapter localDateTimeAdapter = new Java8TimeAdapter(DateTimeFormatter.ISO_LOCAL_DATE_TIME, LocalDateTime::from);
    static final Java8TimeAdapter localTimeAdapter = new Java8TimeAdapter(DateTimeFormatter.ISO_LOCAL_TIME, LocalTime::from);
    static final Java8TimeAdapter offsetDateTimeAdapter = new Java8TimeAdapter(DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from);
    static final Java8TimeAdapter offsetTimeAdapter = new Java8TimeAdapter(DateTimeFormatter.ISO_OFFSET_TIME, OffsetTime::from);
    static final Java8TimeAdapter zonedDateTimeAdapter = new Java8TimeAdapter(DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from);

    public Java8TimeAdapter(DateTimeFormatter dtf, TemporalQuery<TemporalAccessor> temporalQuery) {
        this(dtf, dtf, temporalQuery);
    }

    public Java8TimeAdapter(DateTimeFormatter readFormatter, DateTimeFormatter writeFormatter, TemporalQuery<TemporalAccessor> temporalQuery) {
        this.readFormatter = readFormatter;
        this.writeFormatter = writeFormatter;
        this.temporalQuery = temporalQuery;
    }

    public void write(JsonWriter out, TemporalAccessor value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        String str = this.writeFormatter.format(value);
        out.value(str);
    }

    public TemporalAccessor read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String str = in.nextString();
        return this.readFormatter.parse((CharSequence)str, this.temporalQuery);
    }
}

