/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.ZoneOffset;

class ZoneOffsetAdapter
extends TypeAdapter<ZoneOffset> {
    static final ZoneOffsetAdapter instance = new ZoneOffsetAdapter();

    ZoneOffsetAdapter() {
    }

    public void write(JsonWriter out, ZoneOffset zoneOffset) throws IOException {
        if (zoneOffset == null) {
            out.nullValue();
            return;
        }
        out.value(zoneOffset.getId());
    }

    public ZoneOffset read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String s = in.nextString();
        return ZoneOffset.of(s);
    }
}

