/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.DoubleBinaryOperator;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Line;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.finmath.plots.Named;
import net.finmath.plots.Plot;

public class Plot3DFX
implements Plot {
    private final double xmin;
    private final double xmax;
    private final double ymin;
    private final double ymax;
    private final int numberOfPointsX;
    private final int numberOfPointsY;
    private final Named<DoubleBinaryOperator> function;
    private String title = "";
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private String zAxisLabel = "z";
    private Boolean isLegendVisible;
    private int size = 500;
    private double mousePosX;
    private double mousePosY;
    private double mouseOldX;
    private double mouseOldY;
    private final Rotate rotateX = new Rotate(20.0, Rotate.X_AXIS);
    private final Rotate rotateY = new Rotate(-45.0, Rotate.Y_AXIS);
    private transient JFrame frame;
    private StackPane root;
    private final Object updateLock = new Object();

    public Plot3DFX(double xmin, double xmax, double ymin, double ymax, int numberOfPointsX, int numberOfPointsY, Named<DoubleBinaryOperator> function) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.numberOfPointsX = numberOfPointsX;
        this.numberOfPointsY = numberOfPointsY;
        this.function = function;
    }

    public Plot3DFX(double xmin, double xmax, double ymin, double ymax, int numberOfPointsX, int numberOfPointsY, DoubleBinaryOperator function) {
        this(xmin, xmax, ymin, ymax, numberOfPointsX, numberOfPointsY, new Named<DoubleBinaryOperator>("", function));
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Plot3DFX.this.frame != null) {
                    Plot3DFX.this.frame.dispose();
                }
                Plot3DFX.this.frame = new JFrame("FX");
                final JFXPanel fxPanel = new JFXPanel();
                Plot3DFX.this.frame.add((Component)fxPanel);
                Plot3DFX.this.frame.setVisible(true);
                Plot3DFX.this.frame.setSize(800, 600);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Plot3DFX.this.init();
                        Scene scene = new Scene((Parent)Plot3DFX.this.root, 800.0, 600.0, true, SceneAntialiasing.BALANCED);
                        scene.setCamera((Camera)new PerspectiveCamera());
                        scene.setOnMousePressed(me -> {
                            Plot3DFX.this.mouseOldX = me.getSceneX();
                            Plot3DFX.this.mouseOldY = me.getSceneY();
                        });
                        scene.setOnMouseDragged(me -> {
                            Plot3DFX.this.mousePosX = me.getSceneX();
                            Plot3DFX.this.mousePosY = me.getSceneY();
                            Plot3DFX.this.rotateX.setAngle(Plot3DFX.this.rotateX.getAngle() - (Plot3DFX.this.mousePosY - Plot3DFX.this.mouseOldY));
                            Plot3DFX.this.rotateY.setAngle(Plot3DFX.this.rotateY.getAngle() + (Plot3DFX.this.mousePosX - Plot3DFX.this.mouseOldX));
                            Plot3DFX.this.mouseOldX = Plot3DFX.this.mousePosX;
                            Plot3DFX.this.mouseOldY = Plot3DFX.this.mousePosY;
                        });
                        fxPanel.setScene(scene);
                    }
                });
                Plot3DFX.this.update();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.frame != null) {
                this.frame.dispose();
            }
        }
    }

    private void init() {
        Group cube = this.createCube(this.size);
        cube.getTransforms().addAll((Object[])new Transform[]{this.rotateX, this.rotateY});
        this.root = new StackPane();
        this.root.getChildren().add((Object)cube);
        float[][] noiseArray = this.createNoise(this.size);
        TriangleMesh mesh = new TriangleMesh();
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                mesh.getPoints().addAll(new float[]{x, noiseArray[x][z], z});
            }
        }
        int length = this.size;
        float total = length;
        for (float x = 0.0f; x < (float)(length - 1); x += 1.0f) {
            for (float y = 0.0f; y < (float)(length - 1); y += 1.0f) {
                float x0 = x / total;
                float y0 = y / total;
                float x1 = (x + 1.0f) / total;
                float y1 = (y + 1.0f) / total;
                mesh.getTexCoords().addAll(new float[]{x0, y0, x0, y1, x1, y1, x1, y1});
            }
        }
        for (int x = 0; x < length - 1; ++x) {
            for (int z = 0; z < length - 1; ++z) {
                int tl = x * length + z;
                int bl = x * length + z + 1;
                int tr = (x + 1) * length + z;
                int br = (x + 1) * length + z + 1;
                int offset = (x * (length - 1) + z) * 8 / 2;
                mesh.getFaces().addAll(new int[]{bl, offset + 1, tl, offset + 0, tr, offset + 2});
                mesh.getFaces().addAll(new int[]{tr, offset + 2, br, offset + 3, bl, offset + 1});
            }
        }
        Image diffuseMap = this.createImage(this.size, noiseArray);
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseMap(diffuseMap);
        material.setSpecularColor(Color.WHITE);
        MeshView meshView = new MeshView((Mesh)mesh);
        meshView.setTranslateX(-0.5 * (double)this.size);
        meshView.setTranslateZ(-0.5 * (double)this.size);
        meshView.setMaterial((Material)material);
        meshView.setCullFace(CullFace.NONE);
        meshView.setDrawMode(DrawMode.FILL);
        meshView.setDepthTest(DepthTest.ENABLE);
        cube.getChildren().addAll((Object[])new Node[]{meshView});
        ImageView iv = new ImageView(diffuseMap);
        iv.setTranslateX(-0.5 * (double)this.size);
        iv.setTranslateY(-0.1 * (double)this.size);
        iv.setRotate(90.0);
        iv.setRotationAxis(new Point3D(1.0, 0.0, 0.0));
        cube.getChildren().add((Object)iv);
        this.makeZoomable(this.root);
    }

    private void update() {
    }

    public Image createImage(double size, float[][] noise) {
        int width = (int)size;
        int height = (int)size;
        WritableImage wr = new WritableImage(width, height);
        PixelWriter pw = wr.getPixelWriter();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                float value = noise[x][y];
                double gray = Plot3DFX.normalizeValue(value, -250.0, 250.0, 0.0, 1.0);
                gray = Plot3DFX.clamp(gray, 0.0, 1.0);
                Color color = Color.RED;
                color = gray < 0.5 ? Color.RED.interpolate(Color.YELLOW, gray * 2.0) : Color.YELLOW.interpolate(Color.BLUE, gray * 2.0 - 1.0);
                pw.setColor(x, y, color);
            }
        }
        return wr;
    }

    public void makeZoomable(final StackPane control) {
        double MAX_SCALE = 20.0;
        double MIN_SCALE = 0.1;
        control.addEventFilter(ScrollEvent.ANY, (EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                double delta = 1.2;
                double scale = control.getScaleX();
                scale = event.getDeltaY() < 0.0 ? (scale /= delta) : (scale *= delta);
                scale = Plot3DFX.clamp(scale, 0.1, 20.0);
                control.setScaleX(scale);
                control.setScaleY(scale);
                event.consume();
            }
        });
    }

    private Group createCube(int size) {
        Group cube = new Group();
        Color color = Color.DARKCYAN;
        ArrayList<Axis> cubeFaces = new ArrayList<Axis>();
        Axis r = new Axis(size);
        r.setFill((Paint)Color.rgb((int)32, (int)32, (int)32, (double)0.5));
        r.setTranslateX(-0.5 * (double)size);
        r.setTranslateY(-0.5 * (double)size);
        r.setTranslateZ(0.5 * (double)size);
        cubeFaces.add(r);
        r = new Axis(size);
        r.setFill((Paint)Color.rgb((int)32, (int)32, (int)32, (double)0.5));
        r.setTranslateX(-0.5 * (double)size);
        r.setTranslateY(0.0);
        r.setRotationAxis(Rotate.X_AXIS);
        r.setRotate(90.0);
        cubeFaces.add(r);
        r = new Axis(size);
        r.setFill((Paint)Color.rgb((int)32, (int)32, (int)32, (double)0.5));
        r.setTranslateX(-1 * size);
        r.setTranslateY(-0.5 * (double)size);
        r.setRotationAxis(Rotate.Y_AXIS);
        r.setRotate(90.0);
        r = new Axis(size);
        r.setFill((Paint)Color.rgb((int)32, (int)32, (int)32, (double)0.5));
        r.setTranslateX(0.0);
        r.setTranslateY(-0.5 * (double)size);
        r.setRotationAxis(Rotate.Y_AXIS);
        r.setRotate(90.0);
        cubeFaces.add(r);
        r = new Axis(size);
        r.setFill((Paint)Color.rgb((int)32, (int)32, (int)32, (double)0.5));
        r.setTranslateX(-0.5 * (double)size);
        r.setTranslateY(-1 * size);
        r.setRotationAxis(Rotate.X_AXIS);
        r.setRotate(90.0);
        r = new Axis(size);
        r.setFill((Paint)Color.rgb((int)32, (int)32, (int)32, (double)0.5));
        r.setTranslateX(-0.5 * (double)size);
        r.setTranslateY(-0.5 * (double)size);
        r.setTranslateZ(-0.5 * (double)size);
        cube.getChildren().addAll(cubeFaces);
        return cube;
    }

    private float[][] createNoise(int size) {
        int y;
        int x;
        float[][] noiseArray = new float[size][size];
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                double value = this.function.get().applyAsDouble(this.xmin + (double)x / (double)size * (this.xmax - this.xmin), this.ymin + (double)y / (double)size * (this.ymax - this.ymin));
                min = Math.min(value, min);
                max = Math.max(value, max);
                noiseArray[x][y] = (float)value;
            }
        }
        for (x = 0; x < size; ++x) {
            for (y = 0; y < size; ++y) {
                noiseArray[x][y] = (float)(0.5 * (double)size - ((double)noiseArray[x][y] - min) / (max - min) * (double)size);
            }
        }
        return noiseArray;
    }

    public static double normalizeValue(double value, double min, double max, double newMin, double newMax) {
        return (value - min) * (newMax - newMin) / (max - min) + newMin;
    }

    public static double clamp(double value, double min, double max) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    @Override
    public Plot saveAsJPG(File file, int width, int height) throws IOException {
        throw new UnsupportedOperationException("Save as PDF is not supported for this plot. Use saveAsJPG instead.");
    }

    @Override
    public Plot saveAsPDF(File file, int width, int height) {
        throw new UnsupportedOperationException("Save as PDF is not supported for this plot. Use saveAsJPG instead.");
    }

    @Override
    public Plot saveAsSVG(File file, int width, int height) {
        throw new UnsupportedOperationException("Save as SVG is not supported for this plot. Use saveAsJPG instead.");
    }

    @Override
    public Plot setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Plot setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
        return this;
    }

    @Override
    public Plot setYAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
        return this;
    }

    @Override
    public Plot setZAxisLabel(String zAxisLabel) {
        this.zAxisLabel = zAxisLabel;
        return this;
    }

    @Override
    public Plot setIsLegendVisible(Boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
        return this;
    }

    public String toString() {
        return "Plot3D [xmin=" + this.xmin + ", xmax=" + this.xmax + ", ymin=" + this.ymin + ", ymax=" + this.ymax + ", numberOfPointsX=" + this.numberOfPointsX + ", numberOfPointsY=" + this.numberOfPointsY + ", function=" + this.function + ", title=" + this.title + ", xAxisLabel=" + this.xAxisLabel + ", yAxisLabel=" + this.yAxisLabel + ", zAxisLabel=" + this.zAxisLabel + ", isLegendVisible=" + this.isLegendVisible + "]";
    }

    public static class Axis
    extends Pane {
        private Rectangle wall;

        public Axis(double size) {
            Line line;
            this.wall = new Rectangle(size, size);
            this.getChildren().add((Object)this.wall);
            double zTranslate = 0.0;
            double lineWidth = 1.0;
            Color gridColor = Color.BLACK;
            int y = 0;
            while ((double)y <= size) {
                line = new Line(0.0, 0.0, size, 0.0);
                line.setStroke((Paint)gridColor);
                line.setFill((Paint)gridColor);
                line.setTranslateY((double)y);
                line.setTranslateZ(zTranslate);
                line.setStrokeWidth(lineWidth);
                this.getChildren().addAll((Object[])new Node[]{line});
                y = (int)((double)y + size / 10.0);
            }
            int x = 0;
            while ((double)x <= size) {
                line = new Line(0.0, 0.0, 0.0, size);
                line.setStroke((Paint)gridColor);
                line.setFill((Paint)gridColor);
                line.setTranslateX((double)x);
                line.setTranslateZ(zTranslate);
                line.setStrokeWidth(lineWidth);
                this.getChildren().addAll((Object[])new Node[]{line});
                x = (int)((double)x + size / 10.0);
            }
            y = 0;
            while ((double)y <= size) {
                Text text = new Text("" + (size - (double)y));
                text.setTranslateX(size + 10.0);
                text.setTranslateY((double)y);
                text.setTranslateZ(zTranslate);
                this.getChildren().addAll((Object[])new Node[]{text});
                y = (int)((double)y + size / 10.0);
            }
        }

        public void setFill(Paint paint) {
            this.wall.setFill(paint);
        }
    }
}

