/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.plots.jfreechart;

import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.renderer.PaintScale;

public class HuePaintScale
implements PaintScale {
    private double lowerBound;
    private double upperBound;

    public HuePaintScale(double lowerBound, double upperBound) {
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public Paint getPaint(double value) {
        if (value > this.getUpperBound() || value < this.getLowerBound() || Double.isNaN(value)) {
            return Color.GRAY;
        }
        return Color.getHSBColor((float)((value - this.getLowerBound()) / (this.getUpperBound() - this.getLowerBound()) * 240.0 / 360.0), 1.0f, 1.0f);
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }
}

