/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.FlowPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.finmath.marketdata.products.Swap;
import net.finmath.plots.Category2D;
import net.finmath.plots.GraphStyle;
import net.finmath.plots.Plot2DBarFX;
import net.finmath.plots.Plot2DFX;
import net.finmath.plots.Plotable2D;
import net.finmath.plots.PlotableCategories;
import net.finmath.plots.Point2D;
import net.finmath.smartcontract.product.IRSwapGenerator;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParserDataItems;
import net.finmath.smartcontract.valuation.oracle.SmartDerivativeContractSettlementOracle;
import net.finmath.smartcontract.valuation.oracle.interestrates.ValuationOraclePlainSwap;

public class VisualiserSDC {
    private List<Point2D> seriesMarketValues;
    private Plot2DBarFX plotMarginAccounts;
    private Plot2DFX plotMarketValue;

    public static void main(String[] args) throws Exception {
        LocalDate startDate = LocalDate.of(2008, 1, 1);
        LocalDate maturity = LocalDate.of(2012, 1, 3);
        String fileName = "timeseriesdatamap.json";
        DateTimeFormatter providedDateFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
        List<CalibrationDataset> scenarioList = CalibrationParserDataItems.getScenariosFromJsonFile("timeseriesdatamap.json").stream().filter(S -> S.getDate().toLocalDate().isAfter(startDate)).filter(S -> S.getDate().toLocalDate().isBefore(maturity)).collect(Collectors.toList());
        double notional = 1.0E7;
        String maturityKey = "5Y";
        String forwardCurveKey = "forward-EUR-6M";
        String discountCurveKey = "discount-EUR-OIS";
        LocalDate productStartDate = ((CalibrationDataset)scenarioList.get(0)).getDate().toLocalDate().minusDays(170L);
        double fixRate = ((CalibrationDataset)scenarioList.get(0)).getDataPoints().stream().filter(datapoint -> datapoint.getSpec().getCurveName().equals("Euribor6M") && datapoint.getSpec().getProductName().equals("Swap-Rate") && datapoint.getSpec().getMaturity().equals("5Y")).mapToDouble(e -> e.getQuote()).findAny().getAsDouble();
        Swap swap = IRSwapGenerator.generateAnalyticSwapObject(productStartDate, "5Y", fixRate, false, "forward-EUR-6M", "discount-EUR-OIS");
        ValuationOraclePlainSwap oracle = new ValuationOraclePlainSwap(swap, 1.0E7, scenarioList);
        SmartDerivativeContractSettlementOracle margin = new SmartDerivativeContractSettlementOracle(oracle);
        List scenarioDates = scenarioList.stream().map(scenario -> scenario.getDate()).sorted().collect(Collectors.toList());
        VisualiserSDC sdcVisual = new VisualiserSDC();
        sdcVisual.start();
        Double marketValue = 0.0;
        double marginBuffer = 120000.0;
        sdcVisual.updateWithValue((LocalDateTime)scenarioDates.get(0), 120000.0, 0.0, null, 0.0);
        Thread.sleep(1000L);
        for (int i = 0; i < scenarioDates.size(); ++i) {
            double marginCall = i > 0 ? margin.getMargin((LocalDateTime)scenarioDates.get(i - 1), (LocalDateTime)scenarioDates.get(i)) : 0.0;
            System.out.println(i + "\t" + DateTimeFormatter.ofPattern("dd.MM.yyyy").format((TemporalAccessor)scenarioDates.get(i)) + "\t" + marginCall);
            marketValue = marketValue + marginCall;
            sdcVisual.updateWithValue((LocalDateTime)scenarioDates.get(i), 120000.0, i, marketValue, marginCall);
            Thread.sleep(500L);
            sdcVisual.updateWithValue((LocalDateTime)scenarioDates.get(i), 120000.0, i, null, 0.0);
        }
    }

    public void start() throws Exception {
        this.seriesMarketValues = new ArrayList<Point2D>();
        this.plotMarginAccounts = new Plot2DBarFX(null, "Smart Contract Accounts (settlement)", "Account", "Value", (NumberFormat)new DecimalFormat("####.00"), Double.valueOf(0.0), Double.valueOf(300000.0), Double.valueOf(25000.0), Boolean.valueOf(false));
        this.plotMarginAccounts.setIsSeriesStacked(Boolean.valueOf(true));
        this.plotMarketValue = new Plot2DFX();
        this.plotMarketValue.setIsLegendVisible(Boolean.valueOf(false));
        this.plotMarketValue.setTitle("Market Value");
        this.plotMarketValue.setXAxisLabel("Date");
        this.plotMarketValue.setYAxisLabel("Market Value");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Smart Derivative Contract: Settlement Visualization");
                final JFXPanel fxPanel = new JFXPanel();
                frame.add((Component)fxPanel);
                frame.setVisible(true);
                frame.setSize(1600, 600);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FlowPane root = new FlowPane();
                        root.getChildren().addAll((Object[])new Node[]{new Group(new Node[]{VisualiserSDC.this.plotMarginAccounts.get()}), VisualiserSDC.this.plotMarketValue.get()});
                        Scene scene = new Scene((Parent)root, 1600.0, 600.0);
                        scene.getStylesheets().add((Object)"barchart.css");
                        fxPanel.setScene(scene);
                    }
                });
            }
        });
    }

    void updateWithValue(LocalDateTime date, double base, double x, Double value, double increment) throws InterruptedException {
        final ArrayList<Category2D> marginBase = new ArrayList<Category2D>();
        marginBase.add(new Category2D("We", (Number)(base + Math.min(0.0, increment))));
        marginBase.add(new Category2D("Counterpart", (Number)(base + Math.min(0.0, -increment))));
        final ArrayList<Category2D> marginRemoved = new ArrayList<Category2D>();
        marginRemoved.add(new Category2D("We", (Number)(-Math.min(0.0, increment))));
        marginRemoved.add(new Category2D("Counterpart", (Number)(-Math.min(0.0, -increment))));
        final ArrayList<Category2D> marginExcessed = new ArrayList<Category2D>();
        marginExcessed.add(new Category2D("We", (Number)Math.max(0.0, increment)));
        marginExcessed.add(new Category2D("Counterpart", (Number)Math.max(0.0, -increment)));
        ArrayList<Object> plotables = new ArrayList<Object>();
        plotables.add(new PlotableCategories(){

            public String getName() {
                return "Margin";
            }

            public GraphStyle getStyle() {
                return new GraphStyle((Shape)new Ellipse2D.Float(-1.0f, -1.0f, 2.0f, 2.0f), (Stroke)new BasicStroke(1.0f), new Color(0.0f, 0.0f, 1.0f));
            }

            public List<Category2D> getSeries() {
                return marginBase;
            }
        });
        plotables.add(new PlotableCategories(){

            public String getName() {
                return "Pay";
            }

            public GraphStyle getStyle() {
                return null;
            }

            public List<Category2D> getSeries() {
                return marginRemoved;
            }
        });
        plotables.add(new PlotableCategories(){

            public String getName() {
                return "Receive";
            }

            public GraphStyle getStyle() {
                return null;
            }

            public List<Category2D> getSeries() {
                return marginExcessed;
            }
        });
        this.plotMarginAccounts.update(plotables);
        if (value != null) {
            ArrayList<5> plotables2 = new ArrayList<5>();
            plotables2.add(new Plotable2D(){

                public String getName() {
                    return "Market Value";
                }

                public GraphStyle getStyle() {
                    return new GraphStyle((Shape)new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f), (Stroke)new BasicStroke(1.0f), new Color(1.0f, 0.0f, 0.0f));
                }

                public List<Point2D> getSeries() {
                    return VisualiserSDC.this.seriesMarketValues;
                }
            });
            this.seriesMarketValues.add(new Point2D(x, value.doubleValue()));
            this.plotMarketValue.update(plotables2);
            this.plotMarketValue.setTitle("Market Value (01.05.2008-" + date.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + ")");
        }
        Thread.sleep(500L);
    }
}

