/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;

public class FrontendItemSpec {
    @JsonProperty(value="symbol")
    private String symbol;
    @JsonProperty(value="curve")
    private String curve;
    @JsonProperty(value="itemType")
    private String itemType;
    @JsonProperty(value="tenor")
    private String tenor;

    public FrontendItemSpec symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @NotNull
    @Schema(name="symbol", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public FrontendItemSpec curve(String curve) {
        this.curve = curve;
        return this;
    }

    @NotNull
    @Schema(name="curve", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getCurve() {
        return this.curve;
    }

    public void setCurve(String curve) {
        this.curve = curve;
    }

    public FrontendItemSpec itemType(String itemType) {
        this.itemType = itemType;
        return this;
    }

    @NotNull
    @Schema(name="itemType", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public FrontendItemSpec tenor(String tenor) {
        this.tenor = tenor;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[0-9]+[DMY]$")
    @Schema(name="tenor", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @Pattern(regexp="^[0-9]+[DMY]$") String getTenor() {
        return this.tenor;
    }

    public void setTenor(String tenor) {
        this.tenor = tenor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrontendItemSpec frontendItemSpec = (FrontendItemSpec)o;
        return Objects.equals(this.symbol, frontendItemSpec.symbol) && Objects.equals(this.curve, frontendItemSpec.curve) && Objects.equals(this.itemType, frontendItemSpec.itemType) && Objects.equals(this.tenor, frontendItemSpec.tenor);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.curve, this.itemType, this.tenor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FrontendItemSpec {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    curve: ").append(this.toIndentedString(this.curve)).append("\n");
        sb.append("    itemType: ").append(this.toIndentedString(this.itemType)).append("\n");
        sb.append("    tenor: ").append(this.toIndentedString(this.tenor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

