/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.Objects;
import net.finmath.smartcontract.model.MarketDataList;
import org.springframework.format.annotation.DateTimeFormat;

@JsonTypeName(value="margin_request")
public class MarginRequest {
    @JsonProperty(value="marketDataStart")
    private MarketDataList marketDataStart = null;
    @JsonProperty(value="marketDataEnd")
    private MarketDataList marketDataEnd = null;
    @JsonProperty(value="tradeData")
    private String tradeData;
    @JsonProperty(value="valuationDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime valuationDate;

    public MarginRequest marketDataStart(MarketDataList marketDataStart) {
        this.marketDataStart = marketDataStart;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="marketDataStart", requiredMode=Schema.RequiredMode.REQUIRED)
    public MarketDataList getMarketDataStart() {
        return this.marketDataStart;
    }

    public void setMarketDataStart(MarketDataList marketDataStart) {
        this.marketDataStart = marketDataStart;
    }

    public MarginRequest marketDataEnd(MarketDataList marketDataEnd) {
        this.marketDataEnd = marketDataEnd;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="marketDataEnd", requiredMode=Schema.RequiredMode.REQUIRED)
    public MarketDataList getMarketDataEnd() {
        return this.marketDataEnd;
    }

    public void setMarketDataEnd(MarketDataList marketDataEnd) {
        this.marketDataEnd = marketDataEnd;
    }

    public MarginRequest tradeData(String tradeData) {
        this.tradeData = tradeData;
        return this;
    }

    @NotNull
    @Schema(name="tradeData", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getTradeData() {
        return this.tradeData;
    }

    public void setTradeData(String tradeData) {
        this.tradeData = tradeData;
    }

    public MarginRequest valuationDate(OffsetDateTime valuationDate) {
        this.valuationDate = valuationDate;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="valuationDate", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getValuationDate() {
        return this.valuationDate;
    }

    public void setValuationDate(OffsetDateTime valuationDate) {
        this.valuationDate = valuationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarginRequest marginRequest = (MarginRequest)o;
        return Objects.equals(this.marketDataStart, marginRequest.marketDataStart) && Objects.equals(this.marketDataEnd, marginRequest.marketDataEnd) && Objects.equals(this.tradeData, marginRequest.tradeData) && Objects.equals(this.valuationDate, marginRequest.valuationDate);
    }

    public int hashCode() {
        return Objects.hash(this.marketDataStart, this.marketDataEnd, this.tradeData, this.valuationDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MarginRequest {\n");
        sb.append("    marketDataStart: ").append(this.toIndentedString(this.marketDataStart)).append("\n");
        sb.append("    marketDataEnd: ").append(this.toIndentedString(this.marketDataEnd)).append("\n");
        sb.append("    tradeData: ").append(this.toIndentedString(this.tradeData)).append("\n");
        sb.append("    valuationDate: ").append(this.toIndentedString(this.valuationDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

