/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.data.LocalDateTimeAdapter;
import net.finmath.smartcontract.valuation.marketdata.data.MarketDataPoint;

@XmlRootElement
@XmlType(propOrder={"requestTimeStamp", "points"})
public class MarketDataList {
    List<MarketDataPoint> points;
    LocalDateTime requestTimeStamp = LocalDateTime.now();

    public MarketDataList() {
        this.points = new ArrayList<MarketDataPoint>();
    }

    public void setRequestTimeStamp(LocalDateTime timestamp) {
        this.requestTimeStamp = timestamp;
    }

    public void add(MarketDataPoint point) {
        this.points.add(point);
    }

    public void setPoints(List<MarketDataPoint> points) {
        this.points = points;
    }

    public int getSize() {
        return this.points.size();
    }

    @XmlElement(name="item")
    public List<MarketDataPoint> getPoints() {
        return this.points;
    }

    @XmlJavaTypeAdapter(value=LocalDateTimeAdapter.class)
    public LocalDateTime getRequestTimeStamp() {
        return this.requestTimeStamp;
    }

    public String serializeToJson() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        try {
            return mapper.writerFor(MarketDataList.class).writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return "";
        }
    }

    public CalibrationDataset mapToCalibrationDataSet() {
        return null;
    }

    public String toString() {
        return "MarketDataList{points=" + String.valueOf(this.points) + ", requestTimeStamp=" + String.valueOf(this.requestTimeStamp) + "}";
    }
}

