/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Objects;

public class PaymentFrequency {
    @JsonProperty(value="periodMultiplier")
    private Integer periodMultiplier;
    @JsonProperty(value="period")
    private String period;
    @JsonProperty(value="fullName")
    private String fullName;

    public PaymentFrequency periodMultiplier(Integer periodMultiplier) {
        this.periodMultiplier = periodMultiplier;
        return this;
    }

    @NotNull
    @Min(value=1L)
    @Schema(name="periodMultiplier", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @Min(value=1L) Integer getPeriodMultiplier() {
        return this.periodMultiplier;
    }

    public void setPeriodMultiplier(Integer periodMultiplier) {
        this.periodMultiplier = periodMultiplier;
    }

    public PaymentFrequency period(String period) {
        this.period = period;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[DMY]$")
    @Schema(name="period", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @Pattern(regexp="^[DMY]$") String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public PaymentFrequency fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @NotNull
    @Schema(name="fullName", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentFrequency paymentFrequency = (PaymentFrequency)o;
        return Objects.equals(this.periodMultiplier, paymentFrequency.periodMultiplier) && Objects.equals(this.period, paymentFrequency.period) && Objects.equals(this.fullName, paymentFrequency.fullName);
    }

    public int hashCode() {
        return Objects.hash(this.periodMultiplier, this.period, this.fullName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentFrequency {\n");
        sb.append("    periodMultiplier: ").append(this.toIndentedString(this.periodMultiplier)).append("\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

