/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.finmath.smartcontract.model.Counterparty;
import net.finmath.smartcontract.model.FrontendItemSpec;
import net.finmath.smartcontract.model.PaymentFrequency;
import org.springframework.format.annotation.DateTimeFormat;

public class PlainSwapOperationRequest {
    @JsonProperty(value="firstCounterparty")
    private Counterparty firstCounterparty;
    @JsonProperty(value="secondCounterparty")
    private Counterparty secondCounterparty;
    @JsonProperty(value="marginBufferAmount")
    private Double marginBufferAmount;
    @JsonProperty(value="terminationFeeAmount")
    private Double terminationFeeAmount;
    @JsonProperty(value="notionalAmount")
    private Double notionalAmount;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="uniqueTradeIdentifier")
    private String uniqueTradeIdentifier;
    @JsonProperty(value="tradeDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime tradeDate;
    @JsonProperty(value="effectiveDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime effectiveDate;
    @JsonProperty(value="terminationDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime terminationDate;
    @JsonProperty(value="fixedPayingParty")
    private Counterparty fixedPayingParty;
    @JsonProperty(value="fixedRate")
    private Double fixedRate;
    @JsonProperty(value="fixedDayCountFraction")
    private String fixedDayCountFraction;
    @JsonProperty(value="fixedPaymentFrequency")
    private PaymentFrequency fixedPaymentFrequency;
    @JsonProperty(value="floatingPayingParty")
    private Counterparty floatingPayingParty;
    @JsonProperty(value="floatingRateIndex")
    private String floatingRateIndex;
    @JsonProperty(value="floatingDayCountFraction")
    private String floatingDayCountFraction;
    @JsonProperty(value="floatingFixingDayOffset")
    private Integer floatingFixingDayOffset;
    @JsonProperty(value="floatingPaymentFrequency")
    private PaymentFrequency floatingPaymentFrequency;
    @JsonProperty(value="valuationSymbols")
    @Valid
    private List<FrontendItemSpec> valuationSymbols = new ArrayList<FrontendItemSpec>();
    @JsonProperty(value="currentGenerator")
    private String currentGenerator;

    public PlainSwapOperationRequest firstCounterparty(Counterparty firstCounterparty) {
        this.firstCounterparty = firstCounterparty;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="firstCounterparty", requiredMode=Schema.RequiredMode.REQUIRED)
    public Counterparty getFirstCounterparty() {
        return this.firstCounterparty;
    }

    public void setFirstCounterparty(Counterparty firstCounterparty) {
        this.firstCounterparty = firstCounterparty;
    }

    public PlainSwapOperationRequest secondCounterparty(Counterparty secondCounterparty) {
        this.secondCounterparty = secondCounterparty;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="secondCounterparty", requiredMode=Schema.RequiredMode.REQUIRED)
    public Counterparty getSecondCounterparty() {
        return this.secondCounterparty;
    }

    public void setSecondCounterparty(Counterparty secondCounterparty) {
        this.secondCounterparty = secondCounterparty;
    }

    public PlainSwapOperationRequest marginBufferAmount(Double marginBufferAmount) {
        this.marginBufferAmount = marginBufferAmount;
        return this;
    }

    @NotNull
    @DecimalMin(value="0.0")
    @Schema(name="marginBufferAmount", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @DecimalMin(value="0.0") Double getMarginBufferAmount() {
        return this.marginBufferAmount;
    }

    public void setMarginBufferAmount(Double marginBufferAmount) {
        this.marginBufferAmount = marginBufferAmount;
    }

    public PlainSwapOperationRequest terminationFeeAmount(Double terminationFeeAmount) {
        this.terminationFeeAmount = terminationFeeAmount;
        return this;
    }

    @NotNull
    @DecimalMin(value="0.0")
    @Schema(name="terminationFeeAmount", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @DecimalMin(value="0.0") Double getTerminationFeeAmount() {
        return this.terminationFeeAmount;
    }

    public void setTerminationFeeAmount(Double terminationFeeAmount) {
        this.terminationFeeAmount = terminationFeeAmount;
    }

    public PlainSwapOperationRequest notionalAmount(Double notionalAmount) {
        this.notionalAmount = notionalAmount;
        return this;
    }

    @NotNull
    @DecimalMin(value="0.0")
    @Schema(name="notionalAmount", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @DecimalMin(value="0.0") Double getNotionalAmount() {
        return this.notionalAmount;
    }

    public void setNotionalAmount(Double notionalAmount) {
        this.notionalAmount = notionalAmount;
    }

    public PlainSwapOperationRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @Schema(name="currency", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PlainSwapOperationRequest uniqueTradeIdentifier(String uniqueTradeIdentifier) {
        this.uniqueTradeIdentifier = uniqueTradeIdentifier;
        return this;
    }

    @Schema(name="uniqueTradeIdentifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getUniqueTradeIdentifier() {
        return this.uniqueTradeIdentifier;
    }

    public void setUniqueTradeIdentifier(String uniqueTradeIdentifier) {
        this.uniqueTradeIdentifier = uniqueTradeIdentifier;
    }

    public PlainSwapOperationRequest tradeDate(OffsetDateTime tradeDate) {
        this.tradeDate = tradeDate;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="tradeDate", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getTradeDate() {
        return this.tradeDate;
    }

    public void setTradeDate(OffsetDateTime tradeDate) {
        this.tradeDate = tradeDate;
    }

    public PlainSwapOperationRequest effectiveDate(OffsetDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="effectiveDate", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(OffsetDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public PlainSwapOperationRequest terminationDate(OffsetDateTime terminationDate) {
        this.terminationDate = terminationDate;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="terminationDate", requiredMode=Schema.RequiredMode.REQUIRED)
    public OffsetDateTime getTerminationDate() {
        return this.terminationDate;
    }

    public void setTerminationDate(OffsetDateTime terminationDate) {
        this.terminationDate = terminationDate;
    }

    public PlainSwapOperationRequest fixedPayingParty(Counterparty fixedPayingParty) {
        this.fixedPayingParty = fixedPayingParty;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="fixedPayingParty", requiredMode=Schema.RequiredMode.REQUIRED)
    public Counterparty getFixedPayingParty() {
        return this.fixedPayingParty;
    }

    public void setFixedPayingParty(Counterparty fixedPayingParty) {
        this.fixedPayingParty = fixedPayingParty;
    }

    public PlainSwapOperationRequest fixedRate(Double fixedRate) {
        this.fixedRate = fixedRate;
        return this;
    }

    @NotNull
    @Schema(name="fixedRate", requiredMode=Schema.RequiredMode.REQUIRED)
    public Double getFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(Double fixedRate) {
        this.fixedRate = fixedRate;
    }

    public PlainSwapOperationRequest fixedDayCountFraction(String fixedDayCountFraction) {
        this.fixedDayCountFraction = fixedDayCountFraction;
        return this;
    }

    @NotNull
    @Schema(name="fixedDayCountFraction", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getFixedDayCountFraction() {
        return this.fixedDayCountFraction;
    }

    public void setFixedDayCountFraction(String fixedDayCountFraction) {
        this.fixedDayCountFraction = fixedDayCountFraction;
    }

    public PlainSwapOperationRequest fixedPaymentFrequency(PaymentFrequency fixedPaymentFrequency) {
        this.fixedPaymentFrequency = fixedPaymentFrequency;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="fixedPaymentFrequency", requiredMode=Schema.RequiredMode.REQUIRED)
    public PaymentFrequency getFixedPaymentFrequency() {
        return this.fixedPaymentFrequency;
    }

    public void setFixedPaymentFrequency(PaymentFrequency fixedPaymentFrequency) {
        this.fixedPaymentFrequency = fixedPaymentFrequency;
    }

    public PlainSwapOperationRequest floatingPayingParty(Counterparty floatingPayingParty) {
        this.floatingPayingParty = floatingPayingParty;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="floatingPayingParty", requiredMode=Schema.RequiredMode.REQUIRED)
    public Counterparty getFloatingPayingParty() {
        return this.floatingPayingParty;
    }

    public void setFloatingPayingParty(Counterparty floatingPayingParty) {
        this.floatingPayingParty = floatingPayingParty;
    }

    public PlainSwapOperationRequest floatingRateIndex(String floatingRateIndex) {
        this.floatingRateIndex = floatingRateIndex;
        return this;
    }

    @NotNull
    @Schema(name="floatingRateIndex", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getFloatingRateIndex() {
        return this.floatingRateIndex;
    }

    public void setFloatingRateIndex(String floatingRateIndex) {
        this.floatingRateIndex = floatingRateIndex;
    }

    public PlainSwapOperationRequest floatingDayCountFraction(String floatingDayCountFraction) {
        this.floatingDayCountFraction = floatingDayCountFraction;
        return this;
    }

    @NotNull
    @Schema(name="floatingDayCountFraction", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getFloatingDayCountFraction() {
        return this.floatingDayCountFraction;
    }

    public void setFloatingDayCountFraction(String floatingDayCountFraction) {
        this.floatingDayCountFraction = floatingDayCountFraction;
    }

    public PlainSwapOperationRequest floatingFixingDayOffset(Integer floatingFixingDayOffset) {
        this.floatingFixingDayOffset = floatingFixingDayOffset;
        return this;
    }

    @NotNull
    @Min(value=-2L)
    @Max(value=2L)
    @Schema(name="floatingFixingDayOffset", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NotNull @Min(value=-2L) @Max(value=2L) Integer getFloatingFixingDayOffset() {
        return this.floatingFixingDayOffset;
    }

    public void setFloatingFixingDayOffset(Integer floatingFixingDayOffset) {
        this.floatingFixingDayOffset = floatingFixingDayOffset;
    }

    public PlainSwapOperationRequest floatingPaymentFrequency(PaymentFrequency floatingPaymentFrequency) {
        this.floatingPaymentFrequency = floatingPaymentFrequency;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="floatingPaymentFrequency", requiredMode=Schema.RequiredMode.REQUIRED)
    public PaymentFrequency getFloatingPaymentFrequency() {
        return this.floatingPaymentFrequency;
    }

    public void setFloatingPaymentFrequency(PaymentFrequency floatingPaymentFrequency) {
        this.floatingPaymentFrequency = floatingPaymentFrequency;
    }

    public PlainSwapOperationRequest valuationSymbols(List<FrontendItemSpec> valuationSymbols) {
        this.valuationSymbols = valuationSymbols;
        return this;
    }

    public PlainSwapOperationRequest addValuationSymbolsItem(FrontendItemSpec valuationSymbolsItem) {
        this.valuationSymbols.add(valuationSymbolsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="valuationSymbols", requiredMode=Schema.RequiredMode.REQUIRED)
    public List<FrontendItemSpec> getValuationSymbols() {
        return this.valuationSymbols;
    }

    public void setValuationSymbols(List<FrontendItemSpec> valuationSymbols) {
        this.valuationSymbols = valuationSymbols;
    }

    public PlainSwapOperationRequest currentGenerator(String currentGenerator) {
        this.currentGenerator = currentGenerator;
        return this;
    }

    @NotNull
    @Schema(name="currentGenerator", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getCurrentGenerator() {
        return this.currentGenerator;
    }

    public void setCurrentGenerator(String currentGenerator) {
        this.currentGenerator = currentGenerator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlainSwapOperationRequest plainSwapOperationRequest = (PlainSwapOperationRequest)o;
        return Objects.equals(this.firstCounterparty, plainSwapOperationRequest.firstCounterparty) && Objects.equals(this.secondCounterparty, plainSwapOperationRequest.secondCounterparty) && Objects.equals(this.marginBufferAmount, plainSwapOperationRequest.marginBufferAmount) && Objects.equals(this.terminationFeeAmount, plainSwapOperationRequest.terminationFeeAmount) && Objects.equals(this.notionalAmount, plainSwapOperationRequest.notionalAmount) && Objects.equals(this.currency, plainSwapOperationRequest.currency) && Objects.equals(this.uniqueTradeIdentifier, plainSwapOperationRequest.uniqueTradeIdentifier) && Objects.equals(this.tradeDate, plainSwapOperationRequest.tradeDate) && Objects.equals(this.effectiveDate, plainSwapOperationRequest.effectiveDate) && Objects.equals(this.terminationDate, plainSwapOperationRequest.terminationDate) && Objects.equals(this.fixedPayingParty, plainSwapOperationRequest.fixedPayingParty) && Objects.equals(this.fixedRate, plainSwapOperationRequest.fixedRate) && Objects.equals(this.fixedDayCountFraction, plainSwapOperationRequest.fixedDayCountFraction) && Objects.equals(this.fixedPaymentFrequency, plainSwapOperationRequest.fixedPaymentFrequency) && Objects.equals(this.floatingPayingParty, plainSwapOperationRequest.floatingPayingParty) && Objects.equals(this.floatingRateIndex, plainSwapOperationRequest.floatingRateIndex) && Objects.equals(this.floatingDayCountFraction, plainSwapOperationRequest.floatingDayCountFraction) && Objects.equals(this.floatingFixingDayOffset, plainSwapOperationRequest.floatingFixingDayOffset) && Objects.equals(this.floatingPaymentFrequency, plainSwapOperationRequest.floatingPaymentFrequency) && Objects.equals(this.valuationSymbols, plainSwapOperationRequest.valuationSymbols) && Objects.equals(this.currentGenerator, plainSwapOperationRequest.currentGenerator);
    }

    public int hashCode() {
        return Objects.hash(this.firstCounterparty, this.secondCounterparty, this.marginBufferAmount, this.terminationFeeAmount, this.notionalAmount, this.currency, this.uniqueTradeIdentifier, this.tradeDate, this.effectiveDate, this.terminationDate, this.fixedPayingParty, this.fixedRate, this.fixedDayCountFraction, this.fixedPaymentFrequency, this.floatingPayingParty, this.floatingRateIndex, this.floatingDayCountFraction, this.floatingFixingDayOffset, this.floatingPaymentFrequency, this.valuationSymbols, this.currentGenerator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlainSwapOperationRequest {\n");
        sb.append("    firstCounterparty: ").append(this.toIndentedString(this.firstCounterparty)).append("\n");
        sb.append("    secondCounterparty: ").append(this.toIndentedString(this.secondCounterparty)).append("\n");
        sb.append("    marginBufferAmount: ").append(this.toIndentedString(this.marginBufferAmount)).append("\n");
        sb.append("    terminationFeeAmount: ").append(this.toIndentedString(this.terminationFeeAmount)).append("\n");
        sb.append("    notionalAmount: ").append(this.toIndentedString(this.notionalAmount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    uniqueTradeIdentifier: ").append(this.toIndentedString(this.uniqueTradeIdentifier)).append("\n");
        sb.append("    tradeDate: ").append(this.toIndentedString(this.tradeDate)).append("\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    terminationDate: ").append(this.toIndentedString(this.terminationDate)).append("\n");
        sb.append("    fixedPayingParty: ").append(this.toIndentedString(this.fixedPayingParty)).append("\n");
        sb.append("    fixedRate: ").append(this.toIndentedString(this.fixedRate)).append("\n");
        sb.append("    fixedDayCountFraction: ").append(this.toIndentedString(this.fixedDayCountFraction)).append("\n");
        sb.append("    fixedPaymentFrequency: ").append(this.toIndentedString(this.fixedPaymentFrequency)).append("\n");
        sb.append("    floatingPayingParty: ").append(this.toIndentedString(this.floatingPayingParty)).append("\n");
        sb.append("    floatingRateIndex: ").append(this.toIndentedString(this.floatingRateIndex)).append("\n");
        sb.append("    floatingDayCountFraction: ").append(this.toIndentedString(this.floatingDayCountFraction)).append("\n");
        sb.append("    floatingFixingDayOffset: ").append(this.toIndentedString(this.floatingFixingDayOffset)).append("\n");
        sb.append("    floatingPaymentFrequency: ").append(this.toIndentedString(this.floatingPaymentFrequency)).append("\n");
        sb.append("    valuationSymbols: ").append(this.toIndentedString(this.valuationSymbols)).append("\n");
        sb.append("    currentGenerator: ").append(this.toIndentedString(this.currentGenerator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

