/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.product;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Optional;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;

public class IRSwapGenerator {
    public static final Swap generateAnalyticSwapObject(LocalDate startDate, String maturityLabel, double fixRate, boolean isReceiveFix, String forwardCurveName, String discountCurveName) {
        String frequencyLabel = forwardCurveName.contains("3M") ? "quarterly" : (forwardCurveName.contains("6M") ? "semiannual" : (forwardCurveName.contains("1M") ? "monthly" : "annual"));
        Schedule scheduleFloat = ScheduleGenerator.createScheduleFromConventions((LocalDate)startDate, (int)2, (String)"0D", (String)maturityLabel, (String)frequencyLabel, (String)"act/360", (String)"first", (String)"following", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        Schedule scheduleFix = ScheduleGenerator.createScheduleFromConventions((LocalDate)startDate, (int)2, (String)"0D", (String)maturityLabel, (String)"annual", (String)"E30/360", (String)"first", (String)"following", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)0, (int)0);
        SwapLeg floatLeg = new SwapLeg(Optional.of(LocalDateTime.of(startDate, LocalTime.of(0, 0))), scheduleFloat, forwardCurveName, 0.0, discountCurveName);
        SwapLeg fixLeg = new SwapLeg(Optional.of(LocalDateTime.of(startDate, LocalTime.of(0, 0))), scheduleFix, "", fixRate, discountCurveName);
        Swap swap = isReceiveFix ? new Swap((AnalyticProduct)fixLeg, (AnalyticProduct)floatLeg) : new Swap((AnalyticProduct)floatLeg, (AnalyticProduct)fixLeg);
        return swap;
    }
}

