/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.product.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterpolation;
import net.finmath.marketdata.model.curves.ForwardCurveWithFixings;
import net.finmath.modelling.descriptor.ScheduleDescriptor;
import net.finmath.smartcontract.model.CashflowPeriod;
import net.finmath.smartcontract.model.FrontendItemSpec;
import net.finmath.smartcontract.model.MarketDataSet;
import net.finmath.smartcontract.model.MarketDataSetValuesInner;
import net.finmath.smartcontract.model.PlainSwapOperationRequest;
import net.finmath.smartcontract.model.ValueResult;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.BusinessDayConventionEnum;
import net.finmath.smartcontract.product.xml.FloatingRateCalculation;
import net.finmath.smartcontract.product.xml.InterestRateStream;
import net.finmath.smartcontract.product.xml.Party;
import net.finmath.smartcontract.product.xml.PeriodEnum;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.product.xml.Smartderivativecontract;
import net.finmath.smartcontract.product.xml.Swap;
import net.finmath.smartcontract.product.xml.Trade;
import net.finmath.smartcontract.product.xml.TradeId;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationContextImpl;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParserDataItems;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.Calibrator;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.AbstractBusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.SAXException;

public final class PlainSwapEditorHandler {
    private static final Logger logger = LoggerFactory.getLogger(PlainSwapEditorHandler.class);
    private final Smartderivativecontract smartDerivativeContract;
    private final Schema sdcmlSchema;
    private final Marshaller marshaller;
    private final InterestRateStream floatingLeg;
    private final InterestRateStream fixedLeg;

    public PlainSwapEditorHandler(PlainSwapOperationRequest plainSwapOperationRequest, String templatePath, String schemaPath) throws IOException, SAXException, JAXBException, DatatypeConfigurationException {
        XMLGregorianCalendar formattedTerminationDate;
        XMLGregorianCalendar formattedEffectiveDate;
        XMLGregorianCalendar formattedTradeDate;
        Smartderivativecontract templateContract;
        Unmarshaller unmarshaller;
        JAXBContext jaxbContext;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.sdcmlSchema = schemaFactory.newSchema(new ClassPathResource(schemaPath).getURL());
        }
        catch (IOException | SAXException e) {
            logger.error("Failed to recover XSD schema. The file '" + schemaPath + "' is missing, unreachable or invalid.");
            throw e;
        }
        try {
            jaxbContext = JAXBContext.newInstance((String)"net.finmath.smartcontract.product.xml", (ClassLoader)this.getClass().getClassLoader());
        }
        catch (JAXBException e) {
            logger.error("Failed to load JAXB context.");
            throw e;
        }
        try {
            this.marshaller = jaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            logger.error("Failed to load JAXB marshaller.");
            throw e;
        }
        this.marshaller.setSchema(this.sdcmlSchema);
        try {
            unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            logger.error("Failed to load JAXB un-marshaller.");
            throw e;
        }
        unmarshaller.setSchema(this.sdcmlSchema);
        try {
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (PropertyException e) {
            logger.error("Failed to configure JAXB marshaller.");
            throw e;
        }
        this.smartDerivativeContract = new Smartderivativecontract();
        this.smartDerivativeContract.setUniqueTradeIdentifier("test123");
        try {
            ClassPathResource templateXmlResource = new ClassPathResource(templatePath);
            templateContract = (Smartderivativecontract)unmarshaller.unmarshal(templateXmlResource.getInputStream());
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshall the XML template file.");
            throw e;
        }
        catch (IOException e) {
            logger.error("An IO error occurred while unmarshalling the template file.");
            throw e;
        }
        PlainSwapEditorHandler.setSdcValuationHeader(this.smartDerivativeContract);
        PlainSwapEditorHandler.setSdcPartiesHeader(plainSwapOperationRequest, this.smartDerivativeContract);
        PlainSwapEditorHandler.setSdcSettlementHeader(plainSwapOperationRequest, this.smartDerivativeContract);
        this.smartDerivativeContract.setUnderlyings(templateContract.getUnderlyings());
        Trade trade = this.smartDerivativeContract.underlyings.underlying.dataDocument.trade.get(0);
        try {
            formattedTradeDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(GregorianCalendar.from(plainSwapOperationRequest.getTradeDate().toZonedDateTime()));
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Failed to convert OffsetDateTime to XMLGregorianCalendar. This occurred while processing field tradeDate");
            throw e;
        }
        formattedTradeDate.setTimezone(Integer.MIN_VALUE);
        trade.tradeHeader.tradeDate.setValue(formattedTradeDate);
        trade.tradeHeader.partyTradeIdentifier.get((int)0).tradeId = new TradeId();
        trade.tradeHeader.partyTradeIdentifier.get((int)0).tradeId.setValue("123456");
        trade.tradeHeader.partyTradeIdentifier.get((int)0).tradeId.setTradeIdScheme("test");
        trade.tradeHeader.partyTradeIdentifier.get((int)1).tradeId = new TradeId();
        trade.tradeHeader.partyTradeIdentifier.get((int)1).tradeId.setValue("123456");
        trade.tradeHeader.partyTradeIdentifier.get((int)1).tradeId.setTradeIdScheme("test");
        Swap swap = (Swap)this.smartDerivativeContract.underlyings.underlying.dataDocument.trade.get(0).getProduct().getValue();
        Optional<InterestRateStream> fixedLegOptional = swap.swapStream.stream().filter(PlainSwapEditorHandler::isFixedLeg).findFirst();
        if (fixedLegOptional.isEmpty()) {
            throw new IllegalStateException("The template has issues: failed to find valid candidate for fixed leg swapStream definition. I will fail now, sorry! :(");
        }
        this.fixedLeg = fixedLegOptional.get();
        Optional<InterestRateStream> floatingLegOptional = swap.swapStream.stream().filter(PlainSwapEditorHandler::isFloatingLeg).findFirst();
        if (floatingLegOptional.isEmpty()) {
            throw new IllegalStateException("The template has issues: failed to find valid candidate for floating leg swapStream definition. I will fail now, sorry! :(");
        }
        this.floatingLeg = floatingLegOptional.get();
        try {
            formattedEffectiveDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(GregorianCalendar.from(plainSwapOperationRequest.getEffectiveDate().toZonedDateTime()));
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Failed to convert ZonedDateTime to XMLGregorianCalendar. This occurred while processing field effectiveDate");
            throw e;
        }
        formattedEffectiveDate.setTimezone(Integer.MIN_VALUE);
        try {
            formattedTerminationDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(GregorianCalendar.from(plainSwapOperationRequest.getTerminationDate().toZonedDateTime()));
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Failed to convert ZonedDateTime to XMLGregorianCalendar. This occurred while processing field terminationDate");
            throw e;
        }
        formattedTerminationDate.setTimezone(Integer.MIN_VALUE);
        for (InterestRateStream swapLeg : swap.swapStream) {
            swapLeg.calculationPeriodDates.effectiveDate.unadjustedDate.setValue(formattedEffectiveDate);
            swapLeg.calculationPeriodDates.terminationDate.unadjustedDate.setValue(formattedTerminationDate);
            swapLeg.calculationPeriodAmount.calculation.notionalSchedule.notionalStepSchedule.initialValue = BigDecimal.valueOf(plainSwapOperationRequest.getNotionalAmount());
            swapLeg.calculationPeriodAmount.calculation.notionalSchedule.notionalStepSchedule.currency.value = plainSwapOperationRequest.getCurrency();
        }
        if (plainSwapOperationRequest.getFloatingPayingParty().getFullName().equals(this.smartDerivativeContract.parties.party.get((int)0).name)) {
            this.floatingLeg.payerPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(0);
            this.floatingLeg.receiverPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(1);
            this.fixedLeg.payerPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(1);
            this.fixedLeg.receiverPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(0);
        } else {
            this.floatingLeg.payerPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(1);
            this.floatingLeg.receiverPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(0);
            this.fixedLeg.payerPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(0);
            this.fixedLeg.receiverPartyReference.href = this.smartDerivativeContract.underlyings.underlying.dataDocument.party.get(1);
        }
        this.floatingLeg.resetDates.fixingDates.periodMultiplier = BigInteger.valueOf(plainSwapOperationRequest.getFloatingFixingDayOffset().longValue());
        logger.info("Reading back floating fixing date offset: " + String.valueOf(this.floatingLeg.resetDates.fixingDates.periodMultiplier));
        this.floatingLeg.calculationPeriodAmount.calculation.dayCountFraction.value = plainSwapOperationRequest.getFloatingDayCountFraction();
        logger.info("Reading back floating day count fraction: " + this.floatingLeg.calculationPeriodAmount.calculation.dayCountFraction.value);
        this.floatingLeg.paymentDates.paymentFrequency.periodMultiplier = BigInteger.valueOf(plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriodMultiplier().longValue());
        logger.info("Reading back floating payment frequency period multiplier: " + String.valueOf(this.floatingLeg.paymentDates.paymentFrequency.periodMultiplier));
        this.floatingLeg.paymentDates.paymentFrequency.setPeriod(plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriod());
        logger.info("Reading back floating payment frequency period:  " + this.floatingLeg.paymentDates.paymentFrequency.period);
        ((FloatingRateCalculation)this.floatingLeg.calculationPeriodAmount.calculation.getRateCalculation().getValue()).floatingRateIndex.value = plainSwapOperationRequest.getFloatingRateIndex();
        logger.info("Reading back floating rate index: " + ((FloatingRateCalculation)this.floatingLeg.calculationPeriodAmount.calculation.getRateCalculation().getValue()).floatingRateIndex.value);
        this.fixedLeg.calculationPeriodAmount.calculation.dayCountFraction.value = plainSwapOperationRequest.getFixedDayCountFraction();
        logger.info("Reading back fixed day count fraction " + this.fixedLeg.calculationPeriodAmount.calculation.dayCountFraction.value);
        this.fixedLeg.calculationPeriodAmount.calculation.fixedRateSchedule.initialValue = BigDecimal.valueOf(plainSwapOperationRequest.getFixedRate()).setScale(12, RoundingMode.HALF_EVEN).divide(BigDecimal.valueOf(100L).setScale(12, RoundingMode.HALF_EVEN), RoundingMode.HALF_EVEN);
        logger.info("Reading back fixed rate: " + String.valueOf(this.fixedLeg.calculationPeriodAmount.calculation.fixedRateSchedule.initialValue));
        this.fixedLeg.paymentDates.paymentFrequency.periodMultiplier = BigInteger.valueOf(plainSwapOperationRequest.getFixedPaymentFrequency().getPeriodMultiplier().longValue());
        logger.info("Reading back fixed period multiplier: " + String.valueOf(this.fixedLeg.paymentDates.paymentFrequency.periodMultiplier));
        this.fixedLeg.paymentDates.paymentFrequency.period = plainSwapOperationRequest.getFixedPaymentFrequency().getPeriod();
        logger.info("Reading back fixed period: " + this.fixedLeg.paymentDates.paymentFrequency.period);
        this.fixedLeg.calculationPeriodDates.calculationPeriodFrequency.periodMultiplier = BigInteger.valueOf(plainSwapOperationRequest.getFixedPaymentFrequency().getPeriodMultiplier().longValue());
        this.fixedLeg.calculationPeriodDates.calculationPeriodFrequency.setPeriod(plainSwapOperationRequest.getFixedPaymentFrequency().getPeriod());
        this.floatingLeg.calculationPeriodDates.calculationPeriodFrequency.periodMultiplier = BigInteger.valueOf(plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriodMultiplier().longValue());
        this.floatingLeg.calculationPeriodDates.calculationPeriodFrequency.period = plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriod();
        this.floatingLeg.calculationPeriodDates.calculationPeriodFrequency.setRollConvention("EOM");
        this.floatingLeg.resetDates.resetFrequency.periodMultiplier = BigInteger.valueOf(plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriodMultiplier().longValue());
        this.floatingLeg.resetDates.resetFrequency.period = plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriod();
        ((FloatingRateCalculation)this.floatingLeg.calculationPeriodAmount.calculation.getRateCalculation().getValue()).indexTenor.periodMultiplier = BigInteger.valueOf(plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriodMultiplier().longValue());
        ((FloatingRateCalculation)this.floatingLeg.calculationPeriodAmount.calculation.getRateCalculation().getValue()).indexTenor.period = PeriodEnum.valueOf(plainSwapOperationRequest.getFloatingPaymentFrequency().getPeriod());
        this.smartDerivativeContract.receiverPartyID = "party2";
        logger.info("Instance built!");
    }

    private static boolean isFloatingLeg(InterestRateStream swapStream) {
        return swapStream.getCalculationPeriodAmount().getCalculation().getRateCalculation().getDeclaredType().equals(FloatingRateCalculation.class) && Objects.isNull(swapStream.getCalculationPeriodAmount().getCalculation().getFixedRateSchedule());
    }

    private static boolean isFixedLeg(InterestRateStream swapStream) {
        return !Objects.isNull(swapStream.getCalculationPeriodAmount().getCalculation().getFixedRateSchedule()) && Objects.isNull(swapStream.getCalculationPeriodAmount().getCalculation().getRateCalculation());
    }

    private static void setSdcSettlementHeader(PlainSwapOperationRequest plainSwapOperationRequest, Smartderivativecontract sdc) {
        Smartderivativecontract.Settlement settlementHeader = new Smartderivativecontract.Settlement();
        settlementHeader.setSettlementDateInitial(plainSwapOperationRequest.getTradeDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + "T12:00:00");
        settlementHeader.settlementTime = new Smartderivativecontract.Settlement.SettlementTime();
        settlementHeader.settlementTime.value = "17:00";
        settlementHeader.settlementTime.type = "daily";
        settlementHeader.marketdata = new Smartderivativecontract.Settlement.Marketdata();
        settlementHeader.marketdata.provider = "refinitiv";
        Smartderivativecontract.Settlement.Marketdata.Marketdataitems marketDataItems = new Smartderivativecontract.Settlement.Marketdata.Marketdataitems();
        for (FrontendItemSpec marketDataItem : plainSwapOperationRequest.getValuationSymbols()) {
            Smartderivativecontract.Settlement.Marketdata.Marketdataitems.Item newItem = new Smartderivativecontract.Settlement.Marketdata.Marketdataitems.Item();
            newItem.curve = new ArrayList<String>();
            newItem.symbol = new ArrayList<String>();
            newItem.type = new ArrayList<String>();
            newItem.tenor = new ArrayList<String>();
            newItem.curve.add(marketDataItem.getCurve());
            newItem.symbol.add(marketDataItem.getSymbol());
            newItem.type.add(marketDataItem.getItemType());
            newItem.tenor.add(marketDataItem.getTenor());
            marketDataItems.getItem().add(newItem);
        }
        settlementHeader.marketdata.marketdataitems = marketDataItems;
        sdc.setSettlement(settlementHeader);
    }

    private static void setSdcPartiesHeader(PlainSwapOperationRequest tradeDescriptor, Smartderivativecontract smartDerivativeContract) {
        logger.info("Setting SDC header of response.");
        Smartderivativecontract.Parties parties = new Smartderivativecontract.Parties();
        ArrayList<Smartderivativecontract.Parties.Party> partyList = new ArrayList<Smartderivativecontract.Parties.Party>();
        Smartderivativecontract.Parties.Party party1 = new Smartderivativecontract.Parties.Party();
        logger.info("Setting id party1 for party " + String.valueOf(tradeDescriptor.getFirstCounterparty()));
        party1.setName(tradeDescriptor.getFirstCounterparty().getFullName());
        party1.setId("party1");
        Smartderivativecontract.Parties.Party.MarginAccount marginAccount1 = new Smartderivativecontract.Parties.Party.MarginAccount();
        marginAccount1.setType("constant");
        marginAccount1.setValue(tradeDescriptor.getMarginBufferAmount().floatValue());
        Smartderivativecontract.Parties.Party.PenaltyFee penaltyFee1 = new Smartderivativecontract.Parties.Party.PenaltyFee();
        penaltyFee1.setType("constant");
        penaltyFee1.setValue(tradeDescriptor.getTerminationFeeAmount().floatValue());
        party1.setAddress("0x0");
        logger.info("Setting id party2 for party " + String.valueOf(tradeDescriptor.getSecondCounterparty()));
        Smartderivativecontract.Parties.Party party2 = new Smartderivativecontract.Parties.Party();
        party2.setName(tradeDescriptor.getSecondCounterparty().getFullName());
        party2.setId("party2");
        Smartderivativecontract.Parties.Party.MarginAccount marginAccount2 = new Smartderivativecontract.Parties.Party.MarginAccount();
        marginAccount2.setType("constant");
        marginAccount2.setValue(tradeDescriptor.getMarginBufferAmount().floatValue());
        Smartderivativecontract.Parties.Party.PenaltyFee penaltyFee2 = new Smartderivativecontract.Parties.Party.PenaltyFee();
        penaltyFee2.setType("constant");
        penaltyFee2.setValue(tradeDescriptor.getTerminationFeeAmount().floatValue());
        party2.setAddress("0x0");
        party1.setMarginAccount(marginAccount1);
        party1.setPenaltyFee(penaltyFee1);
        party2.setMarginAccount(marginAccount2);
        party2.setPenaltyFee(penaltyFee2);
        partyList.add(party1);
        partyList.add(party2);
        parties.party = partyList;
        smartDerivativeContract.setParties(parties);
    }

    private static void setSdcValuationHeader(Smartderivativecontract smartDerivativeContract) {
        Smartderivativecontract.Valuation valuationHeader = new Smartderivativecontract.Valuation();
        Smartderivativecontract.Valuation.Artefact artifactHeader = new Smartderivativecontract.Valuation.Artefact();
        artifactHeader.setGroupId("net.finmath");
        artifactHeader.setArtifactId("finmath-smart-derivative-contract");
        artifactHeader.setVersion("0.1.8");
        valuationHeader.setArtefact(artifactHeader);
        smartDerivativeContract.setValuation(valuationHeader);
    }

    public String getContractAsXmlString() throws IOException, SAXException, JAXBException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.marshaller.marshal((Object)this.smartDerivativeContract, (OutputStream)outputStream);
        }
        catch (JAXBException e) {
            logger.error("Failed to marshall out the generated XML. Check your inputs.");
            throw e;
        }
        try {
            Validator validator = this.sdcmlSchema.newValidator();
            validator.validate(new StreamSource(new ByteArrayInputStream(outputStream.toByteArray())));
            logger.info("Validation successful!");
            logger.info("XML was correctly generated, will now do some suboptimal text handling.");
            return outputStream.toString().replaceAll("<fpml:dataDocument fpmlVersion=\"5-9\">", "<dataDocument fpmlVersion=\"5-9\" xmlns=\"http://www.fpml.org/FpML-5/confirmation\">").replaceAll("fpml:", "");
        }
        catch (SAXException e) {
            logger.error("Failed to validate the generated XML or some unrecoverable error occurred while validating.");
            logger.error("Details: {}", (Object)e.getMessage());
            throw e;
        }
        catch (IOException e) {
            logger.error("Failed to marshall out the generated XML file.");
            logger.error("Details: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public Smartderivativecontract getContract() {
        return this.smartDerivativeContract;
    }

    public List<CashflowPeriod> getSchedule(LegSelector legSelector, String marketData) throws IOException, CloneNotSupportedException {
        InterestRateStream swapLeg;
        switch (legSelector) {
            case FIXED_LEG: {
                swapLeg = this.fixedLeg;
                logger.info("Fixed leg detected.");
                break;
            }
            case FLOATING_LEG: {
                swapLeg = this.floatingLeg;
                logger.info("Floating leg detected.");
                break;
            }
            default: {
                throw new IllegalArgumentException("Failed to detect leg type");
            }
        }
        LocalDate startDate = swapLeg.getCalculationPeriodDates().getEffectiveDate().getUnadjustedDate().getValue().toGregorianCalendar().toZonedDateTime().toLocalDate();
        logger.info("Start date detected: " + startDate.toString());
        LocalDate maturityDate = swapLeg.getCalculationPeriodDates().getTerminationDate().getUnadjustedDate().getValue().toGregorianCalendar().toZonedDateTime().toLocalDate();
        logger.info("Maturity date detected: " + maturityDate.toString());
        int fixingOffsetDays = 0;
        try {
            fixingOffsetDays = swapLeg.getResetDates().getFixingDates().getPeriodMultiplier().intValue();
        }
        catch (NullPointerException npe) {
            logger.warn("No fixing offset was detected, 0 implied.");
        }
        int paymentOffsetDays = 0;
        try {
            paymentOffsetDays = swapLeg.getPaymentDates().getPaymentDaysOffset().getPeriodMultiplier().intValue();
        }
        catch (NullPointerException npe) {
            logger.warn("No payment offset was detected, 0 implied.");
        }
        BusinessdayCalendar.DateRollConvention dateRollConvention = switch (swapLeg.getPaymentDates().getPaymentDatesAdjustments().getBusinessDayConvention()) {
            case BusinessDayConventionEnum.PRECEDING -> BusinessdayCalendar.DateRollConvention.PRECEDING;
            case BusinessDayConventionEnum.MODPRECEDING -> BusinessdayCalendar.DateRollConvention.MODIFIED_PRECEDING;
            case BusinessDayConventionEnum.FOLLOWING -> BusinessdayCalendar.DateRollConvention.FOLLOWING;
            case BusinessDayConventionEnum.MODFOLLOWING -> BusinessdayCalendar.DateRollConvention.MODIFIED_FOLLOWING;
            case BusinessDayConventionEnum.NONE -> BusinessdayCalendar.DateRollConvention.UNADJUSTED;
            default -> throw new IllegalArgumentException("Unrecognized date roll convention: " + String.valueOf((Object)swapLeg.getPaymentDates().getPaymentDatesAdjustments().getBusinessDayConvention()));
        };
        logger.info("Date roll convention detected: " + String.valueOf(dateRollConvention));
        ScheduleGenerator.DaycountConvention daycountConvention = ScheduleGenerator.DaycountConvention.getEnum((String)swapLeg.getCalculationPeriodAmount().getCalculation().getDayCountFraction().getValue());
        ScheduleGenerator.Frequency frequency = null;
        int multiplier = swapLeg.getPaymentDates().getPaymentFrequency().getPeriodMultiplier().intValue();
        logger.info("Reading period symbol: " + swapLeg.getPaymentDates().getPaymentFrequency().getPeriod());
        switch (swapLeg.getPaymentDates().getPaymentFrequency().getPeriod()) {
            case "D": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.DAILY;
                break;
            }
            case "Y": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.ANNUAL;
                break;
            }
            case "M": {
                frequency = switch (multiplier) {
                    case 1 -> ScheduleGenerator.Frequency.MONTHLY;
                    case 3 -> ScheduleGenerator.Frequency.QUARTERLY;
                    case 6 -> ScheduleGenerator.Frequency.SEMIANNUAL;
                    default -> throw new IllegalArgumentException("Unknown periodMultiplier " + swapLeg.getPaymentDates().getPaymentFrequency().getPeriodMultiplier().intValue() + ".");
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown period " + swapLeg.getPaymentDates().getPaymentFrequency().getPeriod() + ".");
            }
        }
        logger.info("Payment frequency detected: " + String.valueOf(Objects.requireNonNull(frequency)));
        ScheduleDescriptor scheduleDescriptor = new ScheduleDescriptor(startDate, maturityDate, frequency, daycountConvention, ScheduleGenerator.ShortPeriodConvention.LAST, dateRollConvention, (AbstractBusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), fixingOffsetDays, paymentOffsetDays);
        ArrayList<CashflowPeriod> cashflowPeriods = new ArrayList<CashflowPeriod>();
        Schedule schedule = scheduleDescriptor.getSchedule(this.smartDerivativeContract.underlyings.underlying.dataDocument.trade.get((int)0).tradeHeader.tradeDate.value.toGregorianCalendar().toZonedDateTime().toLocalDate());
        double notional = swapLeg.calculationPeriodAmount.calculation.notionalSchedule.notionalStepSchedule.initialValue.doubleValue();
        String forwardCurveID = "forward-EUR-6M";
        String discountCurveID = "discount-EUR-OIS";
        AnalyticModel calibratedModel = this.getAnalyticModel(marketData, schedule, forwardCurveID, discountCurveID);
        String currency = swapLeg.calculationPeriodAmount.calculation.notionalSchedule.notionalStepSchedule.currency.value;
        int i = 0;
        for (Period schedulePeriod : schedule) {
            double rate = legSelector.equals((Object)LegSelector.FIXED_LEG) ? swapLeg.calculationPeriodAmount.calculation.fixedRateSchedule.initialValue.doubleValue() : calibratedModel.getForwardCurve(forwardCurveID).getForward(calibratedModel, schedule.getFixing(i));
            double homePartyIsPayerPartyFactor = ((Party)swapLeg.payerPartyReference.href).id.equals(this.smartDerivativeContract.receiverPartyID) ? 1.0 : -1.0;
            cashflowPeriods.add(new CashflowPeriod().cashflow(new ValueResult().currency(currency).valuationDate(new Date().toString()).value(BigDecimal.valueOf(homePartyIsPayerPartyFactor * schedule.getPeriodLength(i) * notional * rate))).fixingDate(OffsetDateTime.of(schedulePeriod.getFixing(), LocalTime.NOON, ZoneOffset.UTC)).paymentDate(OffsetDateTime.of(schedulePeriod.getPayment(), LocalTime.NOON, ZoneOffset.UTC)).periodStart(OffsetDateTime.of(schedulePeriod.getPeriodStart(), LocalTime.NOON, ZoneOffset.UTC)).periodEnd(OffsetDateTime.of(schedulePeriod.getPeriodEnd(), LocalTime.NOON, ZoneOffset.UTC)).rate(rate));
            ++i;
        }
        return cashflowPeriods;
    }

    public List<CashflowPeriod> getSchedule(LegSelector legSelector, MarketDataSet marketData) throws IOException, CloneNotSupportedException {
        InterestRateStream swapLeg;
        switch (legSelector) {
            case FIXED_LEG: {
                swapLeg = this.fixedLeg;
                logger.info("Fixed leg detected.");
                break;
            }
            case FLOATING_LEG: {
                swapLeg = this.floatingLeg;
                logger.info("Floating leg detected.");
                break;
            }
            default: {
                throw new IllegalArgumentException("Failed to detect leg type");
            }
        }
        LocalDate startDate = swapLeg.getCalculationPeriodDates().getEffectiveDate().getUnadjustedDate().getValue().toGregorianCalendar().toZonedDateTime().toLocalDate();
        logger.info("Start date detected: " + startDate.toString());
        LocalDate maturityDate = swapLeg.getCalculationPeriodDates().getTerminationDate().getUnadjustedDate().getValue().toGregorianCalendar().toZonedDateTime().toLocalDate();
        logger.info("Maturity date detected: " + maturityDate.toString());
        int fixingOffsetDays = 0;
        try {
            fixingOffsetDays = swapLeg.getResetDates().getFixingDates().getPeriodMultiplier().intValue();
        }
        catch (NullPointerException npe) {
            logger.warn("No fixing offset was detected, 0 implied.");
        }
        int paymentOffsetDays = 0;
        try {
            paymentOffsetDays = swapLeg.getPaymentDates().getPaymentDaysOffset().getPeriodMultiplier().intValue();
        }
        catch (NullPointerException npe) {
            logger.warn("No payment offset was detected, 0 implied.");
        }
        BusinessdayCalendar.DateRollConvention dateRollConvention = switch (swapLeg.getPaymentDates().getPaymentDatesAdjustments().getBusinessDayConvention()) {
            case BusinessDayConventionEnum.PRECEDING -> BusinessdayCalendar.DateRollConvention.PRECEDING;
            case BusinessDayConventionEnum.MODPRECEDING -> BusinessdayCalendar.DateRollConvention.MODIFIED_PRECEDING;
            case BusinessDayConventionEnum.FOLLOWING -> BusinessdayCalendar.DateRollConvention.FOLLOWING;
            case BusinessDayConventionEnum.MODFOLLOWING -> BusinessdayCalendar.DateRollConvention.MODIFIED_FOLLOWING;
            case BusinessDayConventionEnum.NONE -> BusinessdayCalendar.DateRollConvention.UNADJUSTED;
            default -> throw new IllegalArgumentException("Unrecognized date roll convention: " + String.valueOf((Object)swapLeg.getPaymentDates().getPaymentDatesAdjustments().getBusinessDayConvention()));
        };
        logger.info("Date roll convention detected: " + String.valueOf(dateRollConvention));
        ScheduleGenerator.DaycountConvention daycountConvention = ScheduleGenerator.DaycountConvention.getEnum((String)swapLeg.getCalculationPeriodAmount().getCalculation().getDayCountFraction().getValue());
        ScheduleGenerator.Frequency frequency = null;
        int multiplier = swapLeg.getPaymentDates().getPaymentFrequency().getPeriodMultiplier().intValue();
        logger.info("Reading period symbol: " + swapLeg.getPaymentDates().getPaymentFrequency().getPeriod());
        switch (swapLeg.getPaymentDates().getPaymentFrequency().getPeriod()) {
            case "D": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.DAILY;
                break;
            }
            case "Y": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.ANNUAL;
                break;
            }
            case "M": {
                frequency = switch (multiplier) {
                    case 1 -> ScheduleGenerator.Frequency.MONTHLY;
                    case 3 -> ScheduleGenerator.Frequency.QUARTERLY;
                    case 6 -> ScheduleGenerator.Frequency.SEMIANNUAL;
                    default -> throw new IllegalArgumentException("Unknown periodMultiplier " + swapLeg.getPaymentDates().getPaymentFrequency().getPeriodMultiplier().intValue() + ".");
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown period " + swapLeg.getPaymentDates().getPaymentFrequency().getPeriod() + ".");
            }
        }
        logger.info("Payment frequency detected: " + String.valueOf(Objects.requireNonNull(frequency)));
        ScheduleDescriptor scheduleDescriptor = new ScheduleDescriptor(startDate, maturityDate, frequency, daycountConvention, ScheduleGenerator.ShortPeriodConvention.LAST, dateRollConvention, (AbstractBusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), fixingOffsetDays, paymentOffsetDays);
        ArrayList<CashflowPeriod> cashflowPeriods = new ArrayList<CashflowPeriod>();
        Schedule schedule = scheduleDescriptor.getSchedule(this.smartDerivativeContract.underlyings.underlying.dataDocument.trade.get((int)0).tradeHeader.tradeDate.value.toGregorianCalendar().toZonedDateTime().toLocalDate());
        double notional = swapLeg.calculationPeriodAmount.calculation.notionalSchedule.notionalStepSchedule.initialValue.doubleValue();
        String forwardCurveID = "forward-EUR-6M";
        String discountCurveID = "discount-EUR-OIS";
        AnalyticModel calibratedModel = this.getAnalyticModel(marketData, schedule, forwardCurveID, discountCurveID);
        String currency = swapLeg.calculationPeriodAmount.calculation.notionalSchedule.notionalStepSchedule.currency.value;
        double timeDiff = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)marketData.getRequestTimestamp().toLocalDate().atStartOfDay(), (LocalDateTime)marketData.getRequestTimestamp().toLocalDateTime());
        int i = 0;
        for (Period schedulePeriod : schedule) {
            double rate = legSelector.equals((Object)LegSelector.FIXED_LEG) ? swapLeg.calculationPeriodAmount.calculation.fixedRateSchedule.initialValue.doubleValue() : calibratedModel.getForwardCurve(forwardCurveID).getForward(calibratedModel, schedule.getFixing(i) + timeDiff);
            double homePartyIsPayerPartyFactor = ((Party)swapLeg.payerPartyReference.href).id.equals(this.smartDerivativeContract.receiverPartyID) ? 1.0 : -1.0;
            cashflowPeriods.add(new CashflowPeriod().cashflow(new ValueResult().currency(currency).valuationDate(new Date().toString()).value(BigDecimal.valueOf(homePartyIsPayerPartyFactor * schedule.getPeriodLength(i) * notional * rate))).fixingDate(OffsetDateTime.of(schedulePeriod.getFixing(), LocalTime.NOON, ZoneOffset.UTC)).paymentDate(OffsetDateTime.of(schedulePeriod.getPayment(), LocalTime.NOON, ZoneOffset.UTC)).periodStart(OffsetDateTime.of(schedulePeriod.getPeriodStart(), LocalTime.NOON, ZoneOffset.UTC)).periodEnd(OffsetDateTime.of(schedulePeriod.getPeriodEnd(), LocalTime.NOON, ZoneOffset.UTC)).rate(rate));
            ++i;
        }
        return cashflowPeriods;
    }

    private AnalyticModel getAnalyticModel(String marketData, Schedule schedule, String forwardCurveID, String discountCurveID) throws IOException, CloneNotSupportedException {
        Optional<CalibrationResult> optionalCalibrationResult;
        List<CalibrationDataset> marketDataSets;
        try {
            marketDataSets = CalibrationParserDataItems.getScenariosFromJsonString(marketData);
        }
        catch (IOException e) {
            logger.error("Failed to load market data.");
            throw e;
        }
        Validate.isTrue((marketDataSets.size() == 1 ? 1 : 0) != 0, (String)"Parameter marketData should be only a single market data set", (Object[])new Object[0]);
        LocalDateTime marketDataTime = marketDataSets.get(0).getDate();
        Optional<CalibrationDataset> optionalScenario = marketDataSets.stream().filter(scenario -> scenario.getDate().equals(marketDataTime)).findAny();
        if (!optionalScenario.isPresent()) {
            throw new IllegalStateException("Failed to load calibration dataset.");
        }
        CalibrationDataset scenario2 = optionalScenario.get();
        LocalDate referenceDate = marketDataTime.toLocalDate();
        CalibrationParserDataItems parser = new CalibrationParserDataItems();
        Calibrator calibrator = null;
        Stream<CalibrationSpecProvider> allCalibrationItems = scenario2.getDataAsCalibrationDataPointStream(parser);
        try {
            optionalCalibrationResult = calibrator.calibrateModel(allCalibrationItems, new CalibrationContextImpl(referenceDate, 1.0E-9));
        }
        catch (CloneNotSupportedException e) {
            logger.error("Failed to calibrate model.");
            throw e;
        }
        if (!optionalCalibrationResult.isPresent()) {
            throw new IllegalStateException("Failed to calibrate model.");
        }
        AnalyticModel calibratedModel = optionalCalibrationResult.get().getCalibratedModel();
        Set<CalibrationDataItem> pastFixings = scenario2.getFixingDataItems();
        ForwardCurveInterpolation fixedCurve = this.getCurvePastFixings("fixedCurve", referenceDate, calibratedModel, discountCurveID, pastFixings);
        ForwardCurveWithFixings forwardCurveWithFixings = new ForwardCurveWithFixings(calibratedModel.getForwardCurve(forwardCurveID), (ForwardCurve)fixedCurve, schedule.getFixing(0), 0.0);
        Curve[] finalCurves = new Curve[]{calibratedModel.getDiscountCurve(discountCurveID), calibratedModel.getForwardCurve(forwardCurveID), forwardCurveWithFixings};
        calibratedModel = new AnalyticModelFromCurvesAndVols(referenceDate, finalCurves);
        return calibratedModel;
    }

    private AnalyticModel getAnalyticModel(MarketDataSet marketData, Schedule schedule, String forwardCurveID, String discountCurveID) throws IOException, CloneNotSupportedException {
        Optional<CalibrationResult> optionalCalibrationResult;
        SmartDerivativeContractDescriptor productDescriptor = null;
        try {
            productDescriptor = SDCXMLParser.parse(this.getContractAsXmlString());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        HashSet<CalibrationDataItem> cdi = new HashSet<CalibrationDataItem>();
        List<CalibrationDataItem.Spec> mdReferences = productDescriptor.getMarketdataItemList();
        List<MarketDataSetValuesInner> mdValues = marketData.getValues();
        for (CalibrationDataItem.Spec mdr : mdReferences) {
            for (MarketDataSetValuesInner mdv : mdValues) {
                if (!mdv.getSymbol().equals(mdr.getKey())) continue;
                cdi.add(new CalibrationDataItem(mdr, mdv.getValue(), mdv.getDataTimestamp().toLocalDateTime()));
            }
        }
        ArrayList<CalibrationDataset> marketDataSets = new ArrayList<CalibrationDataset>();
        marketDataSets.add(new CalibrationDataset(cdi, marketData.getRequestTimestamp().toLocalDateTime()));
        LocalDateTime marketDataTime = marketData.getRequestTimestamp().toLocalDateTime();
        Optional<CalibrationDataset> optionalScenario = marketDataSets.stream().filter(scenario -> scenario.getDate().equals(marketDataTime)).findAny();
        if (!optionalScenario.isPresent()) {
            throw new IllegalStateException("Failed to load calibration dataset.");
        }
        CalibrationDataset scenario2 = optionalScenario.get();
        LocalDate referenceDate = marketDataTime.toLocalDate();
        CalibrationParserDataItems parser = new CalibrationParserDataItems();
        Stream<CalibrationSpecProvider> allCalibrationItems = scenario2.getDataAsCalibrationDataPointStream(parser);
        Calibrator calibrator = new Calibrator(scenario2.getDataPoints().stream().filter(ci -> ci.getSpec().getProductName().equals("Fixing") || ci.getSpec().getProductName().equals("Deposit")).toList(), new CalibrationContextImpl(referenceDate, 1.0E-9));
        try {
            optionalCalibrationResult = calibrator.calibrateModel(allCalibrationItems, new CalibrationContextImpl(referenceDate, 1.0E-9));
        }
        catch (CloneNotSupportedException e) {
            logger.error("Failed to calibrate model.");
            throw e;
        }
        if (!optionalCalibrationResult.isPresent()) {
            throw new IllegalStateException("Failed to calibrate model.");
        }
        AnalyticModel calibratedModel = optionalCalibrationResult.get().getCalibratedModel();
        return calibratedModel;
    }

    private ForwardCurveInterpolation getCurvePastFixings(String curveID, LocalDate referenceDate, AnalyticModel model, String discountCurveName, Set<CalibrationDataItem> pastFixings) {
        LinkedHashMap fixingMap = new LinkedHashMap();
        pastFixings.forEach(item -> fixingMap.put(FloatingpointDate.getFloatingPointDateFromDate((LocalDate)referenceDate, (LocalDate)item.getDate()), item.getQuote()));
        double[] pastFixingTimes = fixingMap.keySet().stream().mapToDouble(time -> time).toArray();
        double[] pastFixingsValues = Arrays.stream(pastFixingTimes).map(fixingMap::get).toArray();
        ForwardCurveInterpolation.InterpolationEntityForward interpolationEntityForward = ForwardCurveInterpolation.InterpolationEntityForward.FORWARD;
        return ForwardCurveInterpolation.createForwardCurveFromForwards((String)curveID, (LocalDate)referenceDate, (String)"offsetcode", (ForwardCurveInterpolation.InterpolationEntityForward)interpolationEntityForward, (String)discountCurveName, (AnalyticModel)model, (double[])pastFixingTimes, (double[])pastFixingsValues);
    }

    public static enum LegSelector {
        FIXED_LEG,
        FLOATING_LEG;

    }
}

