/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.statemachine;

import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.StateMachineBuilder;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.state.State;

public class SmartContractStateMachine {
    private boolean isPrefunded = true;
    private boolean isMatured = false;
    private boolean isSettlementSuccessful = true;

    public static void main(String[] args) throws Exception {
        SmartContractStateMachine sdcStateMachine = new SmartContractStateMachine();
        StateMachine<States, Events> stateMachine = sdcStateMachine.buildMachine();
        sdcStateMachine.setMatured(false).setPrefunded(true).setSettlementSuccessful(true);
        stateMachine.start();
        stateMachine.sendEvent((Object)Events.INCEPT);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        sdcStateMachine.setMatured(true);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.stop();
        sdcStateMachine.setMatured(false).setPrefunded(true).setSettlementSuccessful(true);
        stateMachine.start();
        stateMachine.sendEvent((Object)Events.INCEPT);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        sdcStateMachine.setPrefunded(false);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.stop();
        sdcStateMachine.setMatured(false);
        sdcStateMachine.setPrefunded(true);
        stateMachine.start();
        stateMachine.sendEvent((Object)Events.INCEPT);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        sdcStateMachine.setSettlementSuccessful(false);
        stateMachine.sendEvent((Object)Events.CONTINUE);
        stateMachine.sendEvent((Object)Events.SETTLE);
        stateMachine.stop();
    }

    public StateMachine<States, Events> buildMachine() throws Exception {
        StateMachineBuilder.Builder builder = StateMachineBuilder.builder();
        builder.configureStates().withStates().initial((Object)States.INCEPTION).state((Object)States.ACTIVE).state((Object)States.SETTLEMENT, this.performSettlement()).state((Object)States.TERMINATED_BY_INSUFFICIENT_MARGIN).state((Object)States.TERMINATED_BY_MATURITY).state((Object)States.TERMINATED_BY_INSUFFICIENT_PREFUNDING).junction((Object)States.PREFUNDING_CHECK).junction((Object)States.SETTLEMENT_CHECK).junction((Object)States.MATURITY_CHECK);
        ((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)builder.configureTransitions().withExternal().source((Object)States.INCEPTION)).target((Object)States.ACTIVE).event((Object)Events.INCEPT)).and()).withExternal().source((Object)States.ACTIVE)).target((Object)States.SETTLEMENT).event((Object)Events.SETTLE)).and()).withExternal().source((Object)States.SETTLEMENT)).target((Object)States.SETTLEMENT_CHECK).event((Object)Events.CONTINUE)).and()).withJunction().source((Object)States.SETTLEMENT_CHECK).first((Object)States.MATURITY_CHECK, this.settlementCheck()).last((Object)States.TERMINATED_BY_INSUFFICIENT_MARGIN).and()).withJunction().source((Object)States.MATURITY_CHECK).first((Object)States.PREFUNDING_CHECK, this.notMaturedCheck()).last((Object)States.TERMINATED_BY_MATURITY).and()).withJunction().source((Object)States.PREFUNDING_CHECK).first((Object)States.ACTIVE, this.prefundingCheck()).last((Object)States.TERMINATED_BY_INSUFFICIENT_PREFUNDING);
        builder.configureConfiguration().withConfiguration().listener((org.springframework.statemachine.listener.StateMachineListener)new StateMachineListener());
        return builder.build();
    }

    public boolean isPrefunded() {
        return this.isPrefunded;
    }

    public SmartContractStateMachine setPrefunded(boolean isPrefunded) {
        this.isPrefunded = isPrefunded;
        return this;
    }

    public boolean isMatured() {
        return this.isMatured;
    }

    public SmartContractStateMachine setMatured(boolean isMatured) {
        this.isMatured = isMatured;
        return this;
    }

    public boolean isSettlementSuccessful() {
        return this.isSettlementSuccessful;
    }

    public SmartContractStateMachine setSettlementSuccessful(boolean isSettlementSuccessful) {
        this.isSettlementSuccessful = isSettlementSuccessful;
        return this;
    }

    public Guard<States, Events> settlementCheck() {
        return ctx -> this.isSettlementSuccessful;
    }

    public Guard<States, Events> prefundingCheck() {
        return ctx -> this.isPrefunded;
    }

    public Guard<States, Events> notMaturedCheck() {
        return ctx -> !this.isMatured;
    }

    public Action<States, Events> performSettlement() {
        return new Action<States, Events>(){

            public void execute(StateContext<States, Events> context) {
                System.out.println("Performing settlement.");
            }
        };
    }

    public static enum Events {
        INCEPT,
        SETTLE,
        CONTINUE,
        TERMINATE_BY_INSUFFICIENT_PREFUNDING,
        TERMINATE_BY_INSUFFICIENT_MARGIN,
        MATURE;

    }

    public static enum States {
        INCEPTION,
        ACTIVE,
        SETTLEMENT,
        TERMINATED_BY_INSUFFICIENT_PREFUNDING,
        TERMINATED_BY_INSUFFICIENT_MARGIN,
        TERMINATED_BY_MATURITY,
        PREFUNDING_CHECK,
        SETTLEMENT_CHECK,
        MATURITY_CHECK;

    }

    public class StateMachineListener
    extends StateMachineListenerAdapter<States, Events> {
        public void stateChanged(State<States, Events> from, State<States, Events> to) {
            System.out.printf("Transitioned from %s to %s%n", from == null ? "none" : from.getId(), to.getId());
        }
    }
}

