/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.implementation;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.modelling.descriptor.xmlparser.FPMLParser;
import net.finmath.modelling.productfactory.InterestRateAnalyticProductFactory;
import net.finmath.smartcontract.model.MarginResult;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.model.ValueResult;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParserDataItems;
import net.finmath.smartcontract.valuation.marketdata.data.MarketDataPoint;
import net.finmath.smartcontract.valuation.oracle.SmartDerivativeContractSettlementOracle;
import net.finmath.smartcontract.valuation.oracle.interestrates.ValuationOraclePlainSwap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarginCalculator {
    private static final Logger logger = LoggerFactory.getLogger(MarginCalculator.class);
    private final DoubleUnaryOperator rounding;

    public MarginCalculator(DoubleUnaryOperator rounding) {
        this.rounding = rounding;
    }

    public MarginCalculator() {
        this(x -> (double)Math.round(x * 1000.0) / 1000.0);
    }

    public MarginResult getValue(String marketDataStart, String marketDataEnd, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        CalibrationDataset setStart = CalibrationParserDataItems.getCalibrationDataSetFromXML(marketDataStart, productDescriptor.getMarketdataItemList());
        CalibrationDataset setEnd = CalibrationParserDataItems.getCalibrationDataSetFromXML(marketDataEnd, productDescriptor.getMarketdataItemList());
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, "forward-EUR-6M", "discount-EUR-OIS").getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime startDate = setStart.getDate();
        LocalDateTime endDate = setEnd.getDate();
        double value = this.calculateMargin(List.of(setStart, setEnd), startDate, endDate, productDescriptor, underlying);
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new MarginResult().value(BigDecimal.valueOf(this.rounding.applyAsDouble(value))).currency(currency).valuationDate(valuationDate.toString());
    }

    public MarginResult getValue(MarketDataList marketDataStart, MarketDataList marketDataEnd, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        List<CalibrationDataItem.Spec> marketdataItemList = productDescriptor.getMarketdataItemList();
        HashSet<CalibrationDataItem> calibrationDataItemsStart = new HashSet<CalibrationDataItem>();
        List<MarketDataPoint> marketDataValuesStart = marketDataStart.getPoints();
        marketdataItemList.forEach(marketDataItemSpec -> marketDataValuesStart.stream().filter(marketDataValue -> marketDataValue.getId().equals(marketDataItemSpec.getKey())).map(mdv -> new CalibrationDataItem((CalibrationDataItem.Spec)marketDataItemSpec, mdv.getValue(), mdv.getTimeStamp())).forEach(calibrationDataItemsStart::add));
        ArrayList<CalibrationDataset> marketDataListStart = new ArrayList<CalibrationDataset>();
        marketDataListStart.add(new CalibrationDataset(calibrationDataItemsStart, marketDataStart.getRequestTimeStamp()));
        HashSet<CalibrationDataItem> calibrationDataItemsEnd = new HashSet<CalibrationDataItem>();
        List<MarketDataPoint> marketDataValuesEnd = marketDataEnd.getPoints();
        marketdataItemList.forEach(marketDataItemSpec -> marketDataValuesEnd.stream().filter(marketDataValue -> marketDataValue.getId().equals(marketDataItemSpec.getKey())).map(mdv -> new CalibrationDataItem((CalibrationDataItem.Spec)marketDataItemSpec, mdv.getValue(), mdv.getTimeStamp())).forEach(calibrationDataItemsEnd::add));
        ArrayList<CalibrationDataset> marketDataListEnd = new ArrayList<CalibrationDataset>();
        marketDataListEnd.add(new CalibrationDataset(calibrationDataItemsEnd, marketDataEnd.getRequestTimeStamp()));
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, "forward-EUR-6M", "discount-EUR-OIS").getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime startDate = ((CalibrationDataset)marketDataListStart.get(0)).getDate();
        LocalDateTime endDate = ((CalibrationDataset)marketDataListEnd.get(0)).getDate();
        double value = this.calculateMargin(List.of((CalibrationDataset)marketDataListStart.get(0), (CalibrationDataset)marketDataListEnd.get(0)), startDate, endDate, productDescriptor, underlying);
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new MarginResult().value(BigDecimal.valueOf(this.rounding.applyAsDouble(value))).currency(currency).valuationDate(valuationDate.toString());
    }

    public ValueResult getValue(String marketData, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, "forward-EUR-6M", "discount-EUR-OIS").getProductDescriptor(productDescriptor.getUnderlying());
        CalibrationDataset set = CalibrationParserDataItems.getCalibrationDataSetFromXML(marketData, productDescriptor.getMarketdataItemList());
        double value = this.calculateMargin(List.of(set), null, set.getDate(), productDescriptor, underlying);
        String currency = "EUR";
        LocalDateTime valuationDate = LocalDateTime.now();
        return new ValueResult().value(BigDecimal.valueOf(value)).currency(currency).valuationDate(valuationDate.toString());
    }

    public ValueResult getValue(MarketDataList marketData, String productData) throws Exception {
        SmartDerivativeContractDescriptor productDescriptor = SDCXMLParser.parse(productData);
        HashSet<CalibrationDataItem> calibrationDataItems = new HashSet<CalibrationDataItem>();
        List<CalibrationDataItem.Spec> marketdataItemList = productDescriptor.getMarketdataItemList();
        List<MarketDataPoint> marketDataValues = marketData.getPoints();
        marketdataItemList.forEach(marketDataItemSpec -> marketDataValues.stream().filter(marketDataValue -> marketDataValue.getId().equals(marketDataItemSpec.getKey())).map(mdv -> new CalibrationDataItem((CalibrationDataItem.Spec)marketDataItemSpec, mdv.getValue(), mdv.getTimeStamp())).forEach(calibrationDataItems::add));
        ArrayList<CalibrationDataset> marketDataList = new ArrayList<CalibrationDataset>();
        marketDataList.add(new CalibrationDataset(calibrationDataItems, marketData.getRequestTimeStamp()));
        String ownerPartyID = productDescriptor.getUnderlyingReceiverPartyID();
        InterestRateSwapProductDescriptor underlying = (InterestRateSwapProductDescriptor)new FPMLParser(ownerPartyID, "forward-EUR-6M", "discount-EUR-OIS").getProductDescriptor(productDescriptor.getUnderlying());
        LocalDateTime endDate = ((CalibrationDataset)marketDataList.get(0)).getDate();
        double value = this.calculateMargin(marketDataList, null, endDate, productDescriptor, underlying);
        String currency = "EUR";
        return new ValueResult().value(BigDecimal.valueOf(value)).currency(currency).valuationDate(marketData.getRequestTimeStamp().toString());
    }

    private double calculateMargin(List<CalibrationDataset> marketDataList, LocalDateTime startDate, LocalDateTime endState, SmartDerivativeContractDescriptor productDescriptor, InterestRateSwapProductDescriptor underlying) throws Exception {
        LocalDate referenceDate = productDescriptor.getTradeDate().toLocalDate();
        InterestRateSwapLegProductDescriptor legReceiver = (InterestRateSwapLegProductDescriptor)underlying.getLegReceiver();
        InterestRateSwapLegProductDescriptor legPayer = (InterestRateSwapLegProductDescriptor)underlying.getLegPayer();
        InterestRateAnalyticProductFactory productFactory = new InterestRateAnalyticProductFactory(referenceDate);
        DescribedProduct legReceiverProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legReceiver);
        DescribedProduct legPayerProduct = productFactory.getProductFromDescriptor((ProductDescriptor)legPayer);
        Swap swap = new Swap((AnalyticProduct)((SwapLeg)legReceiverProduct), (AnalyticProduct)((SwapLeg)legPayerProduct));
        ValuationOraclePlainSwap oracle = new ValuationOraclePlainSwap(swap, 1.0, marketDataList);
        SmartDerivativeContractSettlementOracle margin = new SmartDerivativeContractSettlementOracle(oracle);
        double marginCall = 0.0;
        marginCall = Objects.isNull(startDate) ? oracle.getValue(endState, endState).doubleValue() : margin.getMargin(startDate, endState).doubleValue();
        return marginCall;
    }
}

