/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.curvecalibration;

import java.time.LocalDate;
import net.finmath.marketdata.calibration.CalibratedCurves;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationContext;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;

public class CalibrationSpecProviderSwap
implements CalibrationSpecProvider {
    private final String tenorLabel;
    private final String frequencyLabel;
    private final String maturityLabel;
    private final double swapRate;

    public CalibrationSpecProviderSwap(String tenorLabel, String frequencyLabel, String maturityLabel, double swapRate) {
        this.tenorLabel = tenorLabel;
        this.frequencyLabel = frequencyLabel;
        this.maturityLabel = maturityLabel;
        this.swapRate = swapRate;
    }

    @Override
    public CalibratedCurves.CalibrationSpec getCalibrationSpec(CalibrationContext ctx) {
        Schedule scheduleInterfaceRec = ScheduleGenerator.createScheduleFromConventions((LocalDate)ctx.getReferenceDate(), (int)2, (String)"0D", (String)this.maturityLabel, (String)this.frequencyLabel, (String)"ACT/360", (String)"first", (String)"modfollow", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)-2, (int)0);
        Schedule scheduleInterfacePay = ScheduleGenerator.createScheduleFromConventions((LocalDate)ctx.getReferenceDate(), (int)2, (String)"0D", (String)this.maturityLabel, (String)"annual", (String)"E30/360", (String)"first", (String)"modfollow", (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(), (int)-2, (int)0);
        double calibrationTime = scheduleInterfaceRec.getFixing(scheduleInterfaceRec.getNumberOfPeriods() - 1);
        String curveName = String.format("forward-EUR-%1$s", this.tenorLabel);
        return new CalibratedCurves.CalibrationSpec("EUR-" + this.tenorLabel + this.maturityLabel, "Swap", scheduleInterfaceRec, curveName, 0.0, "discount-EUR-OIS", scheduleInterfacePay, "", this.swapRate, "discount-EUR-OIS", curveName, calibrationTime);
    }
}

