/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.generators;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParserDataItems;
import net.finmath.smartcontract.valuation.marketdata.generators.MarketDataGeneratorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketDataGeneratorRandomFeed
implements MarketDataGeneratorInterface<MarketDataList> {
    LocalDateTime endTime;
    CalibrationDataset referenceSet;
    private static final Logger logger = LoggerFactory.getLogger(MarketDataGeneratorRandomFeed.class);
    int simulationFrequencySec;

    public MarketDataGeneratorRandomFeed(Period processingPeriod, String referenceMarketDataStr, List<CalibrationDataItem.Spec> mdSpecs) throws Exception {
        this.endTime = LocalDateTime.now().plus(processingPeriod);
        this.referenceSet = CalibrationParserDataItems.getCalibrationDataSetFromXML(referenceMarketDataStr, mdSpecs);
        this.simulationFrequencySec = 3;
    }

    @Override
    public Observable<MarketDataList> asObservable() {
        ObservableOnSubscribe observable = emitter -> {
            while (LocalDateTime.now().isBefore(this.endTime)) {
                CalibrationDataset shiftedScenario = this.getShiftedReferenceSet();
                emitter.onNext((Object)shiftedScenario.toMarketDataList());
            }
            emitter.onComplete();
        };
        return Observable.create((ObservableOnSubscribe)observable).delay((long)this.simulationFrequencySec, TimeUnit.SECONDS);
    }

    private CalibrationDataset getShiftedReferenceSet() {
        double randomShiftBp = ThreadLocalRandom.current().nextDouble(-1.0, 1.0) / 10000.0;
        Set<CalibrationDataItem> shifted = this.referenceSet.getDataPoints().stream().map(datapoint -> datapoint.getClonedShifted(1.0 + randomShiftBp)).collect(Collectors.toSet());
        CalibrationDataset set = new CalibrationDataset(shifted, this.referenceSet.getDate());
        return set;
    }
}

