/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.generators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.finmath.smartcontract.model.MarketDataList;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.data.MarketDataPoint;
import net.finmath.smartcontract.valuation.marketdata.generators.MarketDataGeneratorInterface;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class MarketDataGeneratorWebsocket
extends WebSocketAdapter
implements MarketDataGeneratorInterface<MarketDataList> {
    private final BusinessdayCalendarExcludingTARGETHolidays bdCalendar = new BusinessdayCalendarExcludingTARGETHolidays();
    private final JSONObject authJson;
    private static final Logger logger = LoggerFactory.getLogger(MarketDataGeneratorWebsocket.class);
    private final String position;
    private final Set<CalibrationDataItem.Spec> calibrationSpecs;
    private MarketDataList marketDataList;
    private final PublishSubject<MarketDataList> publishSubject;
    private final Sinks.Many<MarketDataList> sink;
    boolean requestSent;

    public MarketDataGeneratorWebsocket(JSONObject authJson, String position, List<CalibrationDataItem.Spec> itemList) {
        this.authJson = authJson;
        this.position = position;
        this.calibrationSpecs = new LinkedHashSet<CalibrationDataItem.Spec>(itemList);
        this.marketDataList = new MarketDataList();
        this.requestSent = false;
        this.publishSubject = PublishSubject.create();
        this.sink = Sinks.many().multicast().onBackpressureBuffer();
    }

    private CalibrationDataItem.Spec getSpec(String key) {
        return this.calibrationSpecs.stream().filter(spec -> spec.getKey().equals(key)).findAny().orElse(null);
    }

    public boolean allQuotesRetrieved() {
        return this.marketDataList.getSize() >= this.calibrationSpecs.size();
    }

    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
        System.out.println("WebSocket successfully connected!");
        this.sendLoginRequest(websocket, this.authJson.getString("access_token"), true);
    }

    @Override
    public Observable<MarketDataList> asObservable() {
        return this.publishSubject;
    }

    public Flux<MarketDataList> asFlux() {
        return this.sink.asFlux();
    }

    public void closeStreamsAndLogoff(WebSocket webSocket) {
        String request = "{\"ID\":1, \"Type\": \"Close\", \"Domain\":\"Login\"}";
        webSocket.sendText(request);
    }

    public void writeDataset(String importDir, MarketDataList s, boolean isOvernightFixing) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    public void onTextMessage(WebSocket websocket, String message) throws Exception {
        JsonNode responseJson = null;
        if (!message.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            responseJson = mapper.readTree(message);
            if (!this.requestSent) {
                this.sendRICRequest(websocket);
                this.requestSent = true;
            }
            try {
                for (int i = 0; i < responseJson.size(); ++i) {
                    Double ASK;
                    if (!responseJson.get(i).has("Fields")) continue;
                    if (this.marketDataList.getSize() == 0) {
                        this.marketDataList.setRequestTimeStamp(LocalDateTime.now());
                    }
                    String ric = responseJson.get(i).get("Key").get("Name").asText();
                    JsonNode fields = responseJson.get(i).get("Fields");
                    Double BID = fields.has("BID") ? Double.valueOf(fields.get("BID").doubleValue()) : null;
                    Double d = ASK = fields.has("ASK") ? Double.valueOf(fields.get("ASK").doubleValue()) : null;
                    double midQuote = ASK == null ? BID : (BID == null ? ASK : (BID + ASK) / 2.0);
                    Double quoteScaled = BigDecimal.valueOf(midQuote).setScale(3, RoundingMode.HALF_EVEN).divide(BigDecimal.valueOf(100.0)).doubleValue();
                    String date = fields.get("VALUE_DT1").textValue();
                    String time = fields.get("VALUE_TS1").textValue();
                    LocalDateTime localDateTime = LocalDateTime.parse(date + "T" + time, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    LocalDateTime adjustedTime = this.adjustTimestampForOvernightFixing(localDateTime, ric);
                    CalibrationDataItem.Spec spec = this.getSpec(ric);
                    MarketDataPoint dataPoint = new MarketDataPoint(spec.getKey(), quoteScaled, adjustedTime);
                    this.marketDataList.add(dataPoint);
                }
            }
            catch (Exception e) {
                System.out.println("Fetching Quote Error:" + String.valueOf(e));
            }
        }
        if (this.allQuotesRetrieved()) {
            this.publishSubject.onNext((Object)this.marketDataList);
            this.sink.tryEmitNext((Object)this.marketDataList);
            this.reset();
            this.requestSent = false;
        }
    }

    private void reset() {
        this.marketDataList = new MarketDataList();
    }

    private LocalDateTime adjustTimestampForOvernightFixing(LocalDateTime localDateTimeUnadjusted, String symbol) {
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        ZoneId gmt = TimeZone.getTimeZone("GMT").toZoneId();
        LocalDateTime adjustedTime = localDateTimeUnadjusted.atZone(gmt).withZoneSameInstant(zoneId).toLocalDateTime();
        if (this.getSpec(symbol).getProductName().equals("Fixing") && symbol.equals("EUROSTR=")) {
            adjustedTime = this.bdCalendar.getRolledDate(adjustedTime.toLocalDate(), 1).atTime(adjustedTime.toLocalTime());
        }
        return adjustedTime;
    }

    public void sendRICRequest(WebSocket websocket) throws Exception {
        String keyString1 = this.ricsToString();
        String requestJsonString = "{\"ID\":2," + keyString1 + ",\"View\":[\"MID\",\"BID\",\"ASK\",\"VALUE_DT1\",\"VALUE_TS1\"]}";
        websocket.sendText(requestJsonString);
    }

    public void sendLoginRequest(WebSocket websocket, String authToken, boolean isFirstLogin) throws Exception {
        String loginJsonString = "{\"ID\":1,\"Domain\":\"Login\",\"Key\":{\"Elements\":{\"ApplicationId\":\"\",\"Position\":\"\",\"AuthenticationToken\":\"\"},\"NameType\":\"AuthnToken\"}}";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode loginJson = (ObjectNode)mapper.readTree(loginJsonString);
        ((ObjectNode)loginJson.get("Key").get("Elements")).put("AuthenticationToken", authToken);
        ((ObjectNode)loginJson.get("Key").get("Elements")).put("ApplicationId", "256");
        ((ObjectNode)loginJson.get("Key").get("Elements")).put("Position", this.position);
        if (!isFirstLogin) {
            loginJson.put("Refresh", false);
        }
        websocket.sendText(loginJson.toString());
    }

    private String ricsToString() {
        Object ricsAsString = "\"Key\":{\"Name\":[";
        for (CalibrationDataItem.Spec item : this.calibrationSpecs) {
            ricsAsString = (String)ricsAsString + "\"" + item.getKey() + "\",";
        }
        ricsAsString = ((String)ricsAsString).substring(0, ((String)ricsAsString).length() - 1);
        ricsAsString = (String)ricsAsString + "]}";
        return ricsAsString;
    }
}

