/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.marketdata.generators;

import com.neovisionaries.ws.client.ProxySettings;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import java.io.IOException;
import java.net.Inet4Address;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.SSLParameters;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class WebSocketConnector {
    Properties connectionProperties;
    public JSONObject authJson;
    public String position;
    public String scope = "";
    public String server = "";
    public static WebSocket ws = null;

    public WebSocketConnector(Properties connectionProperties) throws Exception {
        this.connectionProperties = connectionProperties;
        this.position = Inet4Address.getLocalHost().getHostAddress();
    }

    public WebSocket getWebSocket() throws Exception {
        if (ws == null) {
            return this.initAuthJson().initWebSocketConnection();
        }
        return ws;
    }

    public JSONObject getAuthJson() {
        return this.authJson;
    }

    public String getPosition() {
        return this.position;
    }

    public WebSocketConnector initAuthJson() {
        try {
            this.authJson = this.getAuthenticationInfo(null, this.connectionProperties.get("AUTHURL").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public WebSocket initWebSocketConnection() throws IOException, WebSocketException, NoSuchAlgorithmException {
        this.server = String.format("wss://%s:%s/WebSocket", this.connectionProperties.get("HOSTNAME"), this.connectionProperties.get("PORT"));
        System.out.println("Connecting to WebSocket " + this.server + " ...");
        WebSocketFactory factory = new WebSocketFactory();
        SSLParameters params = new SSLParameters();
        params.setProtocols(new String[]{"TLSv1.2"});
        ProxySettings settings = factory.getProxySettings();
        if (this.connectionProperties.get("USEPROXY").equals("TRUE")) {
            settings.setHost(this.connectionProperties.get("PROXYHOST").toString()).setPort(Integer.parseInt(this.connectionProperties.get("PROXYPORT").toString()));
            settings.setCredentials(this.connectionProperties.get("PROXYUSER").toString(), this.connectionProperties.get("PROXYPASS").toString());
        }
        WebSocket webSocket = factory.createSocket(this.server).addProtocol("tr_json2").addExtension("permessage-deflate");
        return webSocket;
    }

    public JSONObject getAuthenticationInfo(JSONObject previousAuthResponseJson, String url) {
        try {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(new SSLContextBuilder().build());
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost httppost = new HttpPost(url);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
            params.add(new BasicNameValuePair("client_id", this.connectionProperties.get("CLIENTID").toString()));
            params.add(new BasicNameValuePair("username", this.connectionProperties.get("USER").toString()));
            if (previousAuthResponseJson == null) {
                params.add(new BasicNameValuePair("grant_type", "password"));
                params.add(new BasicNameValuePair("password", this.connectionProperties.get("PASSWORD").toString()));
                params.add(new BasicNameValuePair("scope", this.scope));
                params.add(new BasicNameValuePair("takeExclusiveSignOnControl", "true"));
                System.out.println("Sending authentication request with password to " + url + "...");
            } else {
                params.add(new BasicNameValuePair("grant_type", "refresh_token"));
                params.add(new BasicNameValuePair("refresh_token", previousAuthResponseJson.getString("refresh_token")));
                System.out.println("Sending authentication request with refresh token to " + url + "...");
            }
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    JSONObject responseJson = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
                    return responseJson;
                }
                case 301: 
                case 302: 
                case 307: 
                case 308: {
                    String newHost;
                    Header header = response.getFirstHeader("Location");
                    if (header != null && (newHost = header.getValue()) != null) {
                        System.out.println("Perform URL redirect to " + newHost);
                        return this.getAuthenticationInfo(previousAuthResponseJson, newHost);
                    }
                    return null;
                }
                case 400: 
                case 401: {
                    System.out.println("Refinitiv Data Platform authentication HTTP code: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                    if (previousAuthResponseJson != null) {
                        System.out.println("Retry with username and password");
                        return this.getAuthenticationInfo(null, this.connectionProperties.get("AUTHURL").toString());
                    }
                    return null;
                }
                case 403: 
                case 404: 
                case 410: 
                case 451: {
                    System.out.println("Refinitiv Data Platform authentication HTTP code: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
                    System.out.println("Stop retrying with the request");
                    return null;
                }
            }
            System.out.println("Refinitiv Data Platform authentication HTTP code: " + response.getStatusLine().getStatusCode() + " " + response.getStatusLine().getReasonPhrase());
            Thread.sleep(5000L);
            System.out.println("Retry the request to Refinitiv Data Platform");
            return this.getAuthenticationInfo(previousAuthResponseJson, this.connectionProperties.get("AUTHURL").toString());
        }
        catch (Exception e) {
            System.out.println("Refinitiv Data Platform authentication failure:");
            e.printStackTrace();
            return null;
        }
    }
}

