/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.oracle;

import java.time.LocalDateTime;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import net.finmath.smartcontract.valuation.oracle.StochasticValuationOracle;
import net.finmath.smartcontract.valuation.oracle.ValuationOracle;
import org.javamoney.moneta.Money;

public class ValuationOracleSamplePath
implements ValuationOracle {
    private final CurrencyUnit currency = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    private final StochasticValuationOracle stochasticValuationOracle;
    private final int path;

    public ValuationOracleSamplePath(StochasticValuationOracle stochasticValuationOracle, int path) {
        this.stochasticValuationOracle = stochasticValuationOracle;
        this.path = path;
    }

    @Override
    public Double getValue(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return this.stochasticValuationOracle.getValue(evaluationTime, marketDataTime).get(this.path);
    }

    @Override
    public MonetaryAmount getAmount(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return Money.of((Number)this.getValue(evaluationTime, marketDataTime), (CurrencyUnit)this.currency);
    }
}

