/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.oracle.interestrates;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.products.Swap;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationContextImpl;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataset;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationParserDataItems;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationResult;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationSpecProvider;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.Calibrator;
import net.finmath.smartcontract.valuation.oracle.ValuationOracle;
import net.finmath.time.FloatingpointDate;
import org.javamoney.moneta.Money;

public class ValuationOraclePlainSwap
implements ValuationOracle {
    private final CurrencyUnit currency = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    private final List<CalibrationDataset> scenarioList;
    private final Swap product;
    private final double notionalAmount;
    private final DoubleUnaryOperator rounding;

    public ValuationOraclePlainSwap(Swap product, double notionalAmount, List<CalibrationDataset> scenarioList, DoubleUnaryOperator rounding) {
        this.notionalAmount = notionalAmount;
        this.product = product;
        this.scenarioList = scenarioList;
        this.rounding = rounding;
    }

    public ValuationOraclePlainSwap(Swap product, double notionalAmount, List<CalibrationDataset> scenarioList) {
        this(product, notionalAmount, scenarioList, x -> (double)Math.round(x * 100.0) / 100.0);
    }

    @Override
    public MonetaryAmount getAmount(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        return Money.of((Number)this.getValue(evaluationTime, marketDataTime), (CurrencyUnit)this.currency);
    }

    @Override
    public Double getValue(LocalDateTime evaluationDate, LocalDateTime marketDataTime) {
        Optional<CalibrationDataset> optionalScenario = this.scenarioList.stream().filter(scenario -> scenario.getDate().equals(marketDataTime)).findAny();
        if (optionalScenario.isPresent()) {
            CalibrationDataset scenario2 = optionalScenario.get();
            LocalDate referenceDate = marketDataTime.toLocalDate();
            CalibrationParserDataItems parser = new CalibrationParserDataItems();
            try {
                Stream<CalibrationSpecProvider> allCalibrationItems = scenario2.getDataAsCalibrationDataPointStream(parser);
                List<CalibrationDataItem> fixings = scenario2.getDataPoints().stream().filter(cdi -> cdi.getSpec().getProductName().equals("Fixing") || cdi.getSpec().getProductName().equals("Deposit")).toList();
                Calibrator calibrator = new Calibrator(fixings, new CalibrationContextImpl(referenceDate, 1.0E-9));
                Optional<CalibrationResult> optionalCalibrationResult = calibrator.calibrateModel(allCalibrationItems, new CalibrationContextImpl(referenceDate, 1.0E-9));
                AnalyticModel calibratedModel = optionalCalibrationResult.orElseThrow().getCalibratedModel();
                double evaluationTime = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)referenceDate.atStartOfDay(), (LocalDateTime)marketDataTime);
                double valueWithCurves = this.product.getValue(evaluationTime, calibratedModel) * this.notionalAmount;
                return this.rounding.applyAsDouble(valueWithCurves);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

