/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.oracle.simulated;

import java.time.LocalDateTime;
import net.finmath.smartcontract.valuation.oracle.StochasticValuationOracle;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class ContinouslyCompoundedBankAccountOracle
implements StochasticValuationOracle {
    private final TimeDiscretization timeDiscretization;
    private final LocalDateTime initialTime;
    private final double initialValue;
    private final double riskFreeRate;

    public ContinouslyCompoundedBankAccountOracle() {
        this(LocalDateTime.now());
    }

    public ContinouslyCompoundedBankAccountOracle(LocalDateTime initialTime) {
        this((TimeDiscretization)new TimeDiscretizationFromArray(0.0, 20.0, 0.0027397260273972603, TimeDiscretizationFromArray.ShortPeriodLocation.SHORT_PERIOD_AT_END), initialTime, 1.0, 0.02);
    }

    public ContinouslyCompoundedBankAccountOracle(LocalDateTime initialTime, double initialValue, double timeHorizon, double riskFreeRate) {
        this((TimeDiscretization)new TimeDiscretizationFromArray(0.0, timeHorizon, 0.0027397260273972603, TimeDiscretizationFromArray.ShortPeriodLocation.SHORT_PERIOD_AT_END), initialTime, initialValue, riskFreeRate);
    }

    public ContinouslyCompoundedBankAccountOracle(TimeDiscretization timeDiscretization, LocalDateTime initialTime, double initialValue, double riskFreeRate) {
        this.timeDiscretization = timeDiscretization;
        this.initialTime = initialTime;
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
    }

    @Override
    public RandomVariable getValue(LocalDateTime evaluationTime, LocalDateTime marketDataTime) {
        double time = FloatingpointDate.getFloatingPointDateFromDate((LocalDateTime)this.initialTime, (LocalDateTime)marketDataTime);
        return new Scalar(this.initialValue * Math.exp(this.riskFreeRate * time));
    }
}

