/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketListener;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.DoubleUnaryOperator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.ParserConfigurationException;
import net.finmath.rootfinder.BisectionSearch;
import net.finmath.smartcontract.api.PlainSwapEditorApi;
import net.finmath.smartcontract.model.CashflowPeriod;
import net.finmath.smartcontract.model.MarketDataSet;
import net.finmath.smartcontract.model.PlainSwapOperationRequest;
import net.finmath.smartcontract.model.SaveContractRequest;
import net.finmath.smartcontract.model.ValueResult;
import net.finmath.smartcontract.product.SmartDerivativeContractDescriptor;
import net.finmath.smartcontract.product.xml.PlainSwapEditorHandler;
import net.finmath.smartcontract.product.xml.SDCXMLParser;
import net.finmath.smartcontract.valuation.implementation.MarginCalculator;
import net.finmath.smartcontract.valuation.marketdata.curvecalibration.CalibrationDataItem;
import net.finmath.smartcontract.valuation.marketdata.database.DatabaseConnector;
import net.finmath.smartcontract.valuation.marketdata.generators.WebSocketConnector;
import net.finmath.smartcontract.valuation.marketdata.generators.legacy.LiveFeedAdapter;
import net.finmath.smartcontract.valuation.marketdata.generators.legacy.ReactiveMarketDataUpdater;
import net.finmath.smartcontract.valuation.service.utils.ResourceGovernor;
import net.finmath.util.TriFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.ErrorResponseException;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.xml.sax.SAXException;

@RestController
@CrossOrigin(origins={"http://localhost:4200", "${serviceUrl}"}, allowCredentials="true")
public class PlainSwapEditorController
implements PlainSwapEditorApi {
    private static final Logger logger = LoggerFactory.getLogger(PlainSwapEditorController.class);
    private static final TriFunction<DoubleUnaryOperator, Double, Double, Double> getRoot = (valueOperator, xMin, xMax) -> {
        BisectionSearch rootFinder = new BisectionSearch(xMin.doubleValue(), xMax.doubleValue());
        while (rootFinder.getAccuracy() > 1.0E-7 && !rootFinder.isDone()) {
            double x = rootFinder.getNextPoint();
            double y = valueOperator.applyAsDouble(x);
            rootFinder.setValue(y);
        }
        return rootFinder.getBestPoint();
    };
    private final String schemaPath = "schemas/sdc-schemas/sdcml-contract.xsd";
    @Autowired
    private DatabaseConnector databaseConnector;
    @Autowired
    private ResourceGovernor resourceGovernor;
    @Value(value="${hostname:localhost:8080}")
    private String hostname;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public ResponseEntity<String> generatePlainSwapSdcml(PlainSwapOperationRequest plainSwapOperationRequest) {
        try {
            return ResponseEntity.ok((Object)new PlainSwapEditorHandler(plainSwapOperationRequest, plainSwapOperationRequest.getCurrentGenerator(), "schemas/sdc-schemas/sdcml-contract.xsd").getContractAsXmlString());
        }
        catch (JAXBException | IOException | DatatypeConfigurationException | SAXException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"JAXB Error");
            pd.setType(URI.create(this.hostname + "/jaxb-error"));
            pd.setTitle("JAXB Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, e);
        }
    }

    @Override
    public ResponseEntity<ValueResult> evaluateFromPlainSwapEditor(PlainSwapOperationRequest plainSwapOperationRequest) {
        ValueResult valueResult;
        String marketDataString;
        String sdcmlBody;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try {
            sdcmlBody = new PlainSwapEditorHandler(plainSwapOperationRequest, plainSwapOperationRequest.getCurrentGenerator(), "schemas/sdc-schemas/sdcml-contract.xsd").getContractAsXmlString();
        }
        catch (JAXBException | IOException | DatatypeConfigurationException | SAXException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"JAXB Error");
            pd.setType(URI.create(this.hostname + "/jaxb-error"));
            pd.setTitle("JAXB Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, e);
        }
        try {
            marketDataString = new String(Objects.requireNonNull(PlainSwapEditorController.class.getClassLoader().getResourceAsStream("net/finmath/smartcontract/valuation/client/md_testset_rics.xml")).readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Market Data Error");
            pd.setType(URI.create(this.hostname + "/market-data-error"));
            pd.setTitle("Market Data Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        try {
            valueResult = new MarginCalculator().getValue(marketDataString, sdcmlBody);
        }
        catch (Exception e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Valuation error.");
            pd.setType(URI.create(this.hostname + "/valuation-error"));
            pd.setTitle("Valuation Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        return ResponseEntity.ok((Object)valueResult);
    }

    @Override
    public ResponseEntity<List<CashflowPeriod>> getFixedSchedule(PlainSwapOperationRequest plainSwapOperationRequest) {
        MarketDataSet marketData;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try {
            String marketDataString = this.resourceGovernor.getActiveDatasetAsResourceInReadMode(currentUserName).getContentAsString(StandardCharsets.UTF_8);
            marketData = (MarketDataSet)this.objectMapper.readValue(marketDataString, MarketDataSet.class);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Market Data Error");
            pd.setType(URI.create(this.hostname + "/market-data-error"));
            pd.setTitle("Market Data Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        try {
            return ResponseEntity.ok(new PlainSwapEditorHandler(plainSwapOperationRequest, plainSwapOperationRequest.getCurrentGenerator(), "schemas/sdc-schemas/sdcml-contract.xsd").getSchedule(PlainSwapEditorHandler.LegSelector.FIXED_LEG, marketData));
        }
        catch (JAXBException | IOException | DatatypeConfigurationException | SAXException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"JAXB Error");
            pd.setType(URI.create(this.hostname + "/jaxb-error"));
            pd.setTitle("JAXB Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, e);
        }
        catch (CloneNotSupportedException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Valuation Error");
            pd.setType(URI.create(this.hostname + "/valuation-error"));
            pd.setTitle("Valuation Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
    }

    @Override
    public ResponseEntity<List<CashflowPeriod>> getFloatingSchedule(PlainSwapOperationRequest plainSwapOperationRequest) {
        MarketDataSet marketData;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try {
            String marketDataString = this.resourceGovernor.getActiveDatasetAsResourceInReadMode(currentUserName).getContentAsString(StandardCharsets.UTF_8);
            marketData = (MarketDataSet)this.objectMapper.readValue(marketDataString, MarketDataSet.class);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Market Data Error");
            pd.setType(URI.create(this.hostname + "/market-data-error"));
            pd.setTitle("Market Data Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        try {
            return ResponseEntity.ok(new PlainSwapEditorHandler(plainSwapOperationRequest, plainSwapOperationRequest.getCurrentGenerator(), "schemas/sdc-schemas/sdcml-contract.xsd").getSchedule(PlainSwapEditorHandler.LegSelector.FLOATING_LEG, marketData));
        }
        catch (JAXBException | IOException | DatatypeConfigurationException | SAXException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"JAXB Error");
            pd.setType(URI.create(this.hostname + "/jaxb-error"));
            pd.setTitle("JAXB Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, e);
        }
        catch (CloneNotSupportedException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Valuation Error");
            pd.setType(URI.create(this.hostname + "/valuation-error"));
            pd.setTitle("Valuation Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
    }

    @Override
    public ResponseEntity<MarketDataSet> grabMarketData() {
        MarketDataSet marketData;
        String marketDataString;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try {
            marketDataString = this.resourceGovernor.getActiveDatasetAsResourceInReadMode(currentUserName).getContentAsString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        try {
            marketData = (MarketDataSet)this.objectMapper.readValue(marketDataString, MarketDataSet.class);
        }
        catch (JsonProcessingException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        return ResponseEntity.ok((Object)marketData);
    }

    @Override
    public ResponseEntity<ValueResult> refreshMarketData(PlainSwapOperationRequest plainSwapOperationRequest) {
        WebSocket webSocket;
        WebSocketConnector socketConnector;
        SmartDerivativeContractDescriptor sdc;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try {
            sdc = SDCXMLParser.parse(new PlainSwapEditorHandler(plainSwapOperationRequest, plainSwapOperationRequest.getCurrentGenerator(), "schemas/sdc-schemas/sdcml-contract.xsd").getContractAsXmlString());
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        catch (JAXBException | DatatypeConfigurationException | ParserConfigurationException | SAXException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"JAXB Error");
            pd.setType(URI.create(this.hostname + "/jaxb-error"));
            pd.setTitle("JAXB Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, e);
        }
        List<CalibrationDataItem.Spec> calibrationDataItemSpecs = sdc.getMarketdataItemList();
        Properties refinitivConnectionProperties = new Properties();
        try {
            refinitivConnectionProperties.load(new StringReader(this.resourceGovernor.getRefinitivPropertiesAsResourceInReadMode().getContentAsString(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        try {
            socketConnector = new WebSocketConnector(refinitivConnectionProperties);
            webSocket = socketConnector.getWebSocket();
        }
        catch (Exception e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Websocket Error");
            pd.setType(URI.create(this.hostname + "/websocket-error"));
            pd.setTitle("Websocket Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        ReactiveMarketDataUpdater emitter = new ReactiveMarketDataUpdater(socketConnector.getAuthJson(), socketConnector.getPosition(), calibrationDataItemSpecs);
        webSocket.addListener((WebSocketListener)emitter);
        try {
            webSocket.connect();
        }
        catch (WebSocketException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Websocket Error");
            pd.setType(URI.create(this.hostname + "/websocket-error"));
            pd.setTitle("Websocket Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        boolean isOvernightFixing = calibrationDataItemSpecs.stream().anyMatch(x -> x.getProductName().equals("Fixing") && x.getKey().equals("EUROSTR="));
        try {
            ((LiveFeedAdapter)emitter).writeDataset(this.resourceGovernor.getImportCandidateAsResourceInReadMode().getFile().getAbsolutePath(), (MarketDataSet)((LiveFeedAdapter)emitter).asObservable().blockingFirst(), isOvernightFixing);
        }
        catch (Exception e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Websocket Error");
            pd.setType(URI.create(this.hostname + "/websocket-error"));
            pd.setTitle("Websocket Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        try {
            this.databaseConnector.updateDatabase();
            ArrayList<String> fixingSymbols = new ArrayList<String>();
            for (CalibrationDataItem.Spec calibrationDataItemSpec : calibrationDataItemSpecs) {
                if (!calibrationDataItemSpec.getProductName().equals("Fixing")) continue;
                fixingSymbols.add(calibrationDataItemSpec.getKey());
            }
            this.databaseConnector.fetchFromDatabase(fixingSymbols, currentUserName);
            logger.info("Refresh complete.");
            ((LiveFeedAdapter)emitter).closeStreamsAndLogoff(webSocket);
        }
        catch (SQLException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Database Error");
            pd.setType(URI.create(this.hostname + "/database-error"));
            pd.setTitle("Database Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        webSocket.sendClose();
        webSocket.disconnect();
        return this.evaluateFromPlainSwapEditor(plainSwapOperationRequest);
    }

    @Override
    public ResponseEntity<Double> getParRate(PlainSwapOperationRequest plainSwapOperationRequest) {
        String marketDataString;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try {
            marketDataString = this.resourceGovernor.getActiveDatasetAsResourceInReadMode(currentUserName).getContentAsString(StandardCharsets.UTF_8);
            MarketDataSet marketData = (MarketDataSet)this.objectMapper.readValue(marketDataString, MarketDataSet.class);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Market Data Error");
            pd.setType(URI.create(this.hostname + "/market-data-error"));
            pd.setTitle("Market Data Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        try {
            DoubleUnaryOperator swapValue = swapRate -> {
                plainSwapOperationRequest.fixedRate(swapRate);
                try {
                    return new MarginCalculator().getValue(marketDataString, new PlainSwapEditorHandler(plainSwapOperationRequest.notionalAmount(1.0E15), plainSwapOperationRequest.getCurrentGenerator(), "schemas/sdc-schemas/sdcml-contract.xsd").getContractAsXmlString()).getValue().doubleValue();
                }
                catch (Exception e) {
                    ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Valuation Error");
                    pd.setType(URI.create(this.hostname + "/valuation-error"));
                    pd.setTitle("Valuation Error");
                    throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
                }
            };
            return ResponseEntity.ok((Object)((Double)getRoot.apply((Object)swapValue, (Object)-100.0, (Object)100.0)));
        }
        catch (Exception e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Valuation error.");
            pd.setType(URI.create(this.hostname + "/valuation-error"));
            pd.setTitle("Valuation Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
    }

    @Override
    public ResponseEntity<List<String>> getSavedContracts() {
        Resource[] savedContracts;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        ArrayList<String> savedContractsFilenames = new ArrayList<String>();
        try {
            savedContracts = this.resourceGovernor.listContentsOfUserFolder(currentUserName, ResourceGovernor.RoleFolders.SAVED_CONTRACTS_FOLDER);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        for (Resource savedContract : savedContracts) {
            savedContractsFilenames.add(savedContract.getFilename());
        }
        return ResponseEntity.ok(savedContractsFilenames);
    }

    @Override
    public ResponseEntity<String> changeDataset(String fileName) {
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        if (fileName.equals("USELIVE")) {
            return ResponseEntity.ok((Object)"idle ok");
        }
        try {
            File sourceFile = this.resourceGovernor.getReadableResource(currentUserName, ResourceGovernor.RoleFolders.MARKET_DATA_FOLDER, fileName).getFile();
            File destinationFile = this.resourceGovernor.getActiveDatasetAsResourceInWriteMode(currentUserName).getFile();
            Files.copy(sourceFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        return ResponseEntity.ok((Object)"ok");
    }

    @Override
    public ResponseEntity<List<String>> getSavedMarketData() {
        Resource[] savedContracts;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        ArrayList<String> savedContractsFilenames = new ArrayList<String>();
        try {
            savedContracts = this.resourceGovernor.listContentsOfUserFolder(currentUserName, ResourceGovernor.RoleFolders.MARKET_DATA_FOLDER);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        for (Resource savedContract : savedContracts) {
            savedContractsFilenames.add(savedContract.getFilename());
        }
        return ResponseEntity.ok(savedContractsFilenames);
    }

    @Override
    public ResponseEntity<PlainSwapOperationRequest> loadContract(String requestedFilename) {
        Resource[] savedContracts;
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try {
            savedContracts = this.resourceGovernor.listContentsOfUserFolder(currentUserName, ResourceGovernor.RoleFolders.SAVED_CONTRACTS_FOLDER);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        Optional<Resource> requestedContractOptional = Arrays.stream(savedContracts).filter(contract -> Objects.requireNonNull(contract.getFilename()).contentEquals(requestedFilename)).findFirst();
        Resource requestedContract = null;
        if (requestedContractOptional.isPresent()) {
            requestedContract = requestedContractOptional.get();
        }
        try {
            PlainSwapOperationRequest requestedRequest = (PlainSwapOperationRequest)this.objectMapper.readValue(Objects.requireNonNull(requestedContract).getContentAsString(StandardCharsets.UTF_8), PlainSwapOperationRequest.class);
            return ResponseEntity.ok((Object)requestedRequest);
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
    }

    @Override
    public ResponseEntity<String> saveContract(SaveContractRequest saveContractRequest) {
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        String regex = "^[A-za-z0-9]{1,255}$";
        LocalDate date = LocalDate.now();
        if (saveContractRequest.getName().matches(regex)) {
            try {
                File targetFile = this.resourceGovernor.getWritableResource(currentUserName, ResourceGovernor.RoleFolders.SAVED_CONTRACTS_FOLDER, String.valueOf(date) + saveContractRequest.getName() + ".json").getFile();
                boolean creationResult = targetFile.createNewFile();
                if (creationResult) {
                    logger.info("New file created at " + targetFile.getAbsolutePath());
                } else {
                    logger.info("Attempting overwrite of file " + targetFile.getAbsolutePath());
                }
                this.objectMapper.writeValue(targetFile, (Object)saveContractRequest.getPlainSwapOperationRequest());
            }
            catch (IOException e) {
                ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
                pd.setType(URI.create(this.hostname + "/storage-error"));
                pd.setTitle("Storage Error");
                throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
            }
            return ResponseEntity.ok((Object)(String.valueOf(date) + saveContractRequest.getName() + ".json"));
        }
        return ResponseEntity.ok((Object)"Request not fulfilled.");
    }

    @Override
    public ResponseEntity<String> uploadMarketData(MultipartFile marketData) {
        String currentUserName = ((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername();
        try (OutputStream importOutputStream = this.resourceGovernor.getImportCandidateAsResourceInWriteMode().getOutputStream();
             OutputStream userOutputStream = this.resourceGovernor.getWritableResource(currentUserName, ResourceGovernor.RoleFolders.MARKET_DATA_FOLDER, marketData.getOriginalFilename()).getOutputStream();){
            importOutputStream.write(marketData.getBytes());
            userOutputStream.write(marketData.getBytes());
            this.databaseConnector.updateDatabase();
        }
        catch (IOException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Storage Error");
            pd.setType(URI.create(this.hostname + "/storage-error"));
            pd.setTitle("Storage Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        catch (SQLException e) {
            ProblemDetail pd = ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (String)"Database Error");
            pd.setType(URI.create(this.hostname + "/database-error"));
            pd.setTitle("Database Error");
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, pd, (Throwable)e);
        }
        return ResponseEntity.ok((Object)"ok");
    }

    private static final class ErrorDetails {
        static final String JAXB_ERROR_DETAIL = "JAXB Error";
        static final String VALUATION_ERROR_DETAIL = "Valuation Error";
        static final String MARKET_DATA_ERROR_DETAIL = "Market Data Error";
        static final String DATABASE_ERROR_DETAIL = "Database Error";
        static final String WEBSOCKET_ERROR_DETAIL = "Websocket Error";
        static final String STORAGE_ERROR_DETAIL = "Storage Error";

        private ErrorDetails() {
        }
    }

    private static final class ErrorTypeURI {
        static final String JAXB_ERROR_URI = "/jaxb-error";
        static final String VALUATION_ERROR_URI = "/valuation-error";
        static final String MARKET_DATA_ERROR_URI = "/market-data-error";
        static final String DATABASE_ERROR_URI = "/database-error";
        static final String WEBSOCKET_ERROR_URI = "/websocket-error";
        static final String STORAGE_ERROR_URI = "/storage-error";

        private ErrorTypeURI() {
        }
    }
}

