/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.controllers;

import java.nio.charset.StandardCharsets;
import net.finmath.smartcontract.api.ValuationApi;
import net.finmath.smartcontract.model.MarginRequest;
import net.finmath.smartcontract.model.MarginResult;
import net.finmath.smartcontract.model.ValueRequest;
import net.finmath.smartcontract.model.ValueResult;
import net.finmath.smartcontract.valuation.client.ValuationClient;
import net.finmath.smartcontract.valuation.implementation.MarginCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.xml.sax.SAXException;

@RestController
public class ValuationController
implements ValuationApi {
    private final Logger logger = LoggerFactory.getLogger(ValuationController.class);
    private final String FAILEDCALCULATION = "Failed to calculate value.";

    @Override
    public ResponseEntity<MarginResult> margin(MarginRequest marginRequest) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Responded", "margin");
        MarginResult margin = null;
        try {
            MarginCalculator marginCalculator = new MarginCalculator();
            margin = marginCalculator.getValue(marginRequest.getMarketDataStart(), marginRequest.getMarketDataEnd(), marginRequest.getTradeData());
            this.logger.info(margin.toString());
            return ResponseEntity.ok((Object)margin);
        }
        catch (SAXException e) {
            this.logger.error("invalid trade data xml");
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.logger.error("Failed to calculate margin.", (Throwable)e);
            this.logger.debug(marginRequest.toString());
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResponseEntity<ValueResult> value(ValueRequest valueRequest) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Responded", "value");
        ValueResult value = null;
        try {
            MarginCalculator marginCalculator = new MarginCalculator();
            value = marginCalculator.getValue(valueRequest.getMarketData(), valueRequest.getTradeData());
            this.logger.info(value.toString());
            return ResponseEntity.ok((Object)value);
        }
        catch (Exception e) {
            this.logger.error("Failed to calculate value.");
            this.logger.info(value.toString());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResponseEntity<ValueResult> testProductValue(MultipartFile tradeData) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Responded", "value");
        ValueResult value = null;
        try {
            MarginCalculator marginCalculator = new MarginCalculator();
            String marketData = new String(ValuationClient.class.getClassLoader().getResourceAsStream("net/finmath/smartcontract/valuation/client/md_testset1.xml").readAllBytes(), StandardCharsets.UTF_8);
            value = marginCalculator.getValue(marketData, new String(tradeData.getInputStream().readAllBytes(), StandardCharsets.UTF_8));
            this.logger.info(value.toString());
            return ResponseEntity.ok((Object)value);
        }
        catch (Exception e) {
            this.logger.error("Failed to calculate value.");
            this.logger.info(value.toString());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public ResponseEntity<String> test() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON);
        responseHeaders.add("Responded", "test");
        String totalResult = "Connect successful";
        return new ResponseEntity((Object)totalResult, (MultiValueMap)responseHeaders, (HttpStatusCode)HttpStatus.OK);
    }
}

