/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.utils;

import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!test"})
public class ResourceGovernor {
    private static final Logger logger = LoggerFactory.getLogger(ResourceGovernor.class);
    @Autowired
    private ResourcePatternResolver resourcePatternResolver;
    @Value(value="${storage.basedir}")
    private String storageBaseDir;
    @Value(value="${storage.importdir}")
    private String importDir;
    @Value(value="${storage.internals.marketDataProviderConnectionPropertiesFile}")
    private String refinitivConnectionPropertiesFile;
    @Value(value="${storage.internals.databaseConnectionPropertiesFile}")
    private String databaseConnectionPropertiesFile;

    public Resource getActiveDatasetAsResourceInReadMode(String username) {
        return this.resourcePatternResolver.getResource("file:///" + Objects.requireNonNull(this.storageBaseDir) + RoleFolders.MARKET_DATA_FOLDER.toString().formatted(username) + "active_dataset.json");
    }

    public WritableResource getActiveDatasetAsResourceInWriteMode(String username) {
        return (WritableResource)this.resourcePatternResolver.getResource("file:///" + Objects.requireNonNull(this.storageBaseDir) + RoleFolders.MARKET_DATA_FOLDER.toString().formatted(username) + "active_dataset.json");
    }

    public Resource getImportCandidateAsResourceInReadMode() {
        return this.resourcePatternResolver.getResource("file:///" + Objects.requireNonNull(this.importDir) + "/import_candidate.json");
    }

    public WritableResource getImportCandidateAsResourceInWriteMode() {
        return (WritableResource)this.resourcePatternResolver.getResource("file:///" + Objects.requireNonNull(this.importDir) + "/import_candidate.json");
    }

    public Resource getRefinitivPropertiesAsResourceInReadMode() {
        return this.resourcePatternResolver.getResource("file:///" + this.refinitivConnectionPropertiesFile);
    }

    public Resource getDatabasePropertiesAsResourceInReadMode() {
        return this.resourcePatternResolver.getResource("file:///" + this.databaseConnectionPropertiesFile);
    }

    public Resource getReadableResource(String username, RoleFolders roleFolder, String filename) {
        return this.resourcePatternResolver.getResource("file:///" + Objects.requireNonNull(this.storageBaseDir) + roleFolder.toString().formatted(username) + filename);
    }

    public WritableResource getWritableResource(String username, RoleFolders roleFolder, String filename) {
        return (WritableResource)this.resourcePatternResolver.getResource("file:///" + Objects.requireNonNull(this.storageBaseDir) + roleFolder.toString().formatted(username) + filename);
    }

    public Resource[] listContentsOfUserFolder(String username, RoleFolders roleFolder) throws IOException {
        return this.resourcePatternResolver.getResources("file:///" + this.storageBaseDir + roleFolder.toString().formatted(username) + "*");
    }

    public static enum RoleFolders {
        MARKET_DATA_FOLDER("/%s.marketdata/"),
        SAVED_CONTRACTS_FOLDER("/%s.savedcontracts/");

        private final String folderTemplate;

        private RoleFolders(String s) {
            this.folderTemplate = s;
        }

        public String toString() {
            return this.folderTemplate;
        }
    }
}

