/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.smartcontract.valuation.service.websocket.client;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.OnClose;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@ClientEndpoint
public class WebSocketClientEndpoint
extends Endpoint {
    private final PublishSubject<String> messageSubject = PublishSubject.create();
    private URI endpointURI;
    private Session userSession;
    private ClientEndpointConfig config;

    public WebSocketClientEndpoint(URI endpointURI, String user, String password) {
        this.endpointURI = endpointURI;
        this.config = ClientEndpointConfig.Builder.create().build();
        this.config.getUserProperties().put("Authorization", this.getBasicAuthHeader(user, password));
    }

    public Session getUserSession() {
        if (this.userSession == null) {
            this.initSession();
        }
        return this.userSession;
    }

    public Observable<String> asObservable() {
        if (this.userSession == null) {
            this.initSession();
        }
        return this.messageSubject;
    }

    private void initSession() {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            container.setDefaultMaxBinaryMessageBufferSize(0x100000);
            this.userSession = container.connectToServer((Endpoint)this, this.config, this.endpointURI);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendTextMessage(String message) throws IOException {
        if (this.userSession == null) {
            this.initSession();
        }
        this.userSession.getBasicRemote().sendText(message);
    }

    public void onOpen(Session session, EndpointConfig config) {
        System.out.println("Opening websocket");
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                System.out.println("Received message: " + message);
            }
        });
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        System.out.println("Closing websocket");
        this.messageSubject.onComplete();
        this.userSession = null;
    }

    private String getBasicAuthHeader(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encodedAuth);
    }
}

