/*
 * Decompiled with CFR 0.152.
 */
package net.innig.sweetxml.maven;

import java.io.File;
import java.io.IOException;
import net.innig.sweetxml.ConversionMode;
import net.innig.sweetxml.FileConverterEngine;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;

public class ConvertResourcesMojo
extends AbstractMojo {
    private String inputDirectory;
    private String outputDirectory;
    private String mode;
    private boolean quiet = true;
    private boolean overwrite = true;
    private boolean deleteSources;

    public void execute() throws MojoExecutionException {
        ConversionMode modeParsed;
        if (this.mode == null) {
            this.mode = "s2x";
        }
        try {
            modeParsed = ConversionMode.valueOf((String)this.mode.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new MojoExecutionException("No such mode \"" + this.mode + "\"; expected \"x2s\" or \"s2x\"");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.inputDirectory;
        }
        File inputDir = new File(this.inputDirectory);
        File outputDir = new File(this.outputDirectory);
        if (!inputDir.exists()) {
            throw new MojoExecutionException("SweetXML input directory does not exist: " + inputDir);
        }
        if (!inputDir.isDirectory()) {
            throw new MojoExecutionException("SweetXML input directory is not a directory: " + inputDir);
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        } else if (!outputDir.isDirectory()) {
            throw new MojoExecutionException("SweetXML output directory does not exist: " + outputDir);
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(inputDir);
        scanner.setIncludes(new String[]{"**/**" + modeParsed.getSourceExtension()});
        scanner.addDefaultExcludes();
        scanner.scan();
        FileConverterEngine converter = new FileConverterEngine(this.overwrite, this.quiet);
        for (String inFileName : scanner.getIncludedFiles()) {
            try {
                File inFile = new File(inputDir, inFileName);
                File outFile = converter.outputFileFor(new File(outputDir, inFileName), modeParsed);
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                converter.convertFile(inFile, outFile, modeParsed);
                if (!this.deleteSources) continue;
                inFile.delete();
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to convert " + inFileName + " from " + modeParsed.getSourceExtension() + " to " + modeParsed.getTargetExtension(), (Exception)ioe);
            }
        }
    }
}

