/*
 * Copyright (c) 2003, 2004, 2005 Israfil Consulting Services Corporation
 * Copyright (c) 2003, 2004, 2005 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: Dynamic.java 26 2006-02-13 16:35:44Z cgruber $
 */
package net.israfil.foundation.core;

/**
 * A simple interface that defines the ability to perform and detect
 * arbitrary methods, by use of a "selector" string.  The selector
 * is a string constructed of a method name and an arbitrary number of 
 * classes representing parameter types.  These are then concatenated 
 * with a ":" separator.  The resulting string represents a full
 * method signature, without reference to the implementing class.  This
 * allows arbitrary classes to be interrogated as to the validity of a
 * given method call (i.e. do they or their parents implement it).  It
 * also then allows the method with the given signature to be invoked.
 * 
 * For example:
 * <code>
 *   if (a.respondsTo("doThing:java.lang.String"))
 *       a.perform("doThing:java.lang.String",aString);
 * </code>
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber </a>
 */
//@Copyright(years={"2003","2004","2005","2006"},owner="Israfil Consulting Services Corporation",license="BSD")
public interface Dynamic {

    public Object perform(String selector);
    public Object perform(String selector, Object o);
    public Object perform(String selector, Object[] parameters);
    
    public boolean respondsTo(String selector);

}
