/* 
 * Copyright (c) 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2006 Christian Edward Gruber
 * All Rights Reserved
 *
 * $Id: Types.java,v 1.1 2005/12/21 19:59:30 gordrob Exp $
 */
package net.israfil.foundation.core;

/**
 * A Utility class that provides general string manipulation help.
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber</a>
 * @author Latest: $Author: cgruber $
 * @version $Revision: 1.1 $
 */
public class Strings {
	
	public static String camel(String string) {
		if (string == null) return null;
		if (string.length() < 1) return string;
		StringBuffer sb = new StringBuffer(string);
		sb.replace(0,1,sb.substring(0,1).toUpperCase());
		return sb.toString();
	}

	public static String camelAllWords(String string, String separator) {
		String[] strings = string.split(separator);
		StringBuffer sb = new StringBuffer();
		boolean first = true;
		for (int i = 0; i < strings.length; i++) {
			if (!first) sb.append(separator);
			else first = false;
			sb.append(camel(strings[i]));
		}
		return sb.toString();
	}
}
