/*
 * Copyright (c) 2003, 2004, 2005, 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2003, 2004, 2005, 2006 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: MockResultSet.java 13 2006-01-27 23:45:36Z cgruber $
 */
package net.israfil.foundation.mock.sql;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.sql.Types;

/**
 * A database type for use within the MockResultSet
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber </a>
 */

public class DBType {
	
	public static final int BLOB = 0,
							BIT = 1,
							CHAR = 2,
							DECIMAL = 3,
							FLOAT = 4,
							DOUBLE = 5,
							SHORT = 6,
							INTEGER = 7,
							LONG = 8,
							BYTE = 9,
							STRING = 10,
							TIMESTAMP = 11,
							OBJECT = 12;

	public static final DBType[] types =  {
		new DBType("BLOB",byte[].class,Types.BLOB,DBTypeGroup.types[DBTypeGroup.Other]),
		new DBType("BIT",boolean.class,Types.BIT,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("CHAR",char.class,Types.CHAR,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("DECIMAL",BigDecimal.class,Types.DECIMAL,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("FLOAT",float.class,Types.FLOAT,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("DOUBLE",double.class,Types.DOUBLE,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("SMALLINT",short.class,Types.SMALLINT,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("INTEGER",int.class,Types.INTEGER,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("BIGINT",long.class,Types.BIGINT,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("TINYINT",byte.class,Types.TINYINT,DBTypeGroup.types[DBTypeGroup.Number]),
		new DBType("VARCHAR",String.class,Types.VARCHAR,DBTypeGroup.types[DBTypeGroup.String]),
		new DBType("TIMESTAMP",Timestamp.class,Types.TIMESTAMP,DBTypeGroup.types[DBTypeGroup.Time]),
		new DBType("JAVA_OBJECT",Object.class,Types.JAVA_OBJECT,DBTypeGroup.types[DBTypeGroup.Complex])};

    public final Class javaClass;
    public final int sqltype;
    public final DBTypeGroup group;
    public final String name;
    private DBType(String name, Class javaClass, int sqltype, DBTypeGroup group) {
    	this.name = name;
    	this.javaClass = javaClass;
    	this.sqltype = sqltype;
    	this.group = group;
    }
    public static DBType valueOf(String name) {
    	for (int i = 0; i < types.length; i++) {
    		if (types[i].name.equals(name)) return types[i];
    	}
    	return null;
    }
    public static DBType valueOf(int sqlType) {
		switch (sqlType) {
			case Types.BLOB:
			case Types.CLOB:
			case Types.BINARY:  
			case Types.VARBINARY:
			case Types.LONGVARBINARY: return DBType.types[DBType.BLOB];
				
			case Types.BIGINT: return DBType.types[DBType.LONG];
			
			case Types.BOOLEAN:
			case Types.BIT: return DBType.types[DBType.BIT];

			case Types.CHAR: return DBType.types[DBType.CHAR];
			case Types.DOUBLE: return DBType.types[DBType.DOUBLE];
			case Types.FLOAT: return DBType.types[DBType.FLOAT];
			case Types.INTEGER: return DBType.types[DBType.INTEGER];
			case Types.SMALLINT: return DBType.types[DBType.SHORT];
			case Types.TINYINT: return DBType.types[DBType.BYTE];
				
			case Types.NUMERIC:
			case Types.REAL:
			case Types.DECIMAL: return DBType.types[DBType.DECIMAL];
			
			case Types.VARCHAR: 
			case Types.LONGVARCHAR: return DBType.types[DBType.STRING];

			case Types.DATE:
			case Types.TIME:
			case Types.TIMESTAMP: return DBType.types[DBType.TIMESTAMP];
	
			case Types.JAVA_OBJECT: 
			case Types.ARRAY:
			case Types.STRUCT: return DBType.types[DBType.OBJECT];
	
			case Types.REF:
			case Types.DISTINCT:
			case Types.NULL:
			case Types.OTHER:			
			case Types.DATALINK:
			default:
				throw new IllegalArgumentException("Unsupported JDBC type");
		}
    	
    }
}
