/*
 * Copyright (c) 2003, 2004, 2005, 2006 Israfil Consulting Services Corporation
 * Copyright (c) 2003, 2004, 2005, 2006 Christian Edward Gruber
 * All Rights Reserved
 * 
 * This software is licensed under the Berkeley Standard Distribution license,
 * (BSD license), as defined below:
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this 
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of Israfil Consulting Services nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 * 
 * $Id: MockResultSet.java 13 2006-01-27 23:45:36Z cgruber $
 */
package net.israfil.foundation.mock.sql;



/**
 * A database type for use within the MockResultSet
 * 
 * @author <a href="mailto:cgruber@israfil.net">Christian Edward Gruber </a>
 */

public class DBTypeGroup { 
	public final static int Time = 0, 
							Number = 1, 
							String = 2, 
							Complex = 3, 
							Other = 4; 
	public final static DBTypeGroup[] types = {
		new DBTypeGroup(0,"Time"), 
		new DBTypeGroup(1,"Number"), 
		new DBTypeGroup(2,"String"), 
		new DBTypeGroup(3,"Complex"), 
		new DBTypeGroup(4,"Other")}; 
	public final int value; 
	public final String name;
	public DBTypeGroup(int value, String name) {
		this.value = value;
		this.name = name;
	}
    public static DBTypeGroup valueOf(String name) {
    	for (int i = 0; i < types.length; i++) {
    		if (types[i].name.equals(name)) return types[i];
    	}
    	return null;    	
    }
}
