/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.caching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.israfil.foundation.caching.Cache;
import net.israfil.foundation.caching.Fetcher;

public class GenericCache
implements Cache {
    private Map _caches = new HashMap();

    public Object get(Fetcher fetcher, String cacheName, String itemKey) {
        return this.get(fetcher, cacheName, itemKey, (String[])null);
    }

    public Object get(Fetcher fetcher, String cacheName, String itemKey, String subCache) {
        return this.get(fetcher, cacheName, itemKey, new String[]{subCache});
    }

    public Object get(Fetcher fetcher, String cacheName, String itemKey, String[] path) {
        Map cache = GenericCache._getLocationInMap(this._caches, new ArrayList(GenericCache._prepPathList(cacheName, path)));
        Object o = cache.get(itemKey == null ? "__NULL__" : itemKey);
        if (o == null) {
            fetcher.fetch();
            o = cache.get(itemKey == null ? "__NULL__" : itemKey);
        }
        return o;
    }

    public void set(String cacheName, String itemKey, Object value) {
        this.set(cacheName, itemKey, value, (String[])null);
    }

    public void set(String cacheName, String itemKey, Object value, String subCache) {
        this.set(cacheName, itemKey, value, new String[]{subCache});
    }

    public void set(String cacheName, String itemKey, Object value, String[] path) {
        List pathList = GenericCache._prepPathList(cacheName, path);
        Map cache = GenericCache._getLocationInMap(this._caches, new ArrayList(pathList));
        cache.put(itemKey, value);
    }

    static List _prepPathList(String cacheName, String[] pathElements) {
        ArrayList<String> pathList = pathElements == null || pathElements.length < 1 ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(pathElements));
        pathList.add(0, cacheName);
        return pathList;
    }

    static Map _getLocationInMap(Map currentMap, List cachePath) {
        if (cachePath == null || cachePath.size() < 1) {
            return currentMap;
        }
        String cacheName = (String)cachePath.remove(0);
        HashMap cacheObject = (HashMap)currentMap.get(cacheName);
        if (cacheObject == null) {
            cacheObject = new HashMap();
            currentMap.put(cacheName, cacheObject);
        }
        if (!(cacheObject instanceof Map)) {
            throw new IllegalArgumentException("Attempted to find a map at location (" + cachePath + ") in cache (" + cacheName + "), but found a " + cacheObject.getClass().getName() + ".");
        }
        Map cache = cacheObject;
        return GenericCache._getLocationInMap(cache, cachePath);
    }
}

