/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.israfil.foundation.core.DynamicUtil;
import net.israfil.foundation.core.DynamicallyAccessibleObject;
import net.israfil.foundation.core.DynamicallyMutable;
import net.israfil.foundation.core.Strings;
import net.israfil.foundation.core.Types;

public abstract class DynamicallyMutableObject
extends DynamicallyAccessibleObject
implements DynamicallyMutable {
    private static Logger logger = Logger.getLogger(DynamicallyMutableObject.class.getName());
    protected static final String mutatePrefix = "set";

    public void setNull(String attributeName, Class valueType) {
        this.setNull(this, attributeName, valueType);
    }

    public void setNull(Object target, String attributeName, Class valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Cannot give a valueType of null for setNull(String,Class) method.");
        }
        DynamicallyMutableObject.set(target, attributeName, null, valueType);
    }

    public void set(String attributeName, Object value) {
        DynamicallyMutableObject.set(this, attributeName, value);
    }

    public static void set(Object target, String attributeName, Object value) {
        if (value == null) {
            DynamicallyMutableObject.set(target, attributeName, value, null);
        } else {
            DynamicallyMutableObject.set(target, attributeName, value, value.getClass());
        }
    }

    public void set(String attributeName, Object value, Class valueType) {
        DynamicallyMutableObject.set(this, attributeName, value, valueType);
    }

    public static void set(Object target, String attributeName, Object value, Class valueType) {
        if (value == null) {
            if (valueType != null && valueType.isPrimitive()) {
                throw new IllegalArgumentException("Attempted to set null on a variable or accessor for attribute '" + attributeName + "' of primitive type: " + valueType);
            }
            String selector = DynamicallyMutableObject.getMutatorSelector(target, attributeName, valueType);
            if (selector != null) {
                Method m = DynamicUtil.getMethodForSelector(target, selector);
                Class<?>[] parmTypes = m.getParameterTypes();
                if (parmTypes[0].isPrimitive()) {
                    throw new IllegalArgumentException("Attempted to set null using an accessor for attribute '" + attributeName + "' of primitive type: " + parmTypes[0]);
                }
                DynamicUtil.performOn(target, selector, new Object[]{value});
            } else {
                Field f = DynamicUtil.getField(target, attributeName);
                if (f == null || f.getType().isPrimitive()) {
                    throw new IllegalArgumentException("Attempted to set null but could not find a set" + Strings.camel(attributeName) + " method with a single non-primitive type.");
                }
                DynamicallyMutableObject._setField(target, attributeName, valueType);
            }
        } else {
            if (valueType == null) {
                valueType = value.getClass();
            }
            if (DynamicallyMutableObject.hasMutator(target, attributeName, valueType)) {
                DynamicUtil.performOn(target, DynamicallyMutableObject.getMutatorSelector(target, attributeName, valueType), new Object[]{value});
                return;
            }
            if (DynamicallyMutableObject.hasMutator(target, attributeName, DynamicUtil.getPrimitiveTypeEquivalent(valueType))) {
                DynamicUtil.performOn(target, DynamicallyMutableObject.getMutatorSelector(target, attributeName, DynamicUtil.getPrimitiveTypeEquivalent(valueType)), new Object[]{value});
                return;
            }
            DynamicallyMutableObject._setField(target, attributeName, value);
        }
    }

    protected void _setField(String attributeName, Object value) {
        DynamicallyMutableObject._setField(this, attributeName, value);
    }

    protected static void _setField(Object target, String attributeName, Object value) {
        Field f = DynamicUtil.getField(target, attributeName);
        try {
            f.set(target, Types.convert(value, f.getType()));
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINEST, "Object attempted to dynamically access a inaccessible field.", e);
            throw new RuntimeException(e);
        }
    }

    protected String getMutatorSelector(String attributeName, Class type) {
        return DynamicallyMutableObject.getMutatorSelector(this, attributeName, type);
    }

    protected static String getMutatorSelector(Object target, String attributeName, Class type) {
        if (attributeName == null || attributeName.equals("")) {
            return null;
        }
        String camelAttr = Strings.camel(attributeName);
        String selector = null;
        if (type == null) {
            Method method = DynamicallyMutableObject._tryToFindMutator(target, attributeName);
            if (method == null) {
                return null;
            }
            if (method.getParameterTypes().length != 1) {
                return null;
            }
            return mutatePrefix + Strings.camel(attributeName) + ":" + method.getParameterTypes()[0].getName();
        }
        String tmp = mutatePrefix + camelAttr + ":" + type.getName();
        if (DynamicUtil.respondsTo(target, tmp)) {
            selector = tmp;
        }
        Iterator i = DynamicUtil.getAllParentTypes(type).iterator();
        while (selector == null && i.hasNext()) {
            Class c = (Class)i.next();
            tmp = mutatePrefix + camelAttr + ":" + c.getName();
            if (!DynamicUtil.respondsTo(target, tmp)) continue;
            selector = tmp;
        }
        return selector;
    }

    protected static Method _tryToFindMutator(Object target, String attributeName) {
        Method method = null;
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(mutatePrefix + Strings.camel(attributeName))) continue;
            if (method == null) {
                method = methods[i];
                continue;
            }
            throw new IllegalArgumentException("Attempted to find set" + Strings.camel(attributeName) + " without a given type, but more than one such method exists.  Should use set(String,Object,Class)");
        }
        return method;
    }

    protected static Method _tryToFindMutator(Object target, String attributeName, Class type) {
        if (type == null) {
            throw new IllegalArgumentException("Must set a type, or use _tryToFindMutator(Object,String).");
        }
        String methodName = mutatePrefix + Strings.camel(attributeName);
        Method m = DynamicUtil.getMethodForSelector(target, methodName + ":" + type.getName());
        Iterator types = DynamicUtil.getAllParentTypes(type).iterator();
        while (m == null && types.hasNext()) {
            Class c = (Class)types.next();
            m = DynamicUtil.getMethodForSelector(target, methodName + ":" + c.getName());
        }
        return m;
    }

    public static Method getMutator(Object target, String attributeName, Class type) {
        if (type == null) {
            return DynamicallyMutableObject._tryToFindMutator(target, attributeName);
        }
        return DynamicallyMutableObject._tryToFindMutator(target, attributeName, type);
    }

    public boolean hasMutator(String attributeName, Class type) {
        return DynamicallyMutableObject.hasMutator(this, attributeName, type);
    }

    public static boolean hasMutator(Object target, String attributeName, Class type) {
        return DynamicallyMutableObject.getMutatorSelector(target, attributeName, type) != null;
    }
}

