/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.core;

public class Types {
    private static final byte BOOLEAN_FALSE_NUMERIC = 0;
    private static final byte BOOLEAN_TRUE_NUMERIC = 1;

    public static Object convert(Object value, Class aClass) {
        return Types.convert(value, aClass, null);
    }

    public static Object convert(Object value, Class aClass, Converter converter) {
        if (value == null) {
            return null;
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Cannot convert to a null class.");
        }
        if (Void.class.isAssignableFrom(aClass)) {
            throw new IllegalArgumentException("Cannot convert to void.");
        }
        if (aClass.isInstance(value)) {
            return value;
        }
        if (aClass.isAssignableFrom(String.class)) {
            return String.valueOf(value);
        }
        if (Boolean.class.isAssignableFrom(aClass)) {
            if (value instanceof String) {
                if (((String)value).equalsIgnoreCase("Yes")) {
                    return Boolean.TRUE;
                }
                if (((String)value).equalsIgnoreCase("True")) {
                    return Boolean.TRUE;
                }
                if (((String)value).equalsIgnoreCase("Y")) {
                    return Boolean.TRUE;
                }
                if (((String)value).equalsIgnoreCase("T")) {
                    return Boolean.TRUE;
                }
                if (((String)value).equalsIgnoreCase("1")) {
                    return Boolean.TRUE;
                }
                if (((String)value).equalsIgnoreCase("Aye")) {
                    return Boolean.TRUE;
                }
                if (((String)value).equalsIgnoreCase("Yar")) {
                    return Boolean.TRUE;
                }
                if (((String)value).equalsIgnoreCase("No")) {
                    return Boolean.FALSE;
                }
                if (((String)value).equalsIgnoreCase("False")) {
                    return Boolean.FALSE;
                }
                if (((String)value).equalsIgnoreCase("N")) {
                    return Boolean.FALSE;
                }
                if (((String)value).equalsIgnoreCase("F")) {
                    return Boolean.FALSE;
                }
                if (((String)value).equalsIgnoreCase("0")) {
                    return Boolean.FALSE;
                }
                if (((String)value).equalsIgnoreCase("Avast")) {
                    return Boolean.FALSE;
                }
                if (((String)value).equalsIgnoreCase("Nay")) {
                    return Boolean.FALSE;
                }
                throw new IllegalArgumentException("Cannot convert value '" + value + "' to a java.lang.Boolean");
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        } else if (aClass.isAssignableFrom(Byte.class)) {
            if (value instanceof String) {
                return Byte.valueOf((String)value);
            }
            if (value instanceof Number) {
                return new Byte(((Number)value).byteValue());
            }
            if (value instanceof Boolean) {
                return new Byte((Boolean)value != false ? (byte)1 : 0);
            }
        } else if (aClass.isAssignableFrom(Short.class)) {
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
            if (value instanceof Number) {
                return new Short(((Number)value).shortValue());
            }
            if (value instanceof Boolean) {
                return new Short((Boolean)value != false ? (short)1 : 0);
            }
        } else if (aClass.isAssignableFrom(Integer.class)) {
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            if (value instanceof Number) {
                return new Integer(((Number)value).intValue());
            }
            if (value instanceof Boolean) {
                return new Integer((Boolean)value != false ? 1 : 0);
            }
        } else if (aClass.isAssignableFrom(Long.class)) {
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
            if (value instanceof Number) {
                return new Long(((Number)value).longValue());
            }
            if (value instanceof Boolean) {
                return new Long((Boolean)value != false ? 1L : 0L);
            }
        } else if (aClass.isAssignableFrom(Float.class)) {
            if (value instanceof String) {
                return Float.valueOf((String)value);
            }
            if (value instanceof Number) {
                return new Float(((Number)value).floatValue());
            }
            if (value instanceof Boolean) {
                return new Float((Boolean)value != false ? 1.0f : 0.0f);
            }
        } else if (aClass.isAssignableFrom(Double.class)) {
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            if (value instanceof Number) {
                return new Double(((Number)value).doubleValue());
            }
            if (value instanceof Boolean) {
                return new Double((Boolean)value != false ? 1.0 : 0.0);
            }
        } else if (aClass.isAssignableFrom(Character.class)) {
            if (value instanceof String) {
                return new Character(((String)value).charAt(0));
            }
            if (value instanceof Number) {
                return new Character((char)((Number)value).byteValue());
            }
            if (value instanceof Boolean) {
                return new Character((Boolean)value != false ? (char)'T' : 'F');
            }
        }
        if (value instanceof String) {
            String stringVal = (String)value;
            if (Float.class.isAssignableFrom(aClass)) {
                return new Float((String)value);
            }
            if (Double.class.isAssignableFrom(aClass)) {
                return new Double((String)value);
            }
            if (Byte.class.isAssignableFrom(aClass)) {
                return new Byte((String)value);
            }
            if (Short.class.isAssignableFrom(aClass)) {
                return new Short((String)value);
            }
            if (Integer.class.isAssignableFrom(aClass)) {
                return new Integer((String)value);
            }
            if (Long.class.isAssignableFrom(aClass)) {
                return new Long((String)value);
            }
            if (Character.class.isAssignableFrom(aClass)) {
                return new Character(stringVal.charAt(0));
            }
        }
        if (converter != null) {
            return converter.convert(value, aClass);
        }
        throw new IllegalArgumentException("Don't know how to convert a String to a " + aClass);
    }

    public static Object convert(boolean object, Class aClass) {
        return Types.convert(new Boolean(object), aClass);
    }

    public static Object convert(byte object, Class aClass) {
        return Types.convert(new Byte(object), aClass);
    }

    public static Object convert(short object, Class aClass) {
        return Types.convert(new Short(object), aClass);
    }

    public static Object convert(int object, Class aClass) {
        return Types.convert(new Integer(object), aClass);
    }

    public static Object convert(long object, Class aClass) {
        return Types.convert(new Long(object), aClass);
    }

    public static Object convert(float object, Class aClass) {
        return Types.convert(new Float(object), aClass);
    }

    public static Object convert(double object, Class aClass) {
        return Types.convert(new Double(object), aClass);
    }

    public static Object convert(char object, Class aClass) {
        return Types.convert(new Character(object), aClass);
    }

    public static boolean convertToBoolean(Object object) {
        return (Boolean)Types.convert(object, Boolean.class);
    }

    public static byte convertToByte(Object object) {
        return ((Number)Types.convert(object, Byte.class)).byteValue();
    }

    public static short convertToShort(Object object) {
        return ((Number)Types.convert(object, Short.class)).shortValue();
    }

    public static int convertToInt(Object object) {
        return ((Number)Types.convert(object, Integer.class)).intValue();
    }

    public static long convertToLong(Object object) {
        return ((Number)Types.convert(object, Long.class)).longValue();
    }

    public static float convertToFloat(Object object) {
        return ((Number)Types.convert(object, Float.class)).floatValue();
    }

    public static double convertToDouble(Object object) {
        return ((Number)Types.convert(object, Double.class)).doubleValue();
    }

    public static char convertToChar(Object object) {
        return ((Character)Types.convert(object, Character.class)).charValue();
    }

    public static interface Converter {
        public Object convert(Object var1, Class var2);
    }
}

