/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.mock.sql;

import java.math.BigDecimal;
import java.sql.Timestamp;
import net.israfil.foundation.mock.sql.DBTypeGroup;

public class DBType {
    public static final int BLOB = 0;
    public static final int BIT = 1;
    public static final int CHAR = 2;
    public static final int DECIMAL = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int SHORT = 6;
    public static final int INTEGER = 7;
    public static final int LONG = 8;
    public static final int BYTE = 9;
    public static final int STRING = 10;
    public static final int TIMESTAMP = 11;
    public static final int OBJECT = 12;
    public static final DBType[] types = new DBType[]{new DBType("BLOB", [B.class, 2004, DBTypeGroup.types[4]), new DBType("BIT", Boolean.TYPE, -7, DBTypeGroup.types[1]), new DBType("CHAR", Character.TYPE, 1, DBTypeGroup.types[1]), new DBType("DECIMAL", BigDecimal.class, 3, DBTypeGroup.types[1]), new DBType("FLOAT", Float.TYPE, 6, DBTypeGroup.types[1]), new DBType("DOUBLE", Double.TYPE, 8, DBTypeGroup.types[1]), new DBType("SMALLINT", Short.TYPE, 5, DBTypeGroup.types[1]), new DBType("INTEGER", Integer.TYPE, 4, DBTypeGroup.types[1]), new DBType("BIGINT", Long.TYPE, -5, DBTypeGroup.types[1]), new DBType("TINYINT", Byte.TYPE, -6, DBTypeGroup.types[1]), new DBType("VARCHAR", String.class, 12, DBTypeGroup.types[2]), new DBType("TIMESTAMP", Timestamp.class, 93, DBTypeGroup.types[0]), new DBType("JAVA_OBJECT", Object.class, 2000, DBTypeGroup.types[3])};
    public final Class javaClass;
    public final int sqltype;
    public final DBTypeGroup group;
    public final String name;

    private DBType(String name, Class javaClass, int sqltype, DBTypeGroup group) {
        this.name = name;
        this.javaClass = javaClass;
        this.sqltype = sqltype;
        this.group = group;
    }

    public static DBType valueOf(String name) {
        for (int i = 0; i < types.length; ++i) {
            if (!DBType.types[i].name.equals(name)) continue;
            return types[i];
        }
        return null;
    }

    public static DBType valueOf(int sqlType) {
        switch (sqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                return types[0];
            }
            case -5: {
                return types[8];
            }
            case -7: 
            case 16: {
                return types[1];
            }
            case 1: {
                return types[2];
            }
            case 8: {
                return types[5];
            }
            case 6: {
                return types[4];
            }
            case 4: {
                return types[7];
            }
            case 5: {
                return types[6];
            }
            case -6: {
                return types[9];
            }
            case 2: 
            case 3: 
            case 7: {
                return types[3];
            }
            case -1: 
            case 12: {
                return types[10];
            }
            case 91: 
            case 92: 
            case 93: {
                return types[11];
            }
            case 2000: 
            case 2002: 
            case 2003: {
                return types[12];
            }
        }
        throw new IllegalArgumentException("Unsupported JDBC type");
    }
}

