/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.mock.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import net.israfil.foundation.mock.sql.MockResultSetMetaData;
import net.israfil.foundation.mock.sql.Row;

public class MockResultSet
implements ResultSet {
    public MockResultSetMetaData metadata;
    protected List data;
    int cursorPosition = 0;
    boolean insertRow = false;
    private static final int BEFOREFIRST = 0;
    private final int AFTERLAST;
    protected int concurrency = 1007;
    protected int fetchDirection = 1002;
    protected int fetchSize = 0;
    protected Statement statement = null;
    protected boolean wasNull = false;
    boolean open = false;

    public List getData() {
        return this.data;
    }

    private MockResultSet(int size) {
        this.AFTERLAST = size + 1;
    }

    public MockResultSet(String[] columns, Object[][] rows) {
        this(rows == null ? 0 : rows.length);
        this.metadata = new MockResultSetMetaData(columns);
        this.primeRows(rows);
    }

    public MockResultSet(MockResultSetMetaData.ColSpec[] columns, Object[][] rows) {
        this(rows == null ? 0 : rows.length);
        this.metadata = new MockResultSetMetaData(columns);
        this.primeRows(rows);
    }

    private void primeRows(Object[][] rows) {
        if (rows == null) {
            rows = new String[][]{};
        }
        try {
            this.data = new ArrayList(this.metadata.getColumnCount());
            for (int rowNum = 0; rowNum < rows.length; ++rowNum) {
                this.data.add(new Row(this.metadata, new ArrayList<Object>(Arrays.asList(rows[rowNum]))));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.cursorPosition = 0;
        this.open = true;
    }

    public void finalize() throws Throwable {
        this.data = null;
        this.metadata = null;
        super.finalize();
    }

    public boolean absolute(int row) throws SQLException {
        if (row > 0) {
            if (0 + row < this.AFTERLAST) {
                this.cursorPosition = 0 + row;
                return true;
            }
            this.cursorPosition = this.AFTERLAST;
            return false;
        }
        if (row < 0) {
            if (this.AFTERLAST + row > 0) {
                this.cursorPosition = this.AFTERLAST + row;
                return true;
            }
            this.cursorPosition = 0;
            return false;
        }
        this.cursorPosition = 0;
        return false;
    }

    public void afterLast() throws SQLException {
        this.absolute(this.data.size() + 1);
    }

    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void close() throws SQLException {
        this.open = false;
    }

    public void deleteRow() throws SQLException {
        if (this.insertRow) {
            throw new SQLException("Cannot delete the insert row.");
        }
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public int findColumn(String column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Object getInternalValue(int rowNumber, int column) {
        try {
            return this.processAccessedObject(((Row)this.data.get(rowNumber - 1)).get(column));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getInternalValue(int rowNumber, String column) {
        try {
            return this.processAccessedObject(((Row)this.data.get(rowNumber - 1)).get(column));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Object processAccessedObject(Object o) {
        if (o == null) {
            this.wasNull = true;
        }
        return o;
    }

    public Array getArray(int column) throws SQLException {
        return (Array)this.getInternalValue(this.cursorPosition, column);
    }

    public Array getArray(String column) throws SQLException {
        return (Array)this.getInternalValue(this.cursorPosition, column);
    }

    public InputStream getAsciiStream(int column) throws SQLException {
        return (InputStream)this.getInternalValue(this.cursorPosition, column);
    }

    public InputStream getAsciiStream(String column) throws SQLException {
        return (InputStream)this.getInternalValue(this.cursorPosition, column);
    }

    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        BigDecimal bd;
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            bd = new BigDecimal((String)o);
        } else if (o instanceof Number) {
            bd = new BigDecimal(((Number)o).doubleValue());
        } else if (o instanceof Date) {
            bd = new BigDecimal(((Date)o).getTime());
        } else if (o instanceof Calendar) {
            bd = new BigDecimal(((Calendar)o).getTimeInMillis());
        } else {
            if (o instanceof Boolean) {
                return new BigDecimal((Boolean)o != false ? 1 : 0);
            }
            bd = new BigDecimal(String.valueOf(o));
        }
        bd.setScale(scale);
        return bd;
    }

    public BigDecimal getBigDecimal(int column) throws SQLException {
        BigDecimal bd;
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            bd = new BigDecimal((String)o);
        } else if (o instanceof Number) {
            bd = new BigDecimal(((Number)o).doubleValue());
        } else if (o instanceof Date) {
            bd = new BigDecimal(((Date)o).getTime());
        } else if (o instanceof Calendar) {
            bd = new BigDecimal(((Calendar)o).getTimeInMillis());
        } else {
            if (o instanceof Boolean) {
                return new BigDecimal((Boolean)o != false ? 1 : 0);
            }
            bd = new BigDecimal(String.valueOf(o));
        }
        return bd;
    }

    public BigDecimal getBigDecimal(String column, int scale) throws SQLException {
        BigDecimal bd;
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            bd = new BigDecimal((String)o);
        } else if (o instanceof Number) {
            bd = new BigDecimal(((Number)o).doubleValue());
        } else if (o instanceof Date) {
            bd = new BigDecimal(((Date)o).getTime());
        } else if (o instanceof Calendar) {
            bd = new BigDecimal(((Calendar)o).getTimeInMillis());
        } else {
            if (o instanceof Boolean) {
                return new BigDecimal((Boolean)o != false ? 1 : 0);
            }
            bd = new BigDecimal(String.valueOf(o));
        }
        bd.setScale(scale);
        return bd;
    }

    public BigDecimal getBigDecimal(String column) throws SQLException {
        BigDecimal bd;
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            bd = new BigDecimal((String)o);
        } else if (o instanceof Number) {
            bd = new BigDecimal(((Number)o).doubleValue());
        } else if (o instanceof Date) {
            bd = new BigDecimal(((Date)o).getTime());
        } else if (o instanceof Calendar) {
            bd = new BigDecimal(((Calendar)o).getTimeInMillis());
        } else {
            if (o instanceof Boolean) {
                return new BigDecimal((Boolean)o != false ? 1 : 0);
            }
            bd = new BigDecimal(String.valueOf(o));
        }
        return bd;
    }

    public InputStream getBinaryStream(int column) throws SQLException {
        return (InputStream)this.getInternalValue(this.cursorPosition, column);
    }

    public InputStream getBinaryStream(String column) throws SQLException {
        return (InputStream)this.getInternalValue(this.cursorPosition, column);
    }

    public Blob getBlob(int column) throws SQLException {
        return new MockBlob(this.getBytes(column));
    }

    public Blob getBlob(String column) throws SQLException {
        return new MockBlob(this.getBytes(column));
    }

    public boolean getBoolean(int column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return false;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).byteValue() != 0;
        }
        return Boolean.valueOf(String.valueOf(o));
    }

    public boolean getBoolean(String column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return false;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).byteValue() != 0;
        }
        return Boolean.valueOf(String.valueOf(o));
    }

    public byte getByte(int column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        return Byte.valueOf(String.valueOf(o));
    }

    public byte getByte(String column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        return Byte.valueOf(String.valueOf(o));
    }

    public byte[] getBytes(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public byte[] getBytes(String column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Reader getCharacterStream(int column) throws SQLException {
        return (Reader)this.getInternalValue(this.cursorPosition, column);
    }

    public Reader getCharacterStream(String column) throws SQLException {
        return (Reader)this.getInternalValue(this.cursorPosition, column);
    }

    public Clob getClob(int column) throws SQLException {
        return (Clob)this.getInternalValue(this.cursorPosition, column);
    }

    public Clob getClob(String column) throws SQLException {
        return (Clob)this.getInternalValue(this.cursorPosition, column);
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Date getDate(int column, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Date getDate(int column) throws SQLException {
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof java.util.Date) {
            return new Date(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new Date(((Calendar)o).getTimeInMillis());
        }
        return Date.valueOf(String.valueOf(o));
    }

    public Date getDate(String column, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Date getDate(String column) throws SQLException {
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof java.util.Date) {
            return new Date(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new Date(((Calendar)o).getTimeInMillis());
        }
        return Date.valueOf(String.valueOf(o));
    }

    public double getDouble(int column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0.0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        return Double.valueOf(String.valueOf(o));
    }

    public double getDouble(String column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0.0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        return Double.valueOf(String.valueOf(o));
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public float getFloat(int column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0.0f;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0f : 0.0f;
        }
        return Float.valueOf(String.valueOf(o)).floatValue();
    }

    public float getFloat(String column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0.0f;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0f : 0.0f;
        }
        return Float.valueOf(String.valueOf(o)).floatValue();
    }

    public int getInt(int column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return Integer.valueOf(String.valueOf(o));
    }

    public int getInt(String column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return Integer.valueOf(String.valueOf(o));
    }

    public long getLong(int column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0L;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        return Long.valueOf(String.valueOf(o));
    }

    public long getLong(String column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0L;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        return Long.valueOf(String.valueOf(o));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    public Object getObject(int column, Map mapping) throws SQLException {
        throw new UnsupportedOperationException("Unimplented feature.");
    }

    public Object getObject(int column) throws SQLException {
        return this.getInternalValue(this.cursorPosition, column);
    }

    public Object getObject(String column, Map mapping) throws SQLException {
        throw new UnsupportedOperationException("Unimplented feature.");
    }

    public Object getObject(String column) throws SQLException {
        return this.getInternalValue(this.cursorPosition, column);
    }

    public Ref getRef(int column) throws SQLException {
        throw new UnsupportedOperationException("Unimplented feature.");
    }

    public Ref getRef(String column) throws SQLException {
        throw new UnsupportedOperationException("Unimplented feature.");
    }

    public int getRow() throws SQLException {
        return this.cursorPosition > 0 && this.cursorPosition < this.AFTERLAST ? this.cursorPosition : 0;
    }

    public short getShort(int column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        return Short.valueOf(String.valueOf(o));
    }

    public short getShort(String column) throws SQLException {
        if (this.getInternalValue(this.cursorPosition, column) == null) {
            return 0;
        }
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        return Short.valueOf(String.valueOf(o));
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public String getString(int column) throws SQLException {
        return String.valueOf(this.getInternalValue(this.cursorPosition, column));
    }

    public String getString(String column) throws SQLException {
        return String.valueOf(this.getInternalValue(this.cursorPosition, column));
    }

    public Time getTime(int column, Calendar cal) throws SQLException {
        return (Time)this.getInternalValue(this.cursorPosition, column);
    }

    public Time getTime(int column) throws SQLException {
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof Time) {
            return (Time)o;
        }
        if (o instanceof java.util.Date) {
            return new Time(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new Time(((Calendar)o).getTimeInMillis());
        }
        return Time.valueOf(String.valueOf(o));
    }

    public Time getTime(String column, Calendar cal) throws SQLException {
        return (Time)this.getInternalValue(this.cursorPosition, column);
    }

    public Time getTime(String column) throws SQLException {
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof Time) {
            return (Time)o;
        }
        if (o instanceof java.util.Date) {
            return new Time(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new Time(((Calendar)o).getTimeInMillis());
        }
        return Time.valueOf(String.valueOf(o));
    }

    public Timestamp getTimestamp(int column, Calendar cal) throws SQLException {
        return (Timestamp)this.getInternalValue(this.cursorPosition, column);
    }

    public Timestamp getTimestamp(int column) throws SQLException {
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof java.util.Date) {
            return new Timestamp(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new Timestamp(((Calendar)o).getTimeInMillis());
        }
        return Timestamp.valueOf(String.valueOf(o));
    }

    public Timestamp getTimestamp(String column, Calendar cal) throws SQLException {
        return (Timestamp)this.getInternalValue(this.cursorPosition, column);
    }

    public Timestamp getTimestamp(String column) throws SQLException {
        Object o = this.getInternalValue(this.cursorPosition, column);
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof java.util.Date) {
            return new Timestamp(((Date)o).getTime());
        }
        if (o instanceof Calendar) {
            return new Timestamp(((Calendar)o).getTimeInMillis());
        }
        return Timestamp.valueOf(String.valueOf(o));
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public InputStream getUnicodeStream(int column) throws SQLException {
        return (InputStream)this.getInternalValue(this.cursorPosition, column);
    }

    public InputStream getUnicodeStream(String column) throws SQLException {
        return (InputStream)this.getInternalValue(this.cursorPosition, column);
    }

    public URL getURL(int column) throws SQLException {
        return (URL)this.getInternalValue(this.cursorPosition, column);
    }

    public URL getURL(String column) throws SQLException {
        return (URL)this.getInternalValue(this.cursorPosition, column);
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        if (!this.insertRow) {
            throw new SQLException("Cannot insert any row except the insert row.");
        }
    }

    public boolean isAfterLast() throws SQLException {
        return this.cursorPosition >= this.AFTERLAST;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.cursorPosition <= 0;
    }

    public boolean isFirst() throws SQLException {
        return this.data.size() > 0 && !this.insertRow && this.cursorPosition == 1;
    }

    public boolean isLast() throws SQLException {
        return this.data.size() > 0 && !this.insertRow && this.cursorPosition == this.AFTERLAST - 1;
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public void moveToCurrentRow() throws SQLException {
        this.insertRow = false;
    }

    public void moveToInsertRow() throws SQLException {
        this.insertRow = true;
    }

    public boolean next() throws SQLException {
        return this.relative(1);
    }

    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    public void refreshRow() throws SQLException {
    }

    public boolean relative(int offset) throws SQLException {
        return this.absolute(this.cursorPosition + offset);
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 || this.statement != null && rows > this.statement.getMaxRows()) {
            throw new SQLException("Fetch size less than zero or greater than statement's maximum rows.");
        }
        this.fetchSize = rows;
    }

    public void updateArray(int column, Array x) throws SQLException {
    }

    public void updateArray(String column, Array x) throws SQLException {
        this.updateArray(this.findColumn(column), x);
    }

    public void updateAsciiStream(int column, InputStream x, int length) throws SQLException {
    }

    public void updateAsciiStream(String column, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(column), x, length);
    }

    public void updateBigDecimal(int column, BigDecimal x) throws SQLException {
    }

    public void updateBigDecimal(String column, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(column), x);
    }

    public void updateBinaryStream(int column, InputStream x, int length) throws SQLException {
    }

    public void updateBinaryStream(String column, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(column), x, length);
    }

    public void updateBlob(int column, Blob x) throws SQLException {
    }

    public void updateBlob(String column, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(column), x);
    }

    public void updateBoolean(int column, boolean x) throws SQLException {
    }

    public void updateBoolean(String column, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(column), x);
    }

    public void updateByte(int column, byte x) throws SQLException {
    }

    public void updateByte(String column, byte x) throws SQLException {
        this.updateByte(this.findColumn(column), x);
    }

    public void updateBytes(int column, byte[] x) throws SQLException {
    }

    public void updateBytes(String column, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(column), x);
    }

    public void updateCharacterStream(int column, Reader x, int length) throws SQLException {
    }

    public void updateCharacterStream(String column, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(column), reader, length);
    }

    public void updateClob(int column, Clob x) throws SQLException {
    }

    public void updateClob(String column, Clob x) throws SQLException {
        this.updateClob(this.findColumn(column), x);
    }

    public void updateDate(int column, Date x) throws SQLException {
    }

    public void updateDate(String column, Date x) throws SQLException {
        this.updateDate(this.findColumn(column), x);
    }

    public void updateDouble(int column, double x) throws SQLException {
    }

    public void updateDouble(String column, double x) throws SQLException {
        this.updateDouble(this.findColumn(column), x);
    }

    public void updateFloat(int column, float x) throws SQLException {
    }

    public void updateFloat(String column, float x) throws SQLException {
        this.updateFloat(this.findColumn(column), x);
    }

    public void updateInt(int column, int x) throws SQLException {
    }

    public void updateInt(String column, int x) throws SQLException {
        this.updateInt(this.findColumn(column), x);
    }

    public void updateLong(int column, long x) throws SQLException {
    }

    public void updateLong(String column, long x) throws SQLException {
        this.updateLong(this.findColumn(column), x);
    }

    public void updateNull(int column) throws SQLException {
    }

    public void updateNull(String column) throws SQLException {
        this.updateNull(this.findColumn(column));
    }

    public void updateObject(int column, Object x, int scale) throws SQLException {
    }

    public void updateObject(int column, Object x) throws SQLException {
    }

    public void updateObject(String column, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(column), x, scale);
    }

    public void updateObject(String column, Object x) throws SQLException {
        this.updateObject(this.findColumn(column), x);
    }

    public void updateRef(int column, Ref x) throws SQLException {
    }

    public void updateRef(String column, Ref x) throws SQLException {
        this.updateRef(this.findColumn(column), x);
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void updateShort(int column, short x) throws SQLException {
    }

    public void updateShort(String column, short x) throws SQLException {
        this.updateShort(this.findColumn(column), x);
    }

    public void updateString(int column, String x) throws SQLException {
    }

    public void updateString(String column, String x) throws SQLException {
        this.updateString(this.findColumn(column), x);
    }

    public void updateTime(int column, Time x) throws SQLException {
    }

    public void updateTime(String column, Time x) throws SQLException {
        this.updateTime(this.findColumn(column), x);
    }

    public void updateTimestamp(int column, Timestamp x) throws SQLException {
    }

    public void updateTimestamp(String column, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(column), x);
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    class MockBlob
    implements Blob {
        private byte[] bytes;

        public MockBlob(byte[] bytes) {
            this.bytes = bytes;
        }

        public InputStream getBinaryStream() throws SQLException {
            return null;
        }

        public byte[] getBytes(long pos, int length) throws SQLException {
            return null;
        }

        public long length() throws SQLException {
            return 0L;
        }

        public long position(Blob pattern, long start) throws SQLException {
            return 0L;
        }

        public long position(byte[] pattern, long start) throws SQLException {
            return 0L;
        }

        public OutputStream setBinaryStream(long pos) throws SQLException {
            return null;
        }

        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            return 0;
        }

        public int setBytes(long pos, byte[] bytes) throws SQLException {
            return 0;
        }

        public void truncate(long len) throws SQLException {
        }
    }
}

