/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.mock.sql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.israfil.foundation.mock.sql.DBType;

public class MockResultSetMetaData
implements ResultSetMetaData {
    public static int ZERO_ORDER_LIST_OFFSET = 1;
    List columns;

    MockResultSetMetaData(String[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException("Cannot construct a MockResultSet with no columns.");
        }
        ColSpec[] colspecs = new ColSpec[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            colspecs[i] = new ColSpec(columns[i]);
        }
        this.prepColumns(colspecs);
    }

    MockResultSetMetaData(ColSpec[] columns) {
        this.prepColumns(columns);
    }

    private void prepColumns(ColSpec[] columns) {
        if (columns == null || columns.length <= 0) {
            throw new IllegalArgumentException("Cannot construct a MockResultSet with no columns.");
        }
        this.columns = new ArrayList<ColSpec>(Arrays.asList(columns));
    }

    public void finalize() throws Throwable {
        this.columns = null;
    }

    public int getColumnNumber(String name) {
        for (int i = 1; i <= this.columns.size(); ++i) {
            if (!((ColSpec)this.columns.get((int)(i - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).name.equalsIgnoreCase(name)) continue;
            return i;
        }
        return 0;
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public String getColumnClassName(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).width;
    }

    public String getColumnLabel(int column) throws SQLException {
        if (column < 1) {
            throw new IllegalArgumentException("Column number must be greater than 0.");
        }
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).name;
    }

    public String getColumnName(int column) throws SQLException {
        if (column < 1) {
            throw new IllegalArgumentException("Column number must be greater than 0.");
        }
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).name;
    }

    public int getColumnType(int column) throws SQLException {
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).type.sqltype;
    }

    public String getColumnTypeName(int column) throws SQLException {
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).type.name;
    }

    public int getPrecision(int column) throws SQLException {
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).precision;
    }

    public int getScale(int column) throws SQLException {
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).scale;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public int isNullable(int column) throws SQLException {
        return ((ColSpec)this.columns.get((int)(column - MockResultSetMetaData.ZERO_ORDER_LIST_OFFSET))).nullable ? 1 : 0;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    public boolean isSearchable(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static class ColSpec {
        public final String name;
        public final DBType type;
        public final int width;
        public final int precision;
        public final int scale;
        public final boolean nullable;

        public ColSpec(String name) {
            this.name = name;
            this.type = DBType.types[12];
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = true;
        }

        public ColSpec(String name, boolean nullable) {
            this.name = name;
            this.type = DBType.types[12];
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = nullable;
        }

        public ColSpec(String name, DBType type) {
            this.name = name;
            this.type = type;
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = true;
        }

        public ColSpec(String name, DBType type, boolean nullable) {
            this.name = name;
            this.type = type;
            this.width = 0;
            this.precision = 0;
            this.scale = 0;
            this.nullable = nullable;
        }

        public ColSpec(String name, DBType type, int width) {
            this.name = name;
            this.type = type;
            this.width = width;
            this.precision = 0;
            this.scale = 0;
            this.nullable = true;
        }

        public ColSpec(String name, DBType type, int precision, int scale) {
            this.name = name;
            this.type = type;
            this.precision = precision;
            this.scale = scale;
            this.width = 0;
            this.nullable = true;
        }

        public ColSpec(String name, DBType type, int width, boolean nullable) {
            this.name = name;
            this.type = type;
            this.width = width;
            this.precision = 0;
            this.scale = 0;
            this.nullable = nullable;
        }

        public ColSpec(String name, DBType type, int precision, int scale, boolean nullable) {
            this.name = name;
            this.type = type;
            this.precision = precision;
            this.scale = scale;
            this.width = 0;
            this.nullable = nullable;
        }
    }
}

