/*
 * Decompiled with CFR 0.152.
 */
package net.israfil.foundation.mock.sql;

import java.sql.SQLException;
import java.util.List;
import net.israfil.foundation.mock.sql.MockResultSetMetaData;

public class Row {
    MockResultSetMetaData metadata = null;
    List data;
    int cursorPosition;
    final boolean insertRow;
    public boolean dirty = true;

    public Row(MockResultSetMetaData metadata, List rowData) {
        this(metadata, rowData, false);
    }

    public Row(MockResultSetMetaData metadata, List rowData, boolean isInsertRow) {
        this.metadata = metadata;
        this.data = rowData;
        this.insertRow = isInsertRow;
        this.dirty = false;
    }

    public void finalize() throws Throwable {
        this.data = null;
        this.metadata = null;
        super.finalize();
    }

    public void validateColumn(int i) throws SQLException {
        if (i <= 0 || i > this.metadata.getColumnCount()) {
            throw new SQLException("No such column #" + i);
        }
    }

    public List getData() {
        return this.data;
    }

    public Object get(int i) throws SQLException {
        this.validateColumn(i);
        return this.data.get(i - 1);
    }

    public Object get(String columnName) throws SQLException {
        return this.get(this.metadata.getColumnNumber(columnName));
    }

    public void set(int i, Object o) throws SQLException {
        this.validateColumn(i);
        this.data.set(i - 1, o);
        this.dirty = true;
    }

    public void set(String columnName, Object o) throws SQLException {
        this.set(this.metadata.getColumnNumber(columnName), o);
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

