/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.types;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.java.ao.EntityManager;
import net.java.ao.types.LogicalType;

abstract class AbstractLogicalType<T>
implements LogicalType<T> {
    private final String name;
    private final ImmutableSet<Class<?>> types;
    private final int defaultJdbcWriteType;
    private final ImmutableSet<Integer> jdbcReadTypes;

    protected AbstractLogicalType(String name, Class<?>[] types, int defaultJdbcWriteType, Integer[] jdbcReadTypes) {
        this.name = name;
        this.types = ImmutableSet.copyOf((Object[])types);
        this.defaultJdbcWriteType = defaultJdbcWriteType;
        this.jdbcReadTypes = ImmutableSet.copyOf((Object[])jdbcReadTypes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableSet<Class<?>> getTypes() {
        return this.types;
    }

    @Override
    public int getDefaultJdbcWriteType() {
        return this.defaultJdbcWriteType;
    }

    @Override
    public ImmutableSet<Integer> getJdbcReadTypes() {
        return this.jdbcReadTypes;
    }

    @Override
    public boolean isAllowedAsPrimaryKey() {
        return false;
    }

    @Override
    public Object validate(Object value) throws IllegalArgumentException {
        if (value != null && !this.isSupportedType(value.getClass())) {
            throw new IllegalArgumentException("Value of class " + value.getClass() + " is not valid for column type " + this.getName());
        }
        return this.validateInternal(value);
    }

    private boolean isSupportedType(Class<?> clazz) {
        for (Class type : this.types) {
            if (!type.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    protected T validateInternal(T value) throws IllegalArgumentException {
        return value;
    }

    @Override
    public void putToDatabase(EntityManager manager, PreparedStatement stmt, int index, T value, int jdbcType) throws SQLException {
        stmt.setObject(index, value, jdbcType);
    }

    @Override
    public T pullFromDatabase(EntityManager manager, ResultSet res, Class<T> type, int columnIndex) throws SQLException {
        return this.pullFromDatabase(manager, res, type, res.getMetaData().getColumnName(columnIndex));
    }

    @Override
    public boolean shouldCache(Class<?> type) {
        return true;
    }

    @Override
    public T parse(String input) throws IllegalArgumentException {
        throw new IllegalArgumentException("Cannot parse a string into type " + this.getName());
    }

    @Override
    public T parseDefault(String input) throws IllegalArgumentException {
        return this.parse(input);
    }

    @Override
    public boolean valueEquals(Object value1, Object value2) {
        return Objects.equal((Object)value1, (Object)value2);
    }

    @Override
    public String valueToString(T value) {
        return String.valueOf(value);
    }

    public boolean equals(Object other) {
        return this.getClass() == other.getClass();
    }

    public String toString() {
        return this.getName();
    }
}

